/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.mitsu;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.device.mitsu.MitsuControlRecord;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDTC;
import com.ecmtuning.ecmlink.device.records.BaseField;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.ListBasedTableModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import foxtrot.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListModel;

public class MitsuControlPanel
extends JPanel {
    private final MitsuControlRecord controlRecord;
    private JButton btnUpdateDTC;
    private JButton btnClearDTC;
    HandyJTable tblDTC;
    AbstractAction clearDTCAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(MitsuControlPanel.this.clearDTCTask, true);
        }
    };
    Task clearDTCTask = new Task(){

        public Object run() throws Exception {
            MitsuControlPanel.this.controlRecord.clearDTCs();
            return null;
        }
    };
    AbstractAction updateDTCAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(MitsuControlPanel.this.updateDTCTask, true);
        }
    };
    Task updateDTCTask = new Task(){

        public Object run() throws Exception {
            MitsuControlPanel.this.controlRecord.updateLists();
            return null;
        }
    };
    private final String SETMASK_ACTION_ID = "setMask";

    MitsuControlPanel(MitsuControlRecord mitsuControlRecord) {
        this.controlRecord = mitsuControlRecord;
        this.build();
    }

    MitsuControlRecord getControlRecord() {
        return this.controlRecord;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildControlPanel(), "Center");
    }

    private JPanel buildControlPanel() {
        FormLayout formLayout = new FormLayout("f:d:g", "p, 2dlu, p, 6dlu, p, 2dlu, p, 6dlu, p, 2dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Output tests", cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildSolenoidPanel(), cellConstraints.xy(1, 3));
        panelBuilder.addSeparator("Injector tests", cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.buildInjPanel(), cellConstraints.xy(1, 7));
        panelBuilder.addSeparator("Error codes (DTCs)", cellConstraints.xy(1, 9));
        panelBuilder.add((Component)this.buildDTCPanel(), cellConstraints.xy(1, 11));
        return panelBuilder.getPanel();
    }

    private JPanel buildSolenoidPanel() {
        FormLayout formLayout = new FormLayout("f:d, 0dlu, f:d, 0dlu, f:d, 0dlu, f:d, 0dlu, f:d", "p");
        formLayout.setColumnGroups((int[][])new int[][]{{1, 3, 5, 7, 9}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        BaseField baseField = this.controlRecord.getField("ScanToolCtlMod");
        JToggleButton jToggleButton = this.createToggleButton((ValueModel)baseField, 4, "FPS");
        panelBuilder.add((Component)jToggleButton, cellConstraints.xy(1, 1));
        JToggleButton jToggleButton2 = this.createToggleButton((ValueModel)baseField, 8, "EGR");
        panelBuilder.add((Component)jToggleButton2, cellConstraints.xy(3, 1));
        JToggleButton jToggleButton3 = this.createToggleButton((ValueModel)baseField, 1, "Evap");
        panelBuilder.add((Component)jToggleButton3, cellConstraints.xy(5, 1));
        JToggleButton jToggleButton4 = this.createToggleButton((ValueModel)baseField, 16, "BCS");
        panelBuilder.add((Component)jToggleButton4, cellConstraints.xy(7, 1));
        JToggleButton jToggleButton5 = this.createToggleButton((ValueModel)baseField, 2, "Fuel pump");
        panelBuilder.add((Component)jToggleButton5, cellConstraints.xy(9, 1));
        return panelBuilder.getPanel();
    }

    private JPanel buildInjPanel() {
        FormLayout formLayout = new FormLayout("f:d, 0dlu, f:d, 0dlu, f:d, 0dlu, f:d", "p");
        formLayout.setColumnGroups((int[][])new int[][]{{1, 3, 5, 7}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        BaseField baseField = this.controlRecord.getField("ScanToolCtlMod");
        JToggleButton jToggleButton = this.createToggleButton((ValueModel)baseField, 32, "Inj 1");
        panelBuilder.add((Component)jToggleButton, cellConstraints.xy(1, 1));
        JToggleButton jToggleButton2 = this.createToggleButton((ValueModel)baseField, 64, "Inj 2");
        panelBuilder.add((Component)jToggleButton2, cellConstraints.xy(3, 1));
        JToggleButton jToggleButton3 = this.createToggleButton((ValueModel)baseField, 128, "Inj 3");
        panelBuilder.add((Component)jToggleButton3, cellConstraints.xy(5, 1));
        JToggleButton jToggleButton4 = this.createToggleButton((ValueModel)baseField, 256, "Inj 4");
        panelBuilder.add((Component)jToggleButton4, cellConstraints.xy(7, 1));
        return panelBuilder.getPanel();
    }

    private JPanel buildDTCPanel() {
        ListBasedTableModel listBasedTableModel = new ListBasedTableModel();
        listBasedTableModel.setMinimumRowCount(5);
        listBasedTableModel.addColumn("DTC", (ListModel)this.controlRecord.getListMdlDTCs());
        listBasedTableModel.addColumn("Description", (ListModel)this.controlRecord.getListMdlDTCDescs());
        this.tblDTC = new HandyJTable();
        this.tblDTC.setAutoResizeMode(3);
        this.tblDTC.setUsePreferredSizeAsScrollSize(true);
        this.tblDTC.setModel(listBasedTableModel);
        this.tblDTC.setColumnWidthFromProto(0, "0x00000");
        this.tblDTC.setColumnWidthFromProto(1, MitsuDTC.getDTCDescs(this.controlRecord.getDeviceId(), this.controlRecord.getDefinitionId()));
        this.tblDTC.setColumnAlignments(new int[]{4, 2});
        JPanel jPanel = new JPanel(new BorderLayout(3, 0));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.tblDTC));
        jPanel.add((Component)jScrollPane, "West");
        this.clearDTCAction.putValue("Name", "Clear DTCs");
        this.clearDTCAction.putValue("ShortDescription", "Clears any pending DTCs in the ECU");
        this.updateDTCAction.putValue("Name", "Update DTCs");
        this.updateDTCAction.putValue("ShortDescription", "Updates the view with the latest DTC information from the ECU");
        this.btnClearDTC = new JButton(this.clearDTCAction);
        this.btnUpdateDTC = new JButton(this.updateDTCAction);
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addGlue();
        buttonStackBuilder.addGridded((JComponent)this.btnUpdateDTC);
        buttonStackBuilder.addGridded((JComponent)this.btnClearDTC);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)buttonStackBuilder.getPanel(), "West");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private JToggleButton createToggleButton(ValueModel valueModel, int n, String string) {
        return BasicComponentFactory.createToggleButton((ValueModel)valueModel, (Object)new Float(n), (Object)new Float(0.0f), (String)string);
    }

    void dispatchActionEvent(String string, int n) throws Exception {
        if (string.equals("setMask")) {
            this.controlRecord.setScanToolMask(n);
        }
    }

    private final class DispatchingAction
    extends AbstractAction {
        private String id;
        private int mask;
        private boolean background;

        private DispatchingAction(String string, boolean bl) {
            this.id = string;
            this.mask = 0;
            this.background = bl;
        }

        private DispatchingAction(int n, boolean bl) {
            this.id = "setMask";
            this.mask = n;
            this.background = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(new BackgroundTask(this.id), this.background);
        }

        public class BackgroundTask
        extends Task {
            String id;

            BackgroundTask(String string) {
                this.id = string;
            }

            public Object run() throws Exception {
                MitsuControlPanel.this.dispatchActionEvent(this.id, DispatchingAction.this.mask);
                return null;
            }
        }
    }
}

