/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.mitsu;

import com.ecmtuning.ecmlink.control.AbstractDeviceInfoTab;
import com.ecmtuning.ecmlink.control.mitsu.MitsuControlPanel;
import com.ecmtuning.ecmlink.device.DeviceMap;
import com.ecmtuning.ecmlink.device.mitsu.MitsuControlRecord;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceManager;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.mitsu.MitsuResources;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MitsuDeviceInfoTab
extends AbstractDeviceInfoTab {
    JLabel lblConnectionStatus;
    JLabel lblDeviceID;
    JLabel lblDefinitionID;
    JLabel lblConfigID;
    private final MitsuDeviceManager deviceManager;
    private JPanel mainPanel;
    private JPanel controlPanel = new JPanel();

    public MitsuDeviceInfoTab(MitsuDeviceManager mitsuDeviceManager) {
        super(mitsuDeviceManager);
        this.deviceManager = mitsuDeviceManager;
        this.build();
        this.connectStatusChanged(mitsuDeviceManager.isConnected());
    }

    @Override
    protected String getDeviceTabName() {
        return "Mitsu Info";
    }

    @Override
    protected String getDeviceTabToolTip() {
        return "Basic status and control functionality for the Mitsubishi device manager";
    }

    @Override
    protected JComponent buildBtnStackPanel() {
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        this.connectBtn = DialogUtil.createListButton(MitsuResources.getAction("mitsuConnect"), null, true);
        buttonStackBuilder.addGridded((JComponent)this.connectBtn);
        buttonStackBuilder.addGridded((JComponent)DialogUtil.createListButton("mitsuConfigure", false));
        buttonStackBuilder.addGridded((JComponent)DialogUtil.createListButton("capturedValues", false));
        return buttonStackBuilder.getPanel();
    }

    @Override
    protected JComponent buildMainCenterPanel() {
        FormLayout formLayout = new FormLayout("f:d:g", "p, 6dlu, f:d:g");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)super.buildMainCenterPanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.controlPanel, cellConstraints.xy(1, 3));
        this.mainPanel = panelBuilder.getPanel();
        return this.mainPanel;
    }

    protected synchronized void setControlPanel(JPanel jPanel) {
        CellConstraints cellConstraints = new CellConstraints();
        if (jPanel == null) {
            jPanel = new JPanel();
        }
        this.mainPanel.remove(this.controlPanel);
        this.mainPanel.add((Component)jPanel, cellConstraints.xy(1, 3));
        this.controlPanel = jPanel;
    }

    @Override
    protected void connectStatusChanged(boolean bl) {
        if (bl) {
            int n = this.deviceManager.getSafeDefinitionID();
            if (n == -1) {
                bl = false;
            } else {
                MitsuControlPanel mitsuControlPanel;
                MitsuControlRecord mitsuControlRecord;
                if (this.controlPanel instanceof MitsuControlPanel && (mitsuControlRecord = (mitsuControlPanel = (MitsuControlPanel)this.controlPanel).getControlRecord()).getDefinitionId() == n) {
                    return;
                }
                this.setControlPanel(new MitsuControlPanel(new MitsuControlRecord(this.deviceManager, n)));
            }
        }
        if (!bl) {
            // empty if block
        }
        super.connectStatusChanged(bl);
    }

    @Override
    protected JComponent buildDeviceStatusPanel() {
        this.lblConnectionStatus = new JLabel();
        this.lblDeviceID = new JLabel();
        this.lblDefinitionID = new JLabel();
        this.lblConfigID = new JLabel();
        this.populateStatusLabels();
        FormLayout formLayout = new FormLayout("r:d, 3dlu, l:max(80dlu;d):g", "p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addLabel("Connection status:", cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.lblConnectionStatus, cellConstraints.xy(3, n));
        panelBuilder.addLabel("Device ID:", cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.lblDeviceID, cellConstraints.xy(3, n));
        panelBuilder.addLabel("Definition ID:", cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.lblDefinitionID, cellConstraints.xy(3, n));
        panelBuilder.addLabel("Config ID:", cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.lblConfigID, cellConstraints.xy(3, n));
        return panelBuilder.getPanel();
    }

    @Override
    protected void populateStatusLabels() {
        if (this.deviceManager.isConnected()) {
            this.lblConnectionStatus.setText("CONNECTED");
            try {
                int n = this.deviceManager.getConnectedDeviceId();
                this.lblDeviceID.setText(DeviceMap.getDeviceDisplayName(n));
                this.lblDefinitionID.setText(XFormatter.toHex4(this.deviceManager.getConnectedDefinitionID()));
                this.lblConfigID.setText(XFormatter.toHex4(this.deviceManager.getConnectedConfigID()));
            }
            catch (Exception exception) {
                this.lblDeviceID.setText("ERROR");
                this.lblDefinitionID.setText("ERROR");
                this.lblConfigID.setText("ERROR");
            }
        } else {
            this.lblConnectionStatus.setText("NOT CONNECTED");
            this.lblDeviceID.setText("N/A");
            this.lblDefinitionID.setText("N/A");
            this.lblConfigID.setText("N/A");
        }
    }
}

