/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.mitsu;

import com.ecmtuning.ecmlink.control.DeviceUIAdapterInterface;
import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.mitsu.MitsuDeviceInfoTab;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.DeviceListener;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceManager;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.TrackedTabPanel;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import com.ecmtuning.ecmlink.view.main.MainView;
import com.ecmtuning.ecmlink.view.main.MenuBarView;
import com.ecmtuning.ecmlink.view.main.ToolBarView;
import com.ecmtuning.ecmlink.view.mitsu.MitsuConfigDialog;
import com.ecmtuning.ecmlink.view.mitsu.MitsuResources;
import com.jgoodies.uif.builder.MenuBuilder;
import com.jgoodies.uif.component.ToolBarButton;
import foxtrot.Task;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class MitsuUIAdapter
extends DeviceUIAdapterInterface {
    MitsuDeviceManager deviceManager;
    private final MainModel mainModel;
    private DeviceListener deviceListener = new DeviceListener(){

        @Override
        public void commandSendEnd() {
        }

        @Override
        public void commandSendEndError() {
        }

        @Override
        public void commandSendStart() {
        }

        @Override
        public void connectAttemptEnd() {
        }

        @Override
        public void connectAttemptStart() {
        }

        @Override
        public void connectProgress(int n) {
        }

        @Override
        public void connectStatus(boolean bl) {
            Action action = MitsuResources.getAction("mitsuConnect");
            if (!bl) {
                MitsuResources.configureAction(action, "mitsuConnect");
                ((DispatchingAction)action).setId("mitsuConnect");
            } else {
                MitsuResources.configureAction(action, "mitsuDisconnect");
                ((DispatchingAction)action).setId("mitsuDisconnect");
            }
        }

        @Override
        public void statusTextUpdate(String string) {
        }

        @Override
        public void userRequestEnd() {
        }

        @Override
        public void userRequestStart() {
        }
    };
    private JMenu ecuMenu;
    private boolean actionsRegistered;

    public MitsuUIAdapter() {
        this.mainModel = MainModel.getInstance();
    }

    @Override
    public boolean accept(DeviceManager deviceManager) {
        if (deviceManager instanceof MitsuDeviceManager) {
            this.deviceManager = (MitsuDeviceManager)deviceManager;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsDeviceId(int n) {
        return MitsuDeviceManager.isSupportedDeviceId(n);
    }

    @Override
    public TrackedTabPanel createDeviceInfoTab() {
        return new MitsuDeviceInfoTab(this.deviceManager);
    }

    @Override
    public Action getConnectionConfigurationAction() {
        return null;
    }

    @Override
    public List getGraphViewEditActions(DatalogTab datalogTab, boolean bl) {
        return null;
    }

    @Override
    public List getGraphViewExtActions(DatalogTab datalogTab) {
        return null;
    }

    @Override
    public boolean openFile(File file) {
        return false;
    }

    @Override
    public void activate() {
        this.deviceManager.addDeviceListener(this.deviceListener);
        this.activateActions();
        MainView mainView = this.mainModel.getMainView();
        MenuBarView menuBarView = mainView.getMenuBarView();
        JMenuBar jMenuBar = menuBarView.getMenuBar();
        int n = jMenuBar.getComponentIndex(menuBarView.getHelpMenu());
        jMenuBar.add((Component)this.getECUMenu(), n);
        jMenuBar.validate();
        ToolBarView toolBarView = mainView.getToolBarView();
        JToolBar jToolBar = toolBarView.getToolBar();
        int n2 = jToolBar.getComponentIndex(toolBarView.getLastToolbarComponent()) - 1;
        JToolBar.Separator separator = new JToolBar.Separator(null);
        separator.setOrientation(1);
        jToolBar.add((Component)separator, n2++);
        jToolBar.add((Component)new ToolBarButton(MitsuResources.getAction("mitsuConnect")), n2++);
    }

    private JMenu getECUMenu() {
        if (this.ecuMenu == null) {
            this.ecuMenu = this.buildECUMenu();
        }
        return this.ecuMenu;
    }

    private JMenu buildECUMenu() {
        MenuBuilder menuBuilder = new MenuBuilder("ECU", 'C');
        menuBuilder.add(MitsuResources.getAction("mitsuConnect"));
        menuBuilder.addSeparator();
        menuBuilder.add(MainActions.getAction("capturedValues"));
        menuBuilder.add(MainActions.getAction("startStream"));
        menuBuilder.add(MainActions.getAction("startCapture"));
        menuBuilder.addSeparator();
        menuBuilder.add(MitsuResources.getAction("mitsuConfigure"));
        return menuBuilder.getMenu();
    }

    private void doConnect(boolean bl) throws IOException, DeviceException {
        this.deviceManager.setConnected(bl);
    }

    private void doConfigure() {
        MitsuConfigDialog mitsuConfigDialog = new MitsuConfigDialog((Frame)MainModel.getDefaultParentFrame(), this.deviceManager);
        mitsuConfigDialog.open();
    }

    private synchronized void activateActions() {
        if (!this.actionsRegistered) {
            this.actionsRegistered = true;
            this.register("mitsuConnect", true);
            this.register("mitsuDisconnect", false);
            this.register("mitsuConfigure", false);
        }
    }

    private void register(String string, boolean bl) {
        MitsuResources.registerLazyAction(string, new DispatchingAction(string, bl));
    }

    void dispatchActionEvent(String string) throws Exception {
        if (string.equals("mitsuConnect")) {
            this.doConnect(true);
        } else if (string.equals("mitsuDisconnect")) {
            this.doConnect(false);
        } else if (string.equals("mitsuConfigure")) {
            this.doConfigure();
        }
    }

    private final class DispatchingAction
    extends AbstractAction {
        private String id;
        private boolean background;

        private DispatchingAction(String string, boolean bl) {
            this.id = string;
            this.background = bl;
        }

        private void setId(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(new BackgroundTask(this.id), this.background);
        }

        public class BackgroundTask
        extends Task {
            String id;

            BackgroundTask(String string) {
                this.id = string;
            }

            public Object run() throws Exception {
                MitsuUIAdapter.this.dispatchActionEvent(this.id);
                return null;
            }
        }
    }
}

