/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device;

import com.ecmtuning.ecmlink.device.DeviceCacheData;
import com.ecmtuning.ecmlink.device.DeviceCommand;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.DeviceListener;
import com.ecmtuning.ecmlink.device.DeviceManagerRxThread;
import com.ecmtuning.ecmlink.device.DeviceManagerTxThread;
import com.ecmtuning.ecmlink.device.DevicePort;
import com.ecmtuning.ecmlink.device.SerialPortManager;
import com.ecmtuning.ecmlink.device.data.DeviceDatastreamInterface;
import com.ecmtuning.ecmlink.device.exception.DeviceInterruptedException;
import com.ecmtuning.ecmlink.util.GenericListenerAdapter;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.jgoodies.binding.beans.Model;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public abstract class DeviceManager
extends Model {
    public static final String PROPERTYNAME_DO_PORT_SCAN = "doPortScan";
    public static final String PROPERTYNAME_DO_AUTO_CONNECT = "doAutoConnect";
    public static final String PROPERTYNAME_DO_POLL = "doPoll";
    public static final String PROPERTYNAME_POLLS_PER_MINUTE = "pollsPerMinute";
    public static final String PROPERTYNAME_INITIAL_PORTID = "initialPortId";
    public static final String PROPERTYNAME_REMEMBER_GOOD_PORT = "rememberGoodPort";
    public static final String PROPERTYNAME_CURRENT_PORT = "currentPort";
    public static final String PROPERTYNAME_PORT_CONNECT_STATUS = "portConnectStatus";
    public static final String PROPERTYNAME_DEVICE_CACHE_DATA = "deviceCacheData";
    private static final boolean DEFAULT_DO_PORT_SCAN = true;
    private static final boolean DEFAULT_DO_AUTO_CONNECT = false;
    private static final boolean DEFAULT_DO_POLL = false;
    private static final int DEFAULT_POLLS_PER_MINUTE = 25;
    private static final boolean DEFAULT_REMEMBER_GOOD_PORT = true;
    protected static final long DEFAULT_AUTOCONNECT_MILLIS = 3000L;
    private static final Logger logger = Logger.getLogger(DeviceManager.class.getName());
    private boolean portConnectStatus;
    private boolean doPortScan;
    private boolean doAutoConnect;
    private boolean doPoll;
    private int pollsPerMinute;
    private DeviceManagerTxThread txThread;
    private DeviceManagerRxThread rxThread;
    private String initialPortId;
    private boolean rememberGoodPort;
    private DevicePort currentPort;
    private DeviceCacheData deviceCacheData;
    protected GenericListenerAdapter deviceListeners = new GenericListenerAdapter(DeviceListener.class);
    protected DeviceDatastreamInterface datastreamInterface;
    Object statusTextMutex = new Object();

    protected DeviceManager() {
    }

    void startup() {
        this.rxThread = new DeviceManagerRxThread(this);
        this.rxThread.setDaemon(true);
        this.rxThread.setPriority(1);
        this.rxThread.start();
        this.txThread = new DeviceManagerTxThread(this, this.rxThread);
        this.txThread.setDaemon(true);
        this.txThread.setPriority(1);
        this.txThread.start();
    }

    protected boolean isInTxThread() {
        return Thread.currentThread() == this.txThread;
    }

    public int getConnectedDeviceId() throws IOException, DeviceException {
        return this.device_getConnectedDeviceId();
    }

    public int getConnectedSerialNum() throws IOException, DeviceException {
        return this.device_getConnectedSerialNum();
    }

    public String constructSerialNumDisplayStr(int n) {
        return XFormatter.toHex4(n);
    }

    public int getConnectedFirmwareId() throws IOException, DeviceException {
        return this.device_getConnectedFirmwareId();
    }

    public boolean supportsDeviceId(int n) {
        return this.device_supportsDeviceId(n);
    }

    public DeviceDatastreamInterface getDatastreamInterface() {
        if (this.datastreamInterface == null) {
            this.datastreamInterface = this.device_createDatastreamInterface();
        }
        return this.datastreamInterface;
    }

    public void addDeviceListener(DeviceListener deviceListener) {
        this.deviceListeners.addListener(deviceListener);
    }

    public void removeDeviceListener(DeviceListener deviceListener) {
        this.deviceListeners.removeListener(deviceListener);
    }

    public boolean isConnected() {
        return this.device_isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object manager_sendCommand(DeviceCommand deviceCommand) throws IOException, DeviceException {
        DeviceManagerTxThread.CommandRec commandRec;
        this.deviceListeners.fire("userRequestStart");
        DeviceManagerTxThread.CommandRec commandRec2 = commandRec = new DeviceManagerTxThread.CommandRec(deviceCommand);
        synchronized (commandRec2) {
            this.txThread.addUnsentCommandRec(commandRec);
            try {
                commandRec.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new DeviceInterruptedException("Request to device was interrupted");
            }
            finally {
                this.deviceListeners.fire("userRequestEnd");
            }
        }
        commandRec.rethrowAnyExceptions();
        return commandRec.getResponse();
    }

    public DeviceCacheData getDeviceCacheData() {
        return this.deviceCacheData;
    }

    protected void setDeviceCacheData(DeviceCacheData deviceCacheData) {
        DeviceCacheData deviceCacheData2 = this.deviceCacheData;
        this.deviceCacheData = deviceCacheData;
        this.firePropertyChange(PROPERTYNAME_DEVICE_CACHE_DATA, deviceCacheData2, deviceCacheData);
    }

    public abstract void manager_install();

    protected abstract String device_getDeviceDisplayName(int var1);

    protected abstract boolean device_supportsDeviceId(int var1);

    protected abstract String device_getPreferencesId();

    protected abstract int device_getConnectedDeviceId() throws IOException, DeviceException;

    protected abstract int device_getConnectedSerialNum() throws IOException, DeviceException;

    protected abstract int device_getConnectedFirmwareId() throws IOException, DeviceException;

    protected abstract DeviceDatastreamInterface device_createDatastreamInterface();

    protected abstract Collection device_openConnection(DevicePort var1) throws IOException, DeviceException;

    protected abstract void device_doOpenTask(Object var1) throws IOException, DeviceException;

    protected abstract boolean device_isConnected();

    protected abstract Object device_sendCommand(DeviceCommand var1) throws IOException, DeviceException;

    protected abstract void device_parseAndDispatchRxData(int[] var1, int var2);

    protected abstract void device_poll();

    protected abstract void device_closeConnection();

    protected abstract void device_restoreFrom(Preferences var1);

    protected abstract void device_storeIn(Preferences var1);

    public boolean getDoPortScan() {
        return this.doPortScan;
    }

    public void setDoPortScan(boolean bl) {
        boolean bl2 = this.doPortScan;
        this.doPortScan = bl;
        this.firePropertyChange(PROPERTYNAME_DO_PORT_SCAN, bl2, bl);
    }

    public boolean getDoAutoConnect() {
        return this.doAutoConnect;
    }

    public void setDoAutoConnect(boolean bl) {
        boolean bl2 = this.doAutoConnect;
        this.doAutoConnect = bl;
        this.firePropertyChange(PROPERTYNAME_DO_AUTO_CONNECT, bl2, bl);
    }

    public boolean getDoPoll() {
        return this.doPoll;
    }

    public void setDoPoll(boolean bl) {
        boolean bl2 = this.doPoll;
        this.doPoll = bl;
        this.firePropertyChange(PROPERTYNAME_DO_POLL, bl2, bl);
    }

    public int getPollsPerMinute() {
        return this.pollsPerMinute;
    }

    public void setPollsPerMinute(int n) {
        int n2 = this.pollsPerMinute;
        this.pollsPerMinute = n;
        this.firePropertyChange(PROPERTYNAME_POLLS_PER_MINUTE, n2, n);
    }

    public String getInitialPortId() {
        return this.initialPortId;
    }

    public void setInitialPortId(String string) {
        String string2 = this.initialPortId;
        this.initialPortId = string;
        this.firePropertyChange(PROPERTYNAME_INITIAL_PORTID, string2, string);
    }

    public boolean getRememberGoodPort() {
        return this.rememberGoodPort;
    }

    public void setRememberGoodPort(boolean bl) {
        boolean bl2 = bl;
        this.rememberGoodPort = bl;
        this.firePropertyChange(PROPERTYNAME_REMEMBER_GOOD_PORT, bl2, bl);
    }

    public DevicePort getCurrentPort() {
        return this.currentPort;
    }

    protected void setCurrentPort(DevicePort devicePort) {
        DevicePort devicePort2 = this.currentPort;
        this.currentPort = devicePort;
        this.rxThread.setPort(devicePort);
        if (devicePort2 != devicePort && devicePort2 != null) {
            devicePort2.close();
        }
        if (devicePort2 != null && devicePort == null) {
            this.deviceListeners.fire("connectStatus", false);
            this.setPortConnectStatus(false);
        }
        this.firePropertyChange(PROPERTYNAME_CURRENT_PORT, devicePort2, devicePort);
    }

    protected void setConnectedPort(DevicePort devicePort) {
        this.setCurrentPort(devicePort);
        this.setPortConnectStatus(true);
        this.deviceListeners.fire("connectStatus", true);
        if (this.rememberGoodPort) {
            this.setInitialPortId(devicePort.getPortId());
        }
    }

    public boolean getPortConnectStatus() {
        return this.portConnectStatus;
    }

    private void setPortConnectStatus(boolean bl) {
        boolean bl2 = this.portConnectStatus;
        this.portConnectStatus = bl;
        this.firePropertyChange(PROPERTYNAME_PORT_CONNECT_STATUS, bl2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNewStatusText(String string) {
        Object object = this.statusTextMutex;
        synchronized (object) {
            this.deviceListeners.fire("statusTextUpdate", string);
        }
    }

    public void restoreFrom(Preferences preferences) {
        preferences = preferences.node(this.device_getPreferencesId());
        this.setDoPortScan(preferences.getBoolean(PROPERTYNAME_DO_PORT_SCAN, true));
        this.setDoAutoConnect(preferences.getBoolean(PROPERTYNAME_DO_AUTO_CONNECT, false));
        this.setDoPoll(preferences.getBoolean(PROPERTYNAME_DO_POLL, false));
        this.setPollsPerMinute(preferences.getInt(PROPERTYNAME_POLLS_PER_MINUTE, 25));
        this.setInitialPortId(preferences.get(PROPERTYNAME_INITIAL_PORTID, SerialPortManager.getInstance().getDefaultPlatformPortId()));
        this.setRememberGoodPort(preferences.getBoolean(PROPERTYNAME_REMEMBER_GOOD_PORT, true));
        this.device_restoreFrom(preferences);
    }

    public void storeIn(Preferences preferences) {
        preferences = preferences.node(this.device_getPreferencesId());
        preferences.putBoolean(PROPERTYNAME_DO_PORT_SCAN, this.getDoPortScan());
        preferences.putBoolean(PROPERTYNAME_DO_AUTO_CONNECT, this.getDoAutoConnect());
        preferences.putBoolean(PROPERTYNAME_DO_POLL, this.getDoPoll());
        preferences.putInt(PROPERTYNAME_POLLS_PER_MINUTE, this.getPollsPerMinute());
        preferences.put(PROPERTYNAME_INITIAL_PORTID, this.getInitialPortId());
        preferences.putBoolean(PROPERTYNAME_REMEMBER_GOOD_PORT, this.getRememberGoodPort());
        this.device_storeIn(preferences);
    }
}

