/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device;

import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceMap;
import com.jgoodies.binding.beans.Model;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class DeviceManagerFactory
extends Model {
    public static final String PROPERTYNAME_MAIN_DEVICE_MANAGER = "mainDeviceManager";
    public static final String PROPERTYNAME_AUX_DEVICE_MANAGER = "auxDeviceManager";
    private static final String PROPERTYNAME_MAIN_DEVICE_MANAGER_ID = "mainDeviceManagerId";
    private static final String PROPERTYNAME_AUX_DEVICE_MANAGER_ID = "auxDeviceManagerId";
    private static final int DEFAULT_MAIN_DEVICE_MANAGER_ID = 1;
    private static final Logger logger = Logger.getLogger(DeviceManagerFactory.class.getName());
    int mainDMId;
    int auxDMId;
    private Preferences restorePrefs;
    private DeviceManager mainDM;
    private DeviceManager auxDM;
    private static DeviceManagerFactory instance;
    private static boolean runningAsTools;
    public static final String PROPERTYNAME_MAIN_DM_ID = "mainDMId";
    public static final String PROPERTYNAME_AUX_DM_ID = "auxDMId";

    public static boolean isRunningAsTools() {
        return runningAsTools;
    }

    public static void setRunningAsTools(boolean bl) {
        runningAsTools = bl;
    }

    private DeviceManagerFactory() {
        for (DeviceManager deviceManager : DeviceMap.getAllKnownDeviceManagers()) {
            deviceManager.manager_install();
        }
    }

    public static synchronized DeviceManagerFactory getInstance() {
        if (instance == null) {
            instance = new DeviceManagerFactory();
        }
        return instance;
    }

    public DeviceManager getMainDeviceManager() {
        return this.mainDM;
    }

    public DeviceManager getAuxDeviceManager() {
        return this.auxDM;
    }

    public DeviceManager getActiveDeviceManagerForDevice(int n) {
        DeviceManager deviceManager = null;
        if (this.mainDM != null && this.mainDM.supportsDeviceId(n)) {
            deviceManager = this.mainDM;
        } else if (this.auxDM != null && this.auxDM.supportsDeviceId(n)) {
            deviceManager = this.auxDM;
        }
        return deviceManager;
    }

    public void startUp() {
        this.startupMainDeviceManager();
        this.startupAuxDeviceManagerId();
    }

    private void startupMainDeviceManager() {
        if (this.mainDM != null) {
            throw new IllegalStateException("Can not set new device manager while previous exists");
        }
        this.mainDM = this.restoreDeviceManager(this.restorePrefs, this.mainDMId);
        if (this.mainDM == null) {
            throw new IllegalArgumentException("Main device manager must be set to non-null instance");
        }
        this.mainDM.startup();
        this.firePropertyChange(PROPERTYNAME_MAIN_DEVICE_MANAGER_ID, 0, this.mainDMId);
        this.firePropertyChange(PROPERTYNAME_MAIN_DEVICE_MANAGER, null, (Object)this.mainDM);
    }

    public void startupAuxDeviceManagerId() {
        if (this.auxDM != null) {
            throw new IllegalStateException("Can not set new device manager while previous exists");
        }
        this.auxDM = this.restoreDeviceManager(this.restorePrefs, this.auxDMId);
        if (this.auxDM == null) {
            return;
        }
        this.auxDM.startup();
        this.firePropertyChange(PROPERTYNAME_AUX_DEVICE_MANAGER_ID, 0, this.auxDMId);
        this.firePropertyChange(PROPERTYNAME_AUX_DEVICE_MANAGER, null, (Object)this.auxDM);
    }

    public void restoreFrom(Preferences preferences) {
        this.restorePrefs = preferences = preferences.node("device");
        this.mainDMId = this.validateDeviceManagerId(preferences.getInt(PROPERTYNAME_MAIN_DEVICE_MANAGER_ID, 1));
        this.auxDMId = this.validateDeviceManagerId(preferences.getInt(PROPERTYNAME_AUX_DEVICE_MANAGER_ID, 0));
    }

    public void storeIn(Preferences preferences) {
        preferences = preferences.node("device");
        this.storeDeviceManager(preferences, PROPERTYNAME_MAIN_DEVICE_MANAGER_ID, this.mainDMId, this.mainDM);
        this.storeDeviceManager(preferences, PROPERTYNAME_AUX_DEVICE_MANAGER_ID, this.auxDMId, this.auxDM);
    }

    private void storeDeviceManager(Preferences preferences, String string, int n, DeviceManager deviceManager) {
        preferences.putInt(string, n);
        if (deviceManager != null) {
            deviceManager.storeIn(preferences);
        }
    }

    private DeviceManager restoreDeviceManager(Preferences preferences, int n) {
        DeviceManager deviceManager = DeviceMap.getDeviceManagerByManagerId(n);
        if (deviceManager == null) {
            return null;
        }
        deviceManager.restoreFrom(preferences);
        return deviceManager;
    }

    private int validateDeviceManagerId(int n) {
        if (DeviceMap.getDeviceManagerByManagerId(n) != null) {
            return n;
        }
        if (n != 0) {
            logger.info("Invalid DeviceManager ID: " + n);
        }
        return 0;
    }

    public int getMainDMId() {
        return this.mainDMId;
    }

    public void setMainDMId(int n) {
        int n2 = this.mainDMId;
        this.mainDMId = n;
        this.firePropertyChange(PROPERTYNAME_MAIN_DM_ID, n2, n);
    }

    public int getAuxDMId() {
        return this.auxDMId;
    }

    public void setAuxDMId(int n) {
        int n2 = this.auxDMId;
        this.auxDMId = n;
        this.firePropertyChange(PROPERTYNAME_AUX_DM_ID, n2, n);
    }

    static {
        runningAsTools = false;
    }
}

