/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device;

import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DevicePort;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceManagerRxThread
extends Thread {
    public static final int MAX_BUFFER_SIZE = 1024;
    public static final String RX_THREAD_NAME = "RxThread";
    private DeviceManager deviceManager;
    private boolean backgroundDie = false;
    private Logger logger;
    private final boolean loggingFiner;
    private final boolean loggingFinest;
    private DevicePort currentPort;

    DeviceManagerRxThread(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
        this.setName(RX_THREAD_NAME);
        this.logger = Logger.getLogger(((Object)((Object)deviceManager)).getClass().getName() + ".RxThread");
        this.loggingFiner = this.logger.isLoggable(Level.FINER);
        this.loggingFinest = this.logger.isLoggable(Level.FINEST);
    }

    synchronized void requestStop() {
        this.backgroundDie = true;
        this.interrupt();
        this.notifyAll();
    }

    synchronized void setPort(DevicePort devicePort) {
        this.currentPort = devicePort;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.logger.fine("RxThread started up");
        byte[] byArray = new byte[1024];
        int[] nArray = new int[1024];
        while (true) {
            DevicePort devicePort = null;
            DeviceManagerRxThread deviceManagerRxThread = this;
            synchronized (deviceManagerRxThread) {
                while (this.currentPort == null && !this.backgroundDie) {
                    try {
                        this.logger.finer("RxThread waiting for something to do");
                        this.wait();
                        this.logger.finer("RxThread woke up");
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.info("RxThread wait loop was interrupted: " + interruptedException);
                    }
                }
                if (this.backgroundDie) {
                    this.logger.info(this.deviceManager.device_getPreferencesId() + " shutting down by request");
                    return;
                }
                devicePort = this.currentPort;
            }
            try {
                int n = devicePort.getData(byArray, 0, byArray.length);
                if (devicePort != this.currentPort) {
                    this.logger.finer("Got back from port read with new port installed!");
                    continue;
                }
                if (this.loggingFiner) {
                    this.logger.finest("Read size = " + n);
                }
                if (n < 0) {
                    this.dropCurrentPortIfSameAs(devicePort);
                    continue;
                }
                if (n == 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                for (int i = 0; i < n; ++i) {
                    nArray[i] = byArray[i] & 0xFF;
                    if (!this.loggingFinest) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Input: 0x");
                    stringBuffer.append(XFormatter.toHex2(nArray[i]));
                    stringBuffer.append(" (");
                    stringBuffer.append(Integer.toString(nArray[i]));
                    stringBuffer.append(")");
                    this.logger.finest(stringBuffer.toString());
                }
                this.deviceManager.device_parseAndDispatchRxData(nArray, n);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (IOException iOException) {
                this.dropCurrentPortIfSameAs(devicePort);
                continue;
            }
            break;
        }
    }

    private synchronized void dropCurrentPortIfSameAs(DevicePort devicePort) {
        this.logger.finer("Requested to drop port if same");
        if (devicePort == this.currentPort) {
            this.logger.finer("Port is same, so it's being dropped");
            this.currentPort = null;
        } else {
            this.logger.finer("Port is not same, so it's being kept");
        }
    }
}

