/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device;

import com.ecmtuning.ecmlink.device.DeviceCommand;
import com.ecmtuning.ecmlink.device.DeviceCommandOnlineRequest;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceManagerRxThread;
import com.ecmtuning.ecmlink.device.DeviceMap;
import com.ecmtuning.ecmlink.device.DevicePort;
import com.ecmtuning.ecmlink.device.SerialPortManager;
import com.ecmtuning.ecmlink.device.exception.DeviceScanFailedException;
import com.ecmtuning.ecmlink.device.exception.DeviceUnexpectedException;
import com.ecmtuning.ecmlink.util.GenericListenerAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class DeviceManagerTxThread
extends Thread {
    private static final long MAX_SLEEP_MILLIS = 2500L;
    private DeviceManager deviceManager;
    private GenericListenerAdapter deviceListeners;
    private DeviceManagerRxThread rxThread;
    private boolean backgroundDie = false;
    private ArrayList unsentCommandRecs = new ArrayList();
    private Logger logger;
    public static final String TX_THREAD_NAME = "TxThread";

    DeviceManagerTxThread(DeviceManager deviceManager, DeviceManagerRxThread deviceManagerRxThread) {
        this.setName(TX_THREAD_NAME);
        this.deviceManager = deviceManager;
        this.deviceListeners = deviceManager.deviceListeners;
        this.rxThread = deviceManagerRxThread;
        this.logger = Logger.getLogger(((Object)((Object)deviceManager)).getClass().getName() + ".TxThread");
    }

    synchronized void requestStop() {
        this.backgroundDie = true;
        this.interrupt();
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long l;
        this.logger.fine("TxThread started up");
        CommandRec commandRec = null;
        long l2 = l = System.currentTimeMillis();
        while (true) {
            DeviceManagerTxThread deviceManagerTxThread = this;
            synchronized (deviceManagerTxThread) {
                if (this.unsentCommandRecs.size() == 0 && !this.backgroundDie) {
                    this.waitForSomethingToDo(l, l2);
                }
                if (this.backgroundDie) {
                    this.logger.fine("DeviceManager " + this.deviceManager.device_getPreferencesId() + " shutting down by request");
                    break;
                }
                this.logger.finest("Woke up");
                if (this.unsentCommandRecs.size() != 0) {
                    commandRec = (CommandRec)this.unsentCommandRecs.remove(0);
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Got command to send: " + commandRec.getCommandToSend());
                    }
                } else {
                    commandRec = null;
                }
            }
            long l3 = System.currentTimeMillis();
            boolean bl = commandRec != null;
            boolean bl2 = bl && commandRec.isAutoConnect();
            boolean bl3 = false;
            if (l3 - l >= this.getAutoConnectIntervalMillis()) {
                bl3 = this.deviceManager.getDoAutoConnect();
            }
            boolean bl4 = false;
            if (l3 - l2 >= this.getPollIntervalMillis() - 50L) {
                bl4 = this.deviceManager.getDoPoll();
            }
            boolean bl5 = this.deviceManager.device_isConnected();
            boolean bl6 = false;
            if (!bl5) {
                if (bl2 || bl3) {
                    bl6 = true;
                    this.tryToConnect(commandRec);
                    bl5 = this.deviceManager.device_isConnected();
                    this.logger.finest("tryToConnect returned, shouldContinue = " + bl5);
                    l = System.currentTimeMillis();
                }
            } else {
                l = System.currentTimeMillis();
            }
            if (bl5) {
                if (bl && !commandRec.isOnlineRequest()) {
                    bl6 = true;
                    if (this.tryToSend(commandRec)) {
                        l = System.currentTimeMillis();
                    }
                } else if (bl4) {
                    bl6 = true;
                    this.deviceManager.device_poll();
                }
            }
            if (!bl6) continue;
            l2 = System.currentTimeMillis();
        }
        this.deviceManager.device_closeConnection();
    }

    private void waitForSomethingToDo(long l, long l2) {
        long l3 = System.currentTimeMillis();
        long l4 = this.getAutoConnectIntervalMillis() - (l3 - l);
        l4 = Math.max(0L, l4);
        if (!this.deviceManager.getDoAutoConnect()) {
            l4 = Long.MAX_VALUE;
        }
        long l5 = this.getPollIntervalMillis() - (l3 - l2);
        l5 = Math.max(0L, l5);
        if (!this.deviceManager.getDoPoll()) {
            l5 = Long.MAX_VALUE;
        }
        long l6 = Math.min(l4, l5);
        l6 = Math.min(2500L, l6);
        try {
            if (l6 > 100L) {
                this.logger.finest("DeviceManager sleep thread sleeping for " + l6);
                this.wait(l6);
            } else {
                this.wait(100L);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (InterruptedException interruptedException) {
            this.logger.finest("DeviceManager sleep thread interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToConnect(CommandRec commandRec) {
        this.logger.fine("Attempting to connect to device");
        this.deviceManager.setCurrentPort(null);
        this.deviceListeners.fire("connectAttemptStart");
        try {
            this.bringUpConnection();
            this.logger.finest("bringUpConnection returned OK");
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            this.failUnsentCommand(commandRec, iOException);
        }
        catch (DeviceException deviceException) {
            this.failUnsentCommand(commandRec, deviceException);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
            DeviceUnexpectedException deviceUnexpectedException = new DeviceUnexpectedException(exception);
            this.failUnsentCommand(commandRec, deviceUnexpectedException);
        }
        finally {
            this.deviceListeners.fire("connectAttemptEnd");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bringUpConnection() throws IOException, DeviceException {
        Object object;
        Object object2;
        String string = this.deviceManager.getInitialPortId();
        this.logger.fine("Attempting to connect using initial portId '" + string + "'");
        ArrayList arrayList = null;
        int n = 0;
        int n2 = 0;
        if (DevicePort.getPortTypeForId(string) == DevicePort.TYPE_SOCKET) {
            this.logger.finer("Using a socket as our port");
            arrayList = new ArrayList();
            arrayList.add(string);
        } else {
            this.logger.finer("Using a serial port, scanPorts=" + this.deviceManager.getDoPortScan());
            arrayList = SerialPortManager.getInstance().getUsePortIdList(string);
            n2 = n = arrayList.indexOf(string);
        }
        boolean bl = false;
        if (arrayList.size() == 1) {
            bl = true;
        } else {
            boolean bl2 = bl = !this.deviceManager.getDoPortScan();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            object2 = new StringBuffer();
            object = arrayList.iterator();
            while (object.hasNext()) {
                ((StringBuffer)object2).append(object.next());
                if (!object.hasNext()) continue;
                ((StringBuffer)object2).append(",");
            }
            this.logger.finer("portIdList: " + ((StringBuffer)object2).toString());
            if (bl) {
                this.logger.finer("Trying only once, portIdIndex=" + n);
            } else {
                this.logger.finer("Scanning with portIdIndex=" + n + ", stopIdIndex=" + n2);
            }
        }
        object2 = null;
        object = null;
        boolean bl3 = true;
        float f = 0.0f;
        float f2 = 20.0f / (float)(bl ? 1 : arrayList.size());
        do {
            this.deviceListeners.fire("connectProgress", Math.round(f));
            object = new DevicePort((String)arrayList.get(n));
            this.logger.fine("Trying to connect on " + object);
            this.deviceManager.sendNewStatusText(((DevicePort)object).getPortId() + ": Trying to connect");
            try {
                bl3 = true;
                ((DevicePort)object).open();
                this.logger.fine("Port opened successfully");
                this.deviceManager.setCurrentPort((DevicePort)object);
                object2 = this.deviceManager.device_openConnection((DevicePort)object);
                this.logger.finest("device_openConnection returned OK");
                bl3 = false;
                break;
            }
            catch (IOException iOException) {
                this.recordPortConnectFailure(bl, (DevicePort)object, iOException);
            }
            catch (DeviceException deviceException) {
                this.recordPortConnectFailure(bl, (DevicePort)object, deviceException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.recordPortConnectFailure(bl, (DevicePort)object, exception);
            }
            finally {
                if (bl3) {
                    this.deviceManager.setCurrentPort(null);
                }
            }
            ++n;
            f += f2;
        } while (!bl && n2 != (n %= arrayList.size()));
        if (bl3) {
            throw new DeviceScanFailedException("Scan failed to find a working connection");
        }
        this.deviceManager.setConnectedPort((DevicePort)object);
        f = 20.0f;
        if (object2 != null && object2.size() > 0) {
            this.logger.finest("Sending additional openConnection commands");
            f2 = 80.0f / (float)object2.size();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.deviceListeners.fire("connectProgress", Math.round(f));
                try {
                    String string2 = e.toString();
                    string2 = string2 == null || string2.length() == 0 ? "Connection complete" : "Reading " + string2;
                    this.logger.fine(string2);
                    this.deviceListeners.fire("statusTextUpdate", ((DevicePort)object).getPortId() + ": " + string2);
                    this.deviceManager.device_doOpenTask(e);
                    f += f2;
                }
                catch (IOException iOException) {
                    this.recordPortConnectFailure(true, (DevicePort)object, iOException);
                }
                catch (DeviceException deviceException) {
                    this.recordPortConnectFailure(true, (DevicePort)object, deviceException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.recordPortConnectFailure(true, (DevicePort)object, exception);
                }
            }
        } else {
            this.logger.finest("No additional openConnection commands to send");
        }
        this.logger.finest("Exiting bringUpConnection");
        this.deviceManager.sendNewStatusText(((DevicePort)object).getPortId() + ": Connected (" + DeviceMap.getDeviceDisplayName(this.deviceManager.device_getConnectedDeviceId()) + ")");
        this.deviceListeners.fire("connectProgress", 100);
    }

    private void recordPortConnectFailure(boolean bl, DevicePort devicePort, Exception exception) throws IOException, DeviceException {
        this.logger.fine("Connect on " + devicePort.getPortId() + " failed: " + exception.toString());
        String string = exception.getMessage();
        if (!string.startsWith(devicePort.getPortId())) {
            string = devicePort.getPortId() + ": " + string;
        }
        this.deviceManager.sendNewStatusText(string);
        this.rxThread.setPort(null);
        if (bl) {
            if (exception instanceof IOException) {
                devicePort.close();
                throw (IOException)exception;
            }
            if (exception instanceof DeviceException) {
                throw (DeviceException)exception;
            }
            devicePort.close();
            throw new DeviceUnexpectedException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToSend(CommandRec commandRec) {
        this.logger.finer("Attempting to send command to device");
        boolean bl = false;
        if (!this.trySingleSend(commandRec) && !this.deviceManager.device_isConnected() && commandRec.isAutoConnect()) {
            bl = true;
            if (this.tryToConnect(commandRec)) {
                this.trySingleSend(commandRec);
            }
        }
        CommandRec commandRec2 = commandRec;
        synchronized (commandRec2) {
            commandRec.notifyAll();
        }
        this.logger.finest("tryToSend exiting, didAutoConnect=" + bl);
        return bl;
    }

    private boolean trySingleSend(CommandRec commandRec) throws ThreadDeath {
        boolean bl = false;
        try {
            Object object = this.deviceManager.device_sendCommand(commandRec.getCommandToSend());
            commandRec.setException(null);
            commandRec.setResponse(object);
            bl = true;
        }
        catch (IOException iOException) {
            this.logger.finer("Failed to send command: " + iOException);
            commandRec.setException(iOException);
        }
        catch (DeviceException deviceException) {
            this.logger.finer("Failed to send command: " + deviceException);
            commandRec.setException(deviceException);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
            this.logger.finer("Unexpected failure while sending command: " + exception);
            DeviceUnexpectedException deviceUnexpectedException = new DeviceUnexpectedException(exception);
            commandRec.setException(deviceUnexpectedException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failUnsentCommand(CommandRec commandRec, Exception exception) {
        this.logger.fine("Failing unset command rec " + commandRec + " with exception " + exception.toString());
        if (commandRec != null) {
            CommandRec commandRec2 = commandRec;
            synchronized (commandRec2) {
                commandRec.setException(exception);
                commandRec.notifyAll();
            }
        }
    }

    synchronized void addUnsentCommandRec(CommandRec commandRec) {
        this.unsentCommandRecs.add(commandRec);
        this.notifyAll();
    }

    protected long getPollIntervalMillis() {
        long l = Long.MAX_VALUE;
        if (this.deviceManager.getPollsPerMinute() != 0) {
            l = (long)(60 / this.deviceManager.getPollsPerMinute()) * 1000L;
        }
        return l;
    }

    protected long getAutoConnectIntervalMillis() {
        return 3000L;
    }

    static final class CommandRec {
        private DeviceCommand commandToSend;
        private Exception storedException;
        private Object responseObj;

        CommandRec(DeviceCommand deviceCommand) {
            this.commandToSend = deviceCommand;
        }

        private boolean isOnlineRequest() {
            return this.commandToSend != null && this.commandToSend instanceof DeviceCommandOnlineRequest;
        }

        private boolean isAutoConnect() {
            return this.commandToSend != null && this.commandToSend.getAutoConnect();
        }

        private synchronized DeviceCommand getCommandToSend() {
            return this.commandToSend;
        }

        private synchronized boolean hasException() {
            return this.storedException != null;
        }

        synchronized void rethrowAnyExceptions() throws IOException, DeviceException {
            if (!this.hasException()) {
                return;
            }
            if (this.storedException instanceof IOException) {
                throw (IOException)this.storedException;
            }
            if (this.storedException instanceof DeviceException) {
                throw (DeviceException)this.storedException;
            }
            throw new DeviceUnexpectedException(this.storedException);
        }

        private synchronized void setException(Exception exception) {
            this.storedException = exception;
        }

        private synchronized void setResponse(Object object) {
            this.responseObj = object;
        }

        synchronized Object getResponse() {
            return this.responseObj;
        }
    }
}

