/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device;

import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public final class DeviceMap {
    public static final int NULL_DEVICE_ID = 0;
    public static final int DSMLINK_95DSM_V1_DEVICE_ID = 1;
    public static final int DSMLINK_95DSM_V2_DEVICE_ID = 2;
    public static final int ECMLINK_95DSM_V3_DEVICE_ID = 3;
    public static final int ECMLINK_95DSM_V3LITE_DEVICE_ID = 8;
    public static final int DSMLINK_93DSM_V2_DEVICE_ID = 16;
    public static final int ECMLINK_93DSM_V3_DEVICE_ID = 17;
    public static final int ECMLINK_93DSM_V3LITE_DEVICE_ID = 24;
    public static final int ECMLINK_EVO3_V3LITE_DEVICE_ID = 32;
    public static final int MITSU_PRE95_DEVICE_ID = 0x7F000000;
    public static final int MITSU_97UP_DEVICE_ID = 0x7E000000;
    public static final int MITSU_DEVICE_ID_MASK = -16777216;
    public static final int NULL_DEVICE_MANAGER_ID = 0;
    public static final int ECMLINK_DEVICE_MANAGER_ID = 1;
    public static final int MITSU_DEVICE_MANAGER_ID = 2;
    public static final int NULL_FIRMWARE_ID = -1;
    public static final int MAX_FIRMWARE_ID = 65535;
    private static final Map knownManagers = new Hashtable();
    private static final Logger logger = Logger.getLogger(DeviceMap.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installKnownManagers() {
        Map map = knownManagers;
        synchronized (map) {
            if (knownManagers.isEmpty()) {
                knownManagers.put(new Integer(1), new ECMLinkDeviceManager());
                logger.fine("Installed ECMLink DeviceManager");
                knownManagers.put(new Integer(2), new MitsuDeviceManager());
                logger.fine("Installed Mitsu DeviceManager");
            }
        }
    }

    public static String getDeviceDisplayName(int n) {
        String string = null;
        Iterator iterator = DeviceMap.getAllKnownDeviceManagers().iterator();
        while (string == null && iterator.hasNext()) {
            DeviceManager deviceManager = (DeviceManager)((Object)iterator.next());
            if (!deviceManager.supportsDeviceId(n)) continue;
            string = deviceManager.device_getDeviceDisplayName(n);
        }
        if (string == null) {
            logger.warning("Invalid deviceId: " + n);
            string = "UNKNOWN DEVICE";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getAllKnownDeviceManagers() {
        Map map = knownManagers;
        synchronized (map) {
            DeviceMap.installKnownManagers();
            return Collections.unmodifiableCollection(knownManagers.values());
        }
    }

    public static boolean isValidDeviceId(int n) {
        Iterator iterator = DeviceMap.getAllKnownDeviceManagers().iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            DeviceManager deviceManager = (DeviceManager)((Object)iterator.next());
            bl = deviceManager.device_supportsDeviceId(n);
        }
        return bl;
    }

    public static DeviceManager getDeviceManagerForDevice(int n) {
        for (DeviceManager deviceManager : DeviceMap.getAllKnownDeviceManagers()) {
            if (!deviceManager.device_supportsDeviceId(n)) continue;
            return deviceManager;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceManager getDeviceManagerByManagerId(int n) {
        Map map = knownManagers;
        synchronized (map) {
            DeviceMap.installKnownManagers();
            return (DeviceManager)((Object)knownManagers.get(new Integer(n)));
        }
    }
}

