/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device;

import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.exception.DevicePortClosedException;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;

public class DevicePort {
    public static final PortType TYPE_RXTXPORT = new PortType();
    public static final PortType TYPE_SOCKET = new PortType();
    private final PortType portType;
    private final String portId;
    private Socket socket;
    private InputStream socketIS;
    private OutputStream socketOS;
    private SerialPort rxtxPort;
    private int bitrate;
    private InputStream rxtxIS;
    private OutputStream rxtxOS;
    private static final Logger logger = Logger.getLogger(DevicePort.class.getName());

    public DevicePort(String string) {
        this(DevicePort.getPortTypeForId(string), string);
    }

    public DevicePort(PortType portType, String string) {
        this.portType = portType;
        this.portId = string;
        this.bitrate = 9600;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.rxtxPort != null) {
                this.rxtxPort.close();
            }
            if (this.socket != null && this.socket.isConnected()) {
                this.socket.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void open() throws IOException {
        if (!this.isOpen()) {
            if (this.portType == TYPE_RXTXPORT) {
                this.openRxtxPort();
            } else {
                this.openSocket();
            }
        }
    }

    public synchronized void close() {
        try {
            if (this.isOpen()) {
                this.closeIS(this.rxtxIS);
                this.closeIS(this.socketIS);
                this.closeOS(this.rxtxOS);
                this.closeOS(this.socketOS);
                if (this.rxtxPort != null) {
                    this.rxtxPort.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
        }
        finally {
            this.socket = null;
            this.socketIS = null;
            this.socketOS = null;
            this.rxtxPort = null;
            this.rxtxIS = null;
            this.rxtxOS = null;
        }
    }

    private void closeIS(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeOS(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean isOpen() {
        if (this.portType == TYPE_RXTXPORT) {
            return this.rxtxPort != null;
        }
        if (this.portType == TYPE_SOCKET && this.socket != null) {
            return this.socket.isConnected();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getAvailable() throws IOException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        DevicePort devicePort = this;
        synchronized (devicePort) {
            if (!this.isOpen()) {
                throw new IOException("getAvailable: Port already closed");
            }
            inputStream = this.rxtxIS;
            inputStream2 = this.socketIS;
        }
        if (this.portType == TYPE_RXTXPORT) {
            return inputStream.available();
        }
        return inputStream2.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getData(byte[] byArray, int n, int n2) throws IOException, InterruptedException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        DevicePort devicePort = this;
        synchronized (devicePort) {
            if (!this.isOpen()) {
                throw new IOException("getData: Port already closed");
            }
            inputStream = this.rxtxIS;
            inputStream2 = this.socketIS;
        }
        if (this.portType == TYPE_RXTXPORT) {
            return inputStream.read(byArray, n, n2);
        }
        return inputStream2.read(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putByte(int n) throws IOException, DeviceException {
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        DevicePort devicePort = this;
        synchronized (devicePort) {
            if (!this.isOpen()) {
                throw new DevicePortClosedException("putByte: Port already closed");
            }
            outputStream = this.rxtxOS;
            outputStream2 = this.socketOS;
        }
        if (this.portType == TYPE_RXTXPORT) {
            outputStream.write(n);
            outputStream.flush();
        } else {
            outputStream2.write(n);
            outputStream2.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBytes(int[] nArray, int n, int n2) throws IOException, DeviceException {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[n + i] & 0xFF;
            byArray[i] = n3 > 127 ? (byte)(n3 - 256) : (byte)n3;
        }
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        DevicePort devicePort = this;
        synchronized (devicePort) {
            if (!this.isOpen()) {
                throw new DevicePortClosedException("putByte: Port already closed");
            }
            outputStream = this.rxtxOS;
            outputStream2 = this.socketOS;
        }
        if (this.portType == TYPE_RXTXPORT) {
            outputStream.write(byArray);
            outputStream.flush();
        } else {
            outputStream2.write(byArray);
            outputStream2.flush();
        }
    }

    public synchronized void setBitRate(int n) throws IOException {
        this.bitrate = n;
        if (this.rxtxPort != null) {
            DevicePort.configRxtxPort(this.rxtxPort, this.bitrate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        DevicePort devicePort = this;
        synchronized (devicePort) {
            outputStream = this.rxtxOS;
            outputStream2 = this.socketOS;
        }
        if (this.portType == TYPE_RXTXPORT && outputStream != null) {
            outputStream.flush();
        } else if (outputStream2 != null) {
            outputStream2.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReadBuffer() throws IOException {
        int n;
        InputStream inputStream = null;
        DevicePort devicePort = this;
        synchronized (devicePort) {
            inputStream = this.rxtxIS;
        }
        if (this.portType == TYPE_RXTXPORT && inputStream != null && (n = inputStream.available()) > 0) {
            inputStream.skip(n);
        }
    }

    public synchronized void sendBreak(int n) throws IOException {
        if (this.portType == TYPE_RXTXPORT && this.rxtxPort != null) {
            this.rxtxPort.sendBreak(n);
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void setRTS(boolean bl) throws IOException {
        if (this.portType == TYPE_RXTXPORT && this.rxtxPort != null) {
            this.rxtxPort.setRTS(bl);
        }
    }

    public synchronized boolean supportsRTS() {
        if (this.portType == TYPE_RXTXPORT) {
            return true;
        }
        return this.portType == TYPE_SOCKET;
    }

    public synchronized boolean supportsVariableBitrates() {
        if (this.portType == TYPE_RXTXPORT) {
            return true;
        }
        return this.portType == TYPE_SOCKET;
    }

    public static final PortType getPortTypeForId(String string) {
        PortType portType;
        try {
            Integer.parseInt(string);
            portType = TYPE_SOCKET;
        }
        catch (NumberFormatException numberFormatException) {
            portType = TYPE_RXTXPORT;
        }
        return portType;
    }

    public PortType getPortType() {
        return this.portType;
    }

    public String getPortId() {
        return this.portId;
    }

    public static String[] getPortIdList() throws IOException {
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1) continue;
            arrayList.add(commPortIdentifier.getName());
        }
        return arrayList.toArray(new String[0]);
    }

    protected synchronized void openSocket() throws IOException {
        try {
            int n = Integer.parseInt(this.portId);
            this.socket = new Socket("localhost", n);
            this.socketIS = this.socket.getInputStream();
            this.socketOS = this.socket.getOutputStream();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid port ID specified for socket: " + this.portId);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException("Unknown host exception");
        }
    }

    protected synchronized void openRxtxPort() throws IOException {
        try {
            logger.finer("Attempting to open portId '" + this.portId + "'");
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.portId);
            logger.finest("Got CommPortIdentifier back");
            this.rxtxPort = commPortIdentifier.open("ecmlink", 750);
            logger.finest("Identifier opened, port name = '" + this.rxtxPort.getName() + "'");
            DevicePort.configRxtxPort(this.rxtxPort, this.bitrate);
            logger.finest("Port configured");
            this.rxtxIS = this.rxtxPort.getInputStream();
            this.rxtxOS = this.rxtxPort.getOutputStream();
            try {
                this.rxtxPort.enableReceiveTimeout(500);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {}
        }
        catch (NoSuchPortException noSuchPortException) {
            throw new IOException("Port does not exist in system");
        }
        catch (PortInUseException portInUseException) {
            throw new IOException("Port is in use by app '" + portInUseException.currentOwner + "'");
        }
    }

    protected static void configRxtxPort(SerialPort serialPort, int n) throws IOException {
        try {
            logger.fine("Configuring Rxtx port '" + serialPort.getName() + "' for " + n + " bitrate");
            serialPort.setSerialPortParams(n, 8, 1, 0);
            try {
                serialPort.setFlowControlMode(0);
                serialPort.setRTS(false);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {}
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new IOException("Port declared unsupported COMM operation: " + unsupportedCommOperationException.getLocalizedMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DevicePort{type=");
        if (this.portType == TYPE_RXTXPORT) {
            stringBuffer.append("rxtx");
        } else {
            stringBuffer.append("socket");
        }
        stringBuffer.append(",id=");
        stringBuffer.append(this.portId);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static final class PortType {
        private PortType() {
        }
    }
}

