/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device;

import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.device.DevicePort;
import com.ecmtuning.ecmlink.util.LogUtil;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.list.ArrayListModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class SerialPortManager
extends Model
implements Runnable {
    public static final String PROPERTYNAME_FORCED_PORTID = "forcedPortId";
    public static final String PROPERTYNAME_SKIPPED_PORTID_LIST = "skippedPortIdList";
    public static final String PROPERTYNAME_PORTID_LIST_FROM_OS_MODEL = "portIdListFromOsModel";
    public static final String PROPERTYNAME_DO_BACKGROUND_PORT_SCAN = "doBackgroundPortScan";
    public static final String VALUE_EMPTY_PORTID = "none";
    private String forcedPortID = "none";
    private ArrayList skippedPortIdList = new ArrayList();
    private ArrayListModel portIdListFromOsModel = new ArrayListModel();
    private Thread backgroundThread;
    private boolean doBackgroundPortScan;
    private static final boolean DEFAULT_DO_BACKGROUND_PORT_SCAN = false;
    private Logger logger = Logger.getLogger(SerialPortManager.class.getName());
    private static SerialPortManager instance;
    private static final long SERIAL_PORT_MONITOR_SLEEP_MILLIS = 2500L;

    private SerialPortManager() {
        this.backgroundThread = new Thread(this);
        this.backgroundThread.setName("SerialPortManager");
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.setPriority(1);
        if (!DeviceManagerFactory.isRunningAsTools()) {
            this.backgroundThread.start();
        }
    }

    public static synchronized SerialPortManager getInstance() {
        if (instance == null) {
            instance = new SerialPortManager();
        }
        return instance;
    }

    public boolean getDoBackgroundPortScan() {
        return this.doBackgroundPortScan;
    }

    public void setDoBackgroundPortScan(boolean bl) {
        boolean bl2 = this.doBackgroundPortScan;
        this.doBackgroundPortScan = bl;
        this.firePropertyChange(PROPERTYNAME_DO_BACKGROUND_PORT_SCAN, bl2, bl);
    }

    public String getDefaultPlatformPortId() {
        String string = null;
        try {
            ArrayList arrayList = this.getPortIdList();
            if (arrayList.size() > 0) {
                string = (String)arrayList.get(0);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = "COM1";
        }
        return string;
    }

    public void setForcedPortId(String string) {
        if (string == null) {
            string = VALUE_EMPTY_PORTID;
        }
        if ((string = string.trim().intern()).length() == 0) {
            string = VALUE_EMPTY_PORTID;
        }
        String string2 = this.forcedPortID;
        this.forcedPortID = string;
        this.firePropertyChange(PROPERTYNAME_FORCED_PORTID, string2, string, false);
    }

    public String getForcedPortId() {
        return this.forcedPortID;
    }

    public void setSkippedPortIdList(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList(arrayList);
        Collections.sort(arrayList2);
        this.setSortedSkippedPortIdList(arrayList2);
    }

    private void setSortedSkippedPortIdList(ArrayList arrayList) {
        ArrayList arrayList2 = this.skippedPortIdList;
        this.skippedPortIdList = arrayList;
        this.firePropertyChange(PROPERTYNAME_SKIPPED_PORTID_LIST, arrayList2, arrayList, false);
    }

    public ArrayList getSkippedPortIdList() {
        return this.skippedPortIdList;
    }

    public ArrayListModel getPortIdListFromOsModel() {
        if (this.getDoBackgroundPortScan()) {
            return this.portIdListFromOsModel;
        }
        ArrayListModel arrayListModel = new ArrayListModel();
        try {
            arrayListModel.addAll(Arrays.asList(DevicePort.getPortIdList()));
            Iterator iterator = arrayListModel.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
            }
            Collections.sort(arrayListModel);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayListModel;
    }

    private void setPortIdListFromOsModel(ArrayListModel arrayListModel) {
        this.portIdListFromOsModel.retainAll((Collection)arrayListModel);
        if (this.portIdListFromOsModel.size() == 0) {
            this.portIdListFromOsModel.addAll((Collection)arrayListModel);
        } else {
            int n = arrayListModel.size();
            for (int i = 0; i < n; ++i) {
                if (i >= this.portIdListFromOsModel.getSize()) {
                    this.portIdListFromOsModel.add(arrayListModel.get(i));
                    continue;
                }
                if (arrayListModel.get(i).equals(this.portIdListFromOsModel.get(i))) continue;
                this.portIdListFromOsModel.add(i, arrayListModel.get(i));
            }
        }
        this.firePropertyChange(PROPERTYNAME_PORTID_LIST_FROM_OS_MODEL, null, this.portIdListFromOsModel, true);
    }

    public synchronized ArrayList getPortIdList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll((Collection<String>)this.getPortIdListFromOsModel());
        if (!VALUE_EMPTY_PORTID.equals(this.getForcedPortId())) {
            arrayList.add(this.getForcedPortId());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public ArrayList getUsePortIdList(String string) {
        ArrayList arrayList = this.getPortIdList();
        Iterator iterator = this.skippedPortIdList.iterator();
        while (iterator.hasNext()) {
            arrayList.remove(iterator.next());
        }
        if (string != null && arrayList.indexOf(string) == -1) {
            arrayList.add(string);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info("SerialPortManager background thread started");
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(2500L);
                    if (!this.getDoBackgroundPortScan()) continue;
                    try {
                        Object[] objectArray = DevicePort.getPortIdList();
                        LogUtil.logList(this.logger, Level.FINEST, "Pre-loop port list:", objectArray);
                        arrayList2.clear();
                        for (int i = 0; i < objectArray.length; ++i) {
                            boolean bl = false;
                            try (DevicePort devicePort = new DevicePort((String)objectArray[i]);){
                                devicePort.open();
                                bl = true;
                            }
                            if (!bl) continue;
                            arrayList2.add(objectArray[i]);
                        }
                        Collections.sort(arrayList2);
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    LogUtil.logArrayList(this.logger, Level.FINEST, "Post-loop port list:", arrayList2);
                    if (arrayList2.equals(arrayList)) continue;
                    LogUtil.logArrayList(this.logger, Level.INFO, "New port list from OS:", arrayList2);
                    this.setPortIdListFromOsModel(new ArrayListModel(arrayList2));
                    arrayList.clear();
                    arrayList.addAll(arrayList2);
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.WARNING, "SerialPortMonitor background thread exception", exception);
                continue;
            }
            break;
        }
    }

    public void restoreFrom(Preferences preferences) {
        preferences = preferences.node("serialport");
        this.setForcedPortId(preferences.get(PROPERTYNAME_FORCED_PORTID, VALUE_EMPTY_PORTID).intern());
        this.setSkippedPortIdList(SerialPortManager.decodeArrayList(preferences.get(PROPERTYNAME_SKIPPED_PORTID_LIST, VALUE_EMPTY_PORTID)));
        this.setDoBackgroundPortScan(preferences.getBoolean(PROPERTYNAME_DO_BACKGROUND_PORT_SCAN, false));
    }

    public void storeIn(Preferences preferences) {
        preferences = preferences.node("serialport");
        preferences.put(PROPERTYNAME_FORCED_PORTID, this.getForcedPortId());
        preferences.put(PROPERTYNAME_SKIPPED_PORTID_LIST, SerialPortManager.encodeArrayList(this.getSkippedPortIdList()));
        preferences.putBoolean(PROPERTYNAME_DO_BACKGROUND_PORT_SCAN, this.getDoBackgroundPortScan());
    }

    private static final ArrayList decodeArrayList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((string = string.trim()).equals(VALUE_EMPTY_PORTID) || string.length() == 0) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private static final String encodeArrayList(ArrayList arrayList) {
        if (arrayList.size() == 0) {
            return VALUE_EMPTY_PORTID;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

