/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.device.data.LocationAlias;
import com.ecmtuning.ecmlink.util.FileUtils;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AliasAssignment {
    private final int deviceId;
    private final int serialNumber;
    private final Location deviceLocation;
    private final LocationAlias alias;
    private final String displayNameOverride;
    private final String descriptionOverride;
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = -2871285583388103956L;

    public AliasAssignment(int n, int n2, Location location, LocationAlias locationAlias, String string, String string2) {
        this.deviceId = n;
        this.serialNumber = n2;
        this.deviceLocation = location;
        this.alias = locationAlias;
        this.displayNameOverride = string;
        this.descriptionOverride = string2;
    }

    public Location getDeviceLocation() {
        return this.deviceLocation;
    }

    public LocationAlias getAlias() {
        return this.alias;
    }

    public LocationAlias getFinalAlias() {
        return new LocationAlias(this.getAlias(), this.getDisplayNameOverride(), this.getDescriptionOverride());
    }

    public String getLocationAssignedName() {
        return this.deviceLocation.getAssignedName();
    }

    public String getAliasAssignedName() {
        return this.alias.getAssignedName();
    }

    public String getDisplayNameOverride() {
        return this.displayNameOverride;
    }

    public String getDescriptionOverride() {
        return this.descriptionOverride;
    }

    public String toString() {
        return "AliasAssignment: deviceId " + this.deviceId + ", serial " + XFormatter.toHex4(this.serialNumber) + ", location " + this.deviceLocation.getAssignedName() + ", alias " + this.alias.getAssignedName() + ", displayNameOverride " + this.displayNameOverride + ", desciptionOverride " + this.descriptionOverride;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, -2871285583388103956L, 1);
        dataOutputStream.writeInt(this.deviceId);
        dataOutputStream.writeInt(this.serialNumber);
        this.deviceLocation.write(dataOutputStream);
        this.alias.write(dataOutputStream);
        FileUtils.writeNullableString(this.displayNameOverride, dataOutputStream);
        FileUtils.writeNullableString(this.descriptionOverride, dataOutputStream);
    }

    public static AliasAssignment read(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "Location", -2871285583388103956L, 1);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        Location location = Location.read(dataInputStream);
        LocationAlias locationAlias = LocationAlias.read(dataInputStream);
        String string = FileUtils.readNullableString(dataInputStream);
        String string2 = FileUtils.readNullableString(dataInputStream);
        return new AliasAssignment(n, n2, location, locationAlias, string, string2);
    }
}

