/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.ConverterRecord;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.DisplayChainEntry;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import java.util.List;

class ConverterChainEntry
extends DisplayChainEntry {
    private final ConverterRecord converterRecord;
    private final Converter converter;
    private final DisplayChainEntry[] inputEntries;

    ConverterChainEntry(ConverterRecord converterRecord, DisplayChainEntry[] displayChainEntryArray, boolean bl) {
        super("typeConverter");
        this.converterRecord = converterRecord;
        this.converter = this.converterRecord.getConverter().createCopy();
        if (bl) {
            DisplayChainEntry[] displayChainEntryArray2 = new DisplayChainEntry[displayChainEntryArray.length];
            for (int i = 0; i < displayChainEntryArray2.length; ++i) {
                displayChainEntryArray2[i] = displayChainEntryArray[i].createCopy(this, i);
            }
            this.inputEntries = displayChainEntryArray2;
        } else {
            this.inputEntries = displayChainEntryArray;
        }
    }

    private ConverterChainEntry(ConverterChainEntry converterChainEntry, ConverterChainEntry converterChainEntry2, int n) {
        super("typeConverter", converterChainEntry2, n);
        this.converterRecord = converterChainEntry.converterRecord;
        this.converter = this.converterRecord.getConverter().createCopy();
        int n2 = converterChainEntry.inputEntries.length;
        this.inputEntries = new DisplayChainEntry[n2];
        for (int i = 0; i < n2; ++i) {
            this.inputEntries[i] = converterChainEntry.inputEntries[i].createCopy(this, i);
        }
    }

    @Override
    String getDescriptor() {
        return this.getDescriptor(false);
    }

    @Override
    String getKeyDescriptor() {
        return this.getDescriptor(true);
    }

    @Override
    String getLocalKey() {
        return this.converterRecord.getKey();
    }

    @Override
    void applyOverrides(DisplayChainDesc displayChainDesc) {
        displayChainDesc.applyOverrides(this.converterRecord.getDisplayRecordOverride());
        if (this.inputEntries.length == 1) {
            this.inputEntries[0].applyOverrides(displayChainDesc);
        }
        this.converter.applyOverrides(displayChainDesc);
    }

    @Override
    void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        for (int i = 0; i < this.inputEntries.length; ++i) {
            this.inputEntries[i].addEditPrefsSections(list, dataPreferences);
        }
        this.converter.addEditPrefsSections(list, dataPreferences);
    }

    private String getDescriptor(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(this.converterRecord.getKey());
        stringBuffer.append('(');
        int n = this.inputEntries.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(bl ? this.inputEntries[i].getKeyDescriptor() : this.inputEntries[i].getDescriptor());
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    String getOutputDataType() {
        return this.converterRecord.getOutputDataType();
    }

    @Override
    DisplayChainEntry createCopy(ConverterChainEntry converterChainEntry, int n) {
        return new ConverterChainEntry(this, converterChainEntry, n);
    }

    boolean hasValidInputs() {
        int n = this.inputEntries.length;
        String[] stringArray = this.converterRecord.getInputDataTypes();
        if (n != stringArray.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.inputEntries[i].getOutputDataType().equals(stringArray[i])) {
                return false;
            }
            if (!(this.inputEntries[i] instanceof ConverterChainEntry) || ((ConverterChainEntry)this.inputEntries[i]).hasValidInputs()) continue;
            return false;
        }
        return true;
    }

    final float processData(double d, float f, int n) {
        float f2 = this.converter.receiveInput(d, f, n);
        if (this.nextEntry == null || f2 == Float.MIN_VALUE) {
            return f2;
        }
        return this.nextEntry.processData(d, f2, this.nextEntryBin);
    }

    boolean contains(ConverterRecord converterRecord) {
        if (this.converterRecord == converterRecord) {
            return true;
        }
        for (DisplayChainEntry displayChainEntry : this.inputEntries) {
            if (displayChainEntry.getType() != "typeConverter" || !((ConverterChainEntry)displayChainEntry).contains(converterRecord)) continue;
            return true;
        }
        return false;
    }

    void addEntries(List list, List list2) {
        for (int i = 0; i < this.inputEntries.length; ++i) {
            DisplayChainEntry displayChainEntry = this.inputEntries[i];
            list.add(displayChainEntry);
            if (displayChainEntry.getType() == "typeLocation") {
                list2.add(displayChainEntry);
                continue;
            }
            ((ConverterChainEntry)displayChainEntry).addEntries(list, list2);
        }
    }

    @Override
    void loopReset(DataPreferences dataPreferences) {
        this.converter.loopReset(dataPreferences);
        for (int i = 0; i < this.inputEntries.length; ++i) {
            this.inputEntries[i].loopReset(dataPreferences);
        }
    }
}

