/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DisplayRecord;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.PassThroughConverter;
import com.ecmtuning.ecmlink.util.BasicStrings;

public class ConverterRecord {
    private final String key;
    private final String[] inputTypes;
    private final String outputType;
    private final Converter converter;
    private final DisplayRecord displayOverride;
    private static final String CONV_KEY_PREFIX = DataManager.getKeyPrefixForType(DataManager.TYPE_CONVERTER);

    ConverterRecord(DataObject dataObject) {
        this.key = dataObject.getNodeKey();
        String[] stringArray = BasicStrings.dotSplit(this.key);
        if (stringArray[2].startsWith("_raw_")) {
            throw new IllegalArgumentException("Can't start converter name with _raw_");
        }
        String string = dataObject.getString("input");
        if (string == null) {
            throw new IllegalArgumentException("Missing input type declaration");
        }
        this.inputTypes = BasicStrings.lowerCaseAll(BasicStrings.trimAll(string.split(",")));
        this.outputType = dataObject.getString("output").toLowerCase();
        this.converter = Converter.constructConverter(dataObject);
        int n = this.converter.getNumInputBins();
        if (n != this.inputTypes.length) {
            throw new IllegalArgumentException("Incorrect number of input paramaters, " + n + " needed, " + this.inputTypes.length + " provided.");
        }
        String string2 = DataManager.getStringNameForType(DataManager.TYPE_DISPLAY) + ".";
        DisplayRecord displayRecord = new DisplayRecord(dataObject, string2);
        this.displayOverride = !displayRecord.isEmpty() ? displayRecord : null;
        this.validateConstruct();
    }

    private void validateConstruct() {
        if (this.outputType == null) {
            throw new IllegalArgumentException("Missing output type");
        }
        if (this.inputTypes == null) {
            throw new IllegalArgumentException("Missing input type");
        }
        String string = DataManager.getStringNameForType(DataManager.TYPE_DATATYPE) + ".";
        if (!this.outputType.startsWith(string)) {
            throw new IllegalArgumentException("Invalid output type " + this.outputType);
        }
        if (this.inputTypes.length > 4) {
            throw new IllegalArgumentException("Too many input types.  Max is 4");
        }
        for (int i = 0; i < this.inputTypes.length; ++i) {
            if (this.inputTypes[i].startsWith(string)) continue;
            throw new IllegalArgumentException("Invalid input type " + this.inputTypes[i] + ". Must start with " + string);
        }
    }

    public ConverterRecord(String string) {
        String[] stringArray = BasicStrings.dotSplit(string);
        String string2 = stringArray[1] + "." + "_raw_" + stringArray[2];
        this.key = CONV_KEY_PREFIX + string2;
        this.inputTypes = new String[1];
        this.inputTypes[0] = string;
        this.outputType = stringArray[0] + "." + string2;
        this.converter = PassThroughConverter.getInstance();
        this.displayOverride = null;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getInputDataTypes() {
        return this.inputTypes;
    }

    public String getOutputDataType() {
        return this.outputType;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public boolean hasDisplayRecordOverride() {
        return this.displayOverride != null;
    }

    public DisplayRecord getDisplayRecordOverride() {
        return this.displayOverride;
    }
}

