/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.AliasCandidate;
import com.ecmtuning.ecmlink.device.data.DataFile;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class DataAdapter {
    private static final Logger logger = Logger.getLogger(DataAdapter.class.getName());
    public static final String CONV_CombinedFT = "conv.sys.combinedft";
    public static final String OUTPUTTYPE_RPM = "data.sys.rpm";
    public static final String OUTPUTTYPE_AirPSIA = "data.sys.airpsia";
    public static final String OUTPUTTYPE_LoadFactor = "data.sys.loadfactor";
    public static final String OUTPUTTYPE_SDRatio = "data.sys.sdratio";
    public static final String OUTPUTTYPE_RPMpsiaVE = "data.sys.rpmpsiave";
    public static final String OUTPUTTYPE_SDTempAdj = "data.sys.sdtempadj";
    public static final String OUTPUTTYPE_NoDef = "data.sys.nodef";
    public static final String OUTPUTTYPE_WGSDuty = "data.ecmx.wgsduty";
    public static final String OUTPUTTYPE_WGSGear = "data.ecmx.wgsgear";
    public static final String OUTPUTTYPE_ThrotPos = "data.sys.throtpos";
    private static final List validGroupIds = new ArrayList();

    public String getDeviceFullName() {
        return this.getDeviceAreaName();
    }

    public abstract String getDeviceAreaName();

    protected abstract void installAliasCandidates(Map var1);

    protected abstract void newAliasAssignments(int var1, int var2, List var3);

    public boolean supportsDeviceId(int n) {
        return false;
    }

    public int getLocationDeviceId(int n) {
        return n;
    }

    public static final String getBaseDefinitionPackageName() {
        return DataAdapter.class.getPackage().getName() + ".definitions";
    }

    public String getConverterPackageName() {
        return this.getClass().getPackage().getName();
    }

    public final String getDeviceDefinitionPackageName() {
        return DataAdapter.getBaseDefinitionPackageName() + "." + this.getDeviceAreaName();
    }

    public String adjustFileSpec(String string) {
        return string;
    }

    public boolean parseDeviceFile(DataFile dataFile) {
        return true;
    }

    protected static void installAliasCandidates(int n, Map map, String[] stringArray) {
        ArrayList<AliasCandidate> arrayList = new ArrayList<AliasCandidate>();
        for (int i = 0; i < stringArray.length; i += 2) {
            Location location = DataManager.getLocationByName(n, stringArray[i]);
            String string = stringArray[i + 1];
            if (location != null) {
                arrayList.add(new AliasCandidate(location, validGroupIds, string));
                continue;
            }
            logger.warning("Failed to find location named '" + stringArray[i] + "' for deviceId " + n);
        }
        map.put(new Integer(n), arrayList);
    }

    static {
        validGroupIds.add("5v");
    }
}

