/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.DataAdapter;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataFile
extends HashMap {
    public static final String PROP_NAME_CONVERTER_CONVERTER = "converter";
    public static final String PROP_NAME_CONVERTER_COPY = "copy";
    public static final String PROP_NAME_CONVERTER_OUTPUT = "output";
    public static final String PROP_NAME_CONVERTER_INPUT = "input";
    public static final String PROP_NAME_DISPLAY_VALUEMAP = "valuemap";
    public static final String PROP_NAME_DISPLAY_PRECISION = "prec";
    public static final String PROP_NAME_DISPLAY_GRAPH_MAX = "max";
    public static final String PROP_NAME_DISPLAY_GRAPH_MIN = "min";
    public static final String PROP_NAME_DISPLAY_UNITS = "units";
    public static final String PROP_NAME_ALIAS_GROUP = "group";
    public static final String PROP_NAME_CONSTANT_VALUE = "value";
    public static final String PROP_NAME_LOCATION_SIZE = "size";
    public static final String PROP_NAME_LOCATION_ADDR = "addr";
    public static final String PROP_NAME_LOCATION_MINFWID = "minfwid";
    public static final String PROP_NAME_LOCATION_MAXFWID = "maxfwid";
    public static final String PROP_NAME_DESC = "desc";
    public static final String PROP_NAME_DATA_TYPE = "datatype";
    public static final String PROP_NAME_DISPLAY_NAME = "dispname";
    public static final String PROP_NAME_ALIAS_SELECTION_NAME = "selectionname";
    private Integer fileType;
    private String fileAreaName;
    private static final Logger logger = Logger.getLogger(DataFile.class.getName());
    private static final String FILESPEC_KEY = "filespec";
    private static String[] ALL_LOCATION_PROP_NAMES = new String[]{"dispname", "size", "addr", "datatype", "desc", "minfwid", "maxfwid"};
    private static String[] ALL_CONSTANT_PROP_NAMES = new String[]{"value"};
    private static String[] ALL_ALIAS_PROP_NAMES = new String[]{"dispname", "selectionname", "group", "datatype", "desc"};
    private static String[] ALL_DISPLAY_PROP_NAMES = new String[]{"dispname", "units", "min", "max", "prec", "valuemap"};
    private static String[] ALL_CONVERTER_PROP_NAMES = new String[]{"input", "output", "copy", "converter"};

    public static DataFile parseBundle(ResourceBundle resourceBundle, String string) {
        try {
            Object[] objectArray;
            logger.fine("Parsing '" + string + "'");
            String string2 = null;
            try {
                string2 = resourceBundle.getString(FILESPEC_KEY).trim().toLowerCase().intern();
            }
            catch (MissingResourceException missingResourceException) {
                logger.log(Level.WARNING, "Bundle '" + string + "' is missing " + FILESPEC_KEY + " parameter");
                return null;
            }
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if ((objectArray = string2.split("\\.")).length < 2) {
                logger.log(Level.WARNING, "Bundle '" + string + "' has invalid " + FILESPEC_KEY + " parameter value of '" + string2 + "'");
                return null;
            }
            Integer n = (Integer)DataManager.stringToFileTypeMap.get(objectArray[0]);
            if (n == null || n.equals(DataManager.TYPE_DATATYPE)) {
                logger.log(Level.WARNING, "Bundle '" + string + "' has invalid type specified (" + FILESPEC_KEY + "='" + string2 + "')");
                return null;
            }
            String string3 = objectArray[1];
            DataAdapter dataAdapter = DataManager.getAdapterByArea(string3);
            if (dataAdapter == null) {
                logger.log(Level.WARNING, "Bundle '" + string + "' has invalid area specified (" + FILESPEC_KEY + "='" + string2 + "')");
                return null;
            }
            string2 = dataAdapter.adjustFileSpec(string2);
            DataFile dataFile = new DataFile();
            dataFile.fileType = n;
            dataFile.fileAreaName = string3;
            logger.log(Level.FINE, "File spec = {0}.{1}", objectArray);
            string2 = string2 + ".";
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string4 = enumeration.nextElement();
                String string5 = resourceBundle.getString(string4);
                string4 = string4.toLowerCase().trim().intern();
                string5 = string5.trim().intern();
                if (FILESPEC_KEY.equals(string4)) continue;
                dataFile.put(string2 + string4, string5);
            }
            return dataFile;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to parse bundle '" + string + "'", exception);
            return null;
        }
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        if (object instanceof String) {
            object = ((String)object).toLowerCase();
        }
        return super.containsKey(object);
    }

    @Override
    public synchronized Object get(Object object) {
        if (object instanceof String) {
            object = ((String)object).toLowerCase();
        }
        return super.get(object);
    }

    @Override
    public synchronized Object put(Object object, Object object2) {
        if (object instanceof String) {
            object = ((String)object).toLowerCase();
        }
        logger.finest(object + " = " + object2);
        return super.put(object, object2);
    }

    public Integer getFileType() {
        return this.fileType;
    }

    public boolean isFileType(Integer n) {
        return n.equals(this.getFileType());
    }

    public String getFileAreaName() {
        return this.fileAreaName;
    }

    boolean systemParse() {
        if (this.size() == 0) {
            return true;
        }
        boolean bl = this.isFileType(DataManager.TYPE_LOCATION);
        boolean bl2 = this.isFileType(DataManager.TYPE_CONSTANT);
        boolean bl3 = this.isFileType(DataManager.TYPE_ALIAS);
        boolean bl4 = this.isFileType(DataManager.TYPE_CONVERTER);
        boolean bl5 = this.isFileType(DataManager.TYPE_DISPLAY);
        Collection collection = this.getKeyCopy();
        for (String string : collection) {
            if (!this.containsKey(string)) continue;
            String string2 = (String)this.get(string);
            this.remove(string);
            String[] stringArray = BasicStrings.trimAll(BasicStrings.dotSplit(string));
            boolean bl6 = false;
            if (bl) {
                bl6 = this.systemParseLocationValue(string, stringArray, string2);
            } else if (bl2) {
                bl6 = this.systemParseConstValue(string, stringArray, string2);
            } else if (bl3) {
                bl6 = this.systemParseAliasValue(string, stringArray, string2);
            } else if (bl5) {
                bl6 = this.systemParseDispValue(string, stringArray, string2);
            } else if (bl4) {
                bl6 = this.systemParseConvValue(string, stringArray, string2);
            }
            if (bl6) continue;
            logger.warning("Failed to parse key '" + string + "' = '" + string2 + "'");
        }
        return true;
    }

    protected Collection getKeyCopy() {
        return new ArrayList(this.keySet());
    }

    protected boolean systemParseLocationValue(String string, String[] stringArray, String string2) {
        if (stringArray.length == 4) {
            String[] stringArray2 = BasicStrings.trimAll(string2.split(","));
            if (stringArray2.length == 3) {
                DataObject dataObject = DataObject.getOrCreateObjectNode(string);
                dataObject.put(PROP_NAME_DISPLAY_NAME, stringArray[3]);
                dataObject.put(PROP_NAME_LOCATION_ADDR, stringArray2[0]);
                dataObject.put(PROP_NAME_LOCATION_SIZE, stringArray2[1]);
                dataObject.put(PROP_NAME_DATA_TYPE, stringArray2[2]);
                return true;
            }
            if (stringArray2.length == 4) {
                DataObject dataObject = DataObject.getOrCreateObjectNode(string);
                dataObject.put(PROP_NAME_DISPLAY_NAME, stringArray2[0]);
                dataObject.put(PROP_NAME_LOCATION_ADDR, stringArray2[1]);
                dataObject.put(PROP_NAME_LOCATION_SIZE, stringArray2[2]);
                dataObject.put(PROP_NAME_DATA_TYPE, stringArray2[3]);
                return true;
            }
            if (stringArray2.length == 6) {
                DataObject dataObject = DataObject.getOrCreateObjectNode(string);
                dataObject.put(PROP_NAME_DISPLAY_NAME, stringArray2[0]);
                dataObject.put(PROP_NAME_LOCATION_ADDR, stringArray2[1]);
                dataObject.put(PROP_NAME_LOCATION_SIZE, stringArray2[2]);
                dataObject.put(PROP_NAME_DATA_TYPE, stringArray2[3]);
                dataObject.put(PROP_NAME_LOCATION_MINFWID, stringArray2[4]);
                dataObject.put(PROP_NAME_LOCATION_MAXFWID, stringArray2[5]);
                return true;
            }
            return false;
        }
        if (stringArray.length == 5) {
            return this.parseSimpleNameValue(stringArray, ALL_LOCATION_PROP_NAMES, string2);
        }
        return false;
    }

    private boolean parseSimpleNameValue(String[] stringArray, String[] stringArray2, String string) {
        int n = stringArray.length - 1;
        if (!ListUtil.contains(stringArray2, stringArray[n])) {
            logger.log(Level.WARNING, "Assignment of ''{0}'' = ''{1}'' ignored as unknown key.", new Object[]{BasicStrings.dotMergeFirst(stringArray, n + 1), string});
            return false;
        }
        String string2 = BasicStrings.dotMergeFirst(stringArray, n);
        DataObject dataObject = DataObject.getOrCreateObjectNode(string2);
        dataObject.put(stringArray[n], string.trim());
        return true;
    }

    protected boolean systemParseConstValue(String string, String[] stringArray, String string2) {
        if (stringArray.length == 3) {
            DataObject dataObject = DataObject.getOrCreateObjectNode(string);
            dataObject.put(PROP_NAME_CONSTANT_VALUE, string2.trim());
            return true;
        }
        if (stringArray.length == 4) {
            return this.parseSimpleNameValue(stringArray, ALL_CONSTANT_PROP_NAMES, string2);
        }
        return false;
    }

    protected boolean systemParseAliasValue(String string, String[] stringArray, String string2) {
        if (stringArray.length == 3) {
            String[] stringArray2 = BasicStrings.trimAll(string2.split(","));
            if (stringArray2.length == 4) {
                DataObject dataObject = DataObject.getOrCreateObjectNode(string);
                dataObject.put(PROP_NAME_DISPLAY_NAME, stringArray2[0]);
                dataObject.put(PROP_NAME_ALIAS_SELECTION_NAME, stringArray2[1]);
                dataObject.put(PROP_NAME_ALIAS_GROUP, stringArray2[2]);
                dataObject.put(PROP_NAME_DATA_TYPE, stringArray2[3]);
                return true;
            }
            return false;
        }
        if (stringArray.length == 4) {
            return this.parseSimpleNameValue(stringArray, ALL_ALIAS_PROP_NAMES, string2);
        }
        return false;
    }

    protected boolean systemParseDispValue(String string, String[] stringArray, String string2) {
        if (stringArray.length == 3) {
            String[] stringArray2 = BasicStrings.trimAll(string2.split(","));
            if (stringArray2.length == 5) {
                DataObject dataObject = DataObject.getOrCreateObjectNode(string);
                dataObject.put(PROP_NAME_DISPLAY_NAME, stringArray2[0]);
                dataObject.put(PROP_NAME_DISPLAY_UNITS, stringArray2[1]);
                dataObject.put(PROP_NAME_DISPLAY_GRAPH_MIN, stringArray2[2]);
                dataObject.put(PROP_NAME_DISPLAY_GRAPH_MAX, stringArray2[3]);
                dataObject.put(PROP_NAME_DISPLAY_PRECISION, stringArray2[4]);
                return true;
            }
            return false;
        }
        if (stringArray.length == 4) {
            return this.parseSimpleNameValue(stringArray, ALL_DISPLAY_PROP_NAMES, string2);
        }
        return false;
    }

    protected boolean systemParseConvValue(String string, String[] stringArray, String string2) {
        if (stringArray.length == 4) {
            return this.parseSimpleNameValue(stringArray, ALL_CONVERTER_PROP_NAMES, string2);
        }
        if (stringArray.length > 4) {
            if (stringArray[3].equals(DataManager.getStringNameForType(DataManager.TYPE_DISPLAY))) {
                if (stringArray.length == 5) {
                    if (!ListUtil.contains(ALL_DISPLAY_PROP_NAMES, stringArray[4])) {
                        logger.log(Level.WARNING, "Assignment of ''{0}'' = ''{1}'' ignored as unknown key.", new Object[]{string, string2});
                        return false;
                    }
                    String string3 = BasicStrings.dotMergeFirst(stringArray, 3);
                    DataObject dataObject = DataObject.getOrCreateObjectNode(string3);
                    dataObject.put(BasicStrings.dotMergeFrom(stringArray, 3), string2.trim());
                    return true;
                }
                return false;
            }
            if (stringArray[3].equals(PROP_NAME_CONVERTER_CONVERTER)) {
                String string4 = BasicStrings.dotMergeFirst(stringArray, 3);
                DataObject dataObject = DataObject.getOrCreateObjectNode(string4);
                dataObject.put(BasicStrings.dotMergeFrom(stringArray, 3), string2.trim());
                return true;
            }
            return false;
        }
        return false;
    }
}

