/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.AliasAssignment;
import com.ecmtuning.ecmlink.device.data.ConverterRecord;
import com.ecmtuning.ecmlink.device.data.DataAdapter;
import com.ecmtuning.ecmlink.device.data.DataFile;
import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DisplayRecord;
import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.device.data.LocationAlias;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.device.data.SystemDataAdapter;
import com.ecmtuning.ecmlink.device.data.UserDataAdapter;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.FileUtils;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ResourceLocation;
import com.ecmtuning.ecmlink.util.ResourceLocator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class DataManager {
    public static final Integer TYPE_CONSTANT = new Integer(1);
    public static final Integer TYPE_LOCATION = new Integer(2);
    public static final Integer TYPE_DATATYPE = new Integer(3);
    public static final Integer TYPE_DISPLAY = new Integer(4);
    public static final Integer TYPE_CONVERTER = new Integer(5);
    public static final Integer TYPE_ALIAS = new Integer(6);
    private static final String TYPE_NAME_ALIAS = "alias";
    private static final String TYPE_NAME_CONVERTER = "conv";
    private static final String TYPE_NAME_DISPLAY = "disp";
    private static final String TYPE_NAME_LOCATION = "loc";
    private static final String TYPE_NAME_CONSTANT = "const";
    private static final String TYPE_NAME_DATA = "data";
    protected static final Hashtable stringToFileTypeMap = new Hashtable();
    protected static final Hashtable fileTypeToStringMap = new Hashtable();
    public static final String RAW_NAME_PREFIX = "_raw_";
    private static final String DATA_DIRECTORY_NAME = "data";
    private static Collection allKnownAdapters;
    private static HashMap locationsByDeviceId;
    private static HashMap locationAliasesByGroupID;
    private static HashMap displayRecordsByKey;
    private static HashMap converterRecordsByKey;
    private static HashMap rawConverterRecordsByKey;
    private static HashMap rawDisplayRecordsByKey;
    private static Map aliasCandidatesMap;
    private static final Logger logger;
    private static final boolean fineLoggingOn;
    private static final boolean finestLoggingOn;
    public static final String ALIAS_KEY_PREFIX = "alias.";
    public static final int ALIAS_KEYPARTS_INDEX_LOCNAME = 1;
    public static final int ALIAS_KEYPARTS_INDEX_DEVID = 2;
    public static final int ALIAS_KEYPARTS_INDEX_SERIALNUM = 3;
    public static final int ALIAS_KEYPARTS_INDEX_PARMNAME = 4;
    public static final String ALIAS_PARMNAME_ALIAS_NAME = "aliasname";
    public static final String ALIAS_PARMNAME_GROUP_ID = "groupid";
    public static final String ALIAS_PARMNAME_DISPLAY_NAME = "displayname";
    public static final String ALIAS_PARMNAME_DESC = "desc";
    private static Preferences prefsNode;
    private static boolean initialized;

    public static String getStringNameForType(Integer n) {
        return (String)fileTypeToStringMap.get(n);
    }

    public static String getKeyPrefixForType(Integer n) {
        return DataManager.getStringNameForType(n) + ".";
    }

    public static DataAdapter getAdapterByArea(String string) {
        DataManager.initialize();
        for (DataAdapter dataAdapter : allKnownAdapters) {
            if (!dataAdapter.getDeviceAreaName().equalsIgnoreCase(string)) continue;
            return dataAdapter;
        }
        return null;
    }

    public static synchronized void addKnownDataAdapter(DataAdapter dataAdapter) {
        if (!allKnownAdapters.contains(dataAdapter)) {
            allKnownAdapters.add(dataAdapter);
        }
    }

    public static Collection getAllKnownAdapters() {
        DataManager.initialize();
        return Collections.unmodifiableCollection(allKnownAdapters);
    }

    public static LocationTOC createCompleteTOC(int n, int n2, int n3) {
        ArrayList<LocationTOCEntry> arrayList = new ArrayList<LocationTOCEntry>();
        int n4 = DataManager.getLocationDeviceId(n);
        Collection collection = DataManager.getLocationsForRawDeviceId(n, n3);
        List list = DataManager.getAliasAssignments(n, n2);
        for (Location location : collection) {
            Location location2 = null;
            AliasAssignment aliasAssignment = DataManager.findAssignmentOfLocation(list, location);
            if (aliasAssignment != null) {
                location2 = new Location(location, aliasAssignment.getFinalAlias());
            }
            arrayList.add(new LocationTOCEntry(location, location2, false));
        }
        return new LocationTOC(n4, arrayList);
    }

    public static Location getLocationByName(int n, String string) {
        DataManager.initialize();
        int n2 = DataManager.getLocationDeviceId(n);
        Collection collection = (Collection)locationsByDeviceId.get(new Integer(n2));
        if (collection == null) {
            return null;
        }
        for (Location location : collection) {
            if (!location.getAssignedName().equalsIgnoreCase(string)) continue;
            return location;
        }
        return null;
    }

    public static Location getLocationByAddress(int n, int n2, int n3) {
        DataManager.initialize();
        int n4 = DataManager.getLocationDeviceId(n);
        Collection collection = (Collection)locationsByDeviceId.get(new Integer(n4));
        if (collection == null) {
            return null;
        }
        for (Location location : collection) {
            if (location.getAddress() != n2 || n3 != -1 && (location.getMinFwid() > n3 || location.getMaxFwid() < n3)) continue;
            return location;
        }
        return null;
    }

    private static Collection getLocationsForRawDeviceId(int n, int n2) {
        DataManager.initialize();
        int n3 = DataManager.getLocationDeviceId(n);
        Collection collection = (Collection)locationsByDeviceId.get(new Integer(n3));
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        if (n2 == -1) {
            return Collections.unmodifiableCollection(collection);
        }
        ArrayList<Location> arrayList = new ArrayList<Location>(collection.size());
        for (Location location : collection) {
            if (location.getMinFwid() > n2 || location.getMaxFwid() < n2) continue;
            arrayList.add(location);
        }
        return arrayList;
    }

    private static int getLocationDeviceId(int n) {
        Iterator iterator = allKnownAdapters.iterator();
        int n2 = 0;
        while (n2 == 0 && iterator.hasNext()) {
            DataAdapter dataAdapter = (DataAdapter)iterator.next();
            if (!dataAdapter.supportsDeviceId(n)) continue;
            n2 = dataAdapter.getLocationDeviceId(n);
        }
        return n2;
    }

    public static Collection getLocationAliases(String string) {
        DataManager.initialize();
        Collection collection = (Collection)locationAliasesByGroupID.get(string);
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(collection);
    }

    public static LocationAlias getLocationAlias(String string, String string2) {
        Collection collection = DataManager.getLocationAliases(string);
        if (collection == null) {
            return null;
        }
        for (LocationAlias locationAlias : collection) {
            if (!locationAlias.getAssignedName().equalsIgnoreCase(string2)) continue;
            return locationAlias;
        }
        return null;
    }

    public static Collection getConverterRecords() {
        DataManager.initialize();
        return Collections.unmodifiableCollection(converterRecordsByKey.values());
    }

    public static Collection getDisplayRecords() {
        DataManager.initialize();
        return Collections.unmodifiableCollection(displayRecordsByKey.values());
    }

    public static ConverterRecord getConverterRecord(String string) {
        String[] stringArray;
        DataManager.initialize();
        ConverterRecord converterRecord = (ConverterRecord)converterRecordsByKey.get(string);
        if (converterRecord == null) {
            converterRecord = (ConverterRecord)rawConverterRecordsByKey.get(string);
        }
        if (converterRecord == null && string.indexOf(RAW_NAME_PREFIX) != -1 && (stringArray = BasicStrings.dotSplit(string)).length == 3 && stringArray[2].startsWith(RAW_NAME_PREFIX)) {
            stringArray[0] = "data";
            stringArray[2] = stringArray[2].substring(RAW_NAME_PREFIX.length());
            converterRecord = new ConverterRecord(BasicStrings.dotMergeFirst(stringArray, 3));
            rawConverterRecordsByKey.put(string, converterRecord);
        }
        return converterRecord;
    }

    public static DisplayRecord getDisplayRecordByDataType(String string) {
        DataManager.initialize();
        if (string.startsWith("data")) {
            string = TYPE_NAME_DISPLAY + string.substring("data".length());
        }
        return DataManager._getDisplayRecord(string);
    }

    private static final DisplayRecord _getDisplayRecord(String string) {
        String[] stringArray;
        DisplayRecord displayRecord = (DisplayRecord)displayRecordsByKey.get(string);
        if (displayRecord == null) {
            displayRecord = (DisplayRecord)rawDisplayRecordsByKey.get(string);
        }
        if (displayRecord == null && string.indexOf(RAW_NAME_PREFIX) != -1 && (stringArray = BasicStrings.dotSplit(string)).length == 3 && stringArray[2].startsWith(RAW_NAME_PREFIX)) {
            displayRecord = DataManager.createRawLocationRecord(string);
            rawDisplayRecordsByKey.put(string, displayRecord);
        }
        return displayRecord;
    }

    private static final DisplayRecord createRawLocationRecord(String string) {
        Object object;
        Iterator iterator;
        Collection collection;
        DisplayRecord displayRecord = null;
        String[] stringArray = BasicStrings.dotSplit(string);
        stringArray[0] = "data";
        stringArray[2] = stringArray[2].substring(RAW_NAME_PREFIX.length());
        String string2 = BasicStrings.dotMergeFirst(stringArray, 3);
        Collection collection2 = locationsByDeviceId.values();
        Iterator iterator2 = collection2.iterator();
        while (displayRecord == null && iterator2.hasNext()) {
            collection = (Collection)iterator2.next();
            iterator = collection.iterator();
            while (displayRecord == null && iterator.hasNext()) {
                object = (Location)iterator.next();
                if (!((Location)object).getDataType().equals(string2)) continue;
                displayRecord = new DisplayRecord(string, ((Location)object).getDisplayName(), 0.0f, (float)Math.pow(2.0, ((Location)object).getSize()) - 1.0f, "raw", 0);
            }
        }
        if (displayRecord == null) {
            collection = DataManager.getLocationAliases("5v");
            iterator = collection.iterator();
            while (displayRecord == null && iterator.hasNext()) {
                object = (LocationAlias)iterator.next();
                if (!((LocationAlias)object).getDataType().equals(string2)) continue;
                displayRecord = new DisplayRecord(string, ((LocationAlias)object).getDisplayName(), 0.0f, 5.0f, "v", 2);
            }
        }
        if (displayRecord == null) {
            displayRecord = new DisplayRecord(string, stringArray[2], 0.0f, 256.0f, "raw", 0);
        }
        return displayRecord;
    }

    public static List getAliasCandidates(int n) {
        DataManager.initialize();
        int n2 = DataManager.getLocationDeviceId(n);
        List list = (List)aliasCandidatesMap.get(new Integer(n2));
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(list);
    }

    public static synchronized List getAliasAssignments(int n, int n2) {
        ArrayList<AliasAssignment> arrayList = new ArrayList<AliasAssignment>();
        int n3 = DataManager.getLocationDeviceId(n);
        Preferences preferences = DataManager.getDataPrefsNode();
        String string = Integer.toString(n3);
        String string2 = Integer.toString(n2);
        List list = DataManager.getAliasKeysForDevice(string, string2);
        for (String string3 : list) {
            String[] stringArray = BasicStrings.dotSplit(string3);
            Location location = DataManager.getLocationByName(n3, stringArray[1]);
            if (location == null) {
                logger.warning("Found invalid location name '" + stringArray[1] + "' in key '" + string3 + "'");
                preferences.remove(string3);
                continue;
            }
            if (!ALIAS_PARMNAME_ALIAS_NAME.equalsIgnoreCase(stringArray[4])) continue;
            String string4 = BasicStrings.dotMergeFirst(stringArray, stringArray.length - 1);
            String string5 = preferences.get(string3, null);
            if (string5 == null) {
                logger.warning("Got null value for key '" + string3 + "'");
                preferences.remove(string3);
                continue;
            }
            String string6 = preferences.get(string4 + "." + ALIAS_PARMNAME_GROUP_ID, "5v");
            LocationAlias locationAlias = DataManager.getLocationAlias(string6, string5);
            if (locationAlias == null) {
                logger.warning("Failed to find alias named '" + string5 + "' in group '" + string6 + "'");
                preferences.remove(string3);
                continue;
            }
            String string7 = BasicStrings.nullIfEmpty(preferences.get(string4 + "." + ALIAS_PARMNAME_DISPLAY_NAME, null));
            String string8 = BasicStrings.nullIfEmpty(preferences.get(string4 + "." + ALIAS_PARMNAME_DESC, null));
            AliasAssignment aliasAssignment = new AliasAssignment(n3, n2, location, locationAlias, string7, string8);
            arrayList.add(aliasAssignment);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAliasAssignments(int n, int n2, List list) {
        int n3 = DataManager.getLocationDeviceId(n);
        Class<DataManager> clazz = DataManager.class;
        synchronized (DataManager.class) {
            Object object3;
            Object object22 = DataManager.getDataPrefsNode();
            String string = Integer.toString(n3);
            String string2 = Integer.toString(n2);
            List list2 = DataManager.getAliasKeysForDevice(string, string2);
            for (Object object3 : list2) {
                ((Preferences)object22).remove((String)object3);
            }
            object3 = list.iterator();
            while (object3.hasNext()) {
                AliasAssignment aliasAssignment = (AliasAssignment)object3.next();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Processing new assignment, " + aliasAssignment.toString());
                }
                try {
                    String string3 = ALIAS_KEY_PREFIX + aliasAssignment.getLocationAssignedName() + "." + string + "." + string2;
                    ((Preferences)object22).put(string3 + "." + ALIAS_PARMNAME_ALIAS_NAME, aliasAssignment.getAlias().getAssignedName());
                    ((Preferences)object22).put(string3 + "." + ALIAS_PARMNAME_GROUP_ID, aliasAssignment.getAlias().getGroupID());
                    if (!BasicStrings.isNullOrEmpty(aliasAssignment.getDisplayNameOverride())) {
                        ((Preferences)object22).put(string3 + "." + ALIAS_PARMNAME_DISPLAY_NAME, aliasAssignment.getDisplayNameOverride());
                    }
                    if (BasicStrings.isNullOrEmpty(aliasAssignment.getDescriptionOverride())) continue;
                    ((Preferences)object22).put(string3 + "." + ALIAS_PARMNAME_DESC, aliasAssignment.getDescriptionOverride());
                }
                catch (Exception exception) {
                    object3.remove();
                    logger.log(Level.WARNING, "Failed to record alias assignment!", exception);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (Object object22 : DataManager.getAllKnownAdapters()) {
                ((DataAdapter)object22).newAliasAssignments(n3, n2, Collections.unmodifiableList(list));
            }
            return;
        }
    }

    public static AliasAssignment findAssignmentOfLocation(List list, Location location) {
        for (AliasAssignment aliasAssignment : list) {
            if (!aliasAssignment.getDeviceLocation().equals(location)) continue;
            return aliasAssignment;
        }
        return null;
    }

    private static List getAliasKeysForDevice(String string, String string2) {
        Preferences preferences = DataManager.getDataPrefsNode();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = preferences.keys();
            List list = ListUtil.getAllPrefix(stringArray, ALIAS_KEY_PREFIX);
            for (String string3 : list) {
                String[] stringArray2 = BasicStrings.dotSplit(string3);
                if (stringArray2.length != 5) {
                    logger.warning("Found invalid alias key '" + string3 + "' in user preferences");
                    preferences.remove(string3);
                    continue;
                }
                if (!string.equals(stringArray2[2]) || !string2.equals(stringArray2[3])) continue;
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to query alias assignments", exception);
        }
        return arrayList;
    }

    public static synchronized Preferences getDataPrefsNode() {
        if (prefsNode == null) {
            prefsNode = Preferences.userRoot().node("ecmtuning/ecmlink/data");
        }
        return prefsNode;
    }

    public static synchronized void setApplicationPreferencesNode(Preferences preferences) {
        if (prefsNode == null) {
            prefsNode = preferences.node("data");
        }
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        long l = System.currentTimeMillis();
        logger.fine("Initialization started");
        allKnownAdapters.add(new SystemDataAdapter());
        allKnownAdapters.add(new UserDataAdapter());
        logger.fine("(1) Loading configuration files for installed device adapters.");
        for (DataAdapter dataAdapter : allKnownAdapters) {
            List list = null;
            try {
                list = DataManager.findNamedBundles(dataAdapter);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Failed to list resource files in the " + dataAdapter.getDeviceFullName() + " ('" + dataAdapter.getDeviceAreaName() + "') area!", exception);
                continue;
            }
            for (NamedBundle namedBundle : list) {
                logger.fine("Processing " + namedBundle.bundleName);
                try {
                    DataFile dataFile = DataFile.parseBundle(namedBundle.bundle, namedBundle.bundleName);
                    if (dataFile != null && dataAdapter.parseDeviceFile(dataFile) && dataFile.systemParse()) continue;
                    logger.warning("Failed to load '" + namedBundle.bundleName + "' configuration file in the " + dataAdapter.getDeviceFullName() + " ('" + dataAdapter.getDeviceAreaName() + "') area!");
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Failed to load '" + namedBundle.bundleName + "' configuration file in the " + dataAdapter.getDeviceFullName() + " ('" + dataAdapter.getDeviceAreaName() + "') area!", exception);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        if (fineLoggingOn) {
            logger.fine("Finished loading configuration files for all installed device adapters.  Time from (1) above = " + (l2 - l) + "ms");
        }
        try {
            DataManager.resolveConstants();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to resolve constants!", exception);
        }
        try {
            DataManager.resolveConverterCopies();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to resolve converter copies!", exception);
        }
        l2 = System.currentTimeMillis();
        if (fineLoggingOn) {
            logger.fine("Constants and copy resolved.  Time from (1) above = " + (l2 - l) + "ms");
        }
        DataManager.createDatabaseObjects(TYPE_LOCATION);
        DataManager.createDatabaseObjects(TYPE_ALIAS);
        DataManager.createDatabaseObjects(TYPE_DISPLAY);
        DataManager.createDatabaseObjects(TYPE_CONVERTER);
        for (Object object : allKnownAdapters) {
            ((DataAdapter)object).installAliasCandidates(aliasCandidatesMap);
        }
    }

    private static List findNamedBundles(DataAdapter dataAdapter) throws ClassNotFoundException, IOException {
        ArrayList<NamedBundle> arrayList;
        block7: {
            block6: {
                logger.fine("Loading " + dataAdapter.getDeviceFullName() + " configuration files");
                arrayList = new ArrayList<NamedBundle>();
                if (!(dataAdapter instanceof UserDataAdapter)) break block6;
                String string = FilenameModel.buildUserResourcesPath() + File.separator + "data";
                File file = new File(string);
                if (!file.exists() || !file.isDirectory()) break block7;
                Collection collection = FileUtils.listResourceProperties(string);
                for (String string2 : collection) {
                    String string3 = string + File.separator + string2 + ".properties";
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
                        PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(bufferedInputStream);
                        arrayList.add(new NamedBundle(string3, propertyResourceBundle));
                        bufferedInputStream.close();
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "Failed to load '" + string3 + "'.  Ignoring.", exception);
                    }
                }
                break block7;
            }
            String string = dataAdapter.getDeviceDefinitionPackageName();
            ResourceLocator resourceLocator = new ResourceLocator(new String[]{string}, ".properties");
            List list = resourceLocator.getAllResourceLocations();
            for (ResourceLocation resourceLocation : list) {
                String string4 = resourceLocation.getResourceName();
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string4, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
                    arrayList.add(new NamedBundle(string4, resourceBundle));
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "'" + string4 + "' failed to load.  Ignoring.", exception);
                }
            }
        }
        return arrayList;
    }

    private static void createDatabaseObjects(Integer n) {
        boolean bl = TYPE_LOCATION.equals(n);
        boolean bl2 = TYPE_ALIAS.equals(n);
        boolean bl3 = TYPE_CONVERTER.equals(n);
        boolean bl4 = TYPE_DISPLAY.equals(n);
        String string = DataManager.getKeyPrefixForType(n);
        Collection collection = DataObject.nodeKeysWithPrefix(string);
        for (String string2 : collection) {
            if (finestLoggingOn) {
                logger.finest("Instantiating " + string2);
            }
            DataObject dataObject = DataObject.removeObjectNode(string2);
            try {
                Object object;
                if (bl) {
                    object = new Location(dataObject);
                    DataManager.addLocation((Location)object);
                    continue;
                }
                if (bl2) {
                    object = new LocationAlias(dataObject);
                    DataManager.addLocationAlias((LocationAlias)object);
                    continue;
                }
                if (bl4) {
                    object = new DisplayRecord(dataObject);
                    DataManager.addDisplayRecord((DisplayRecord)object);
                    continue;
                }
                if (!bl3) continue;
                object = new ConverterRecord(dataObject);
                DataManager.addConverterRecord((ConverterRecord)object);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Failed to create record " + string2, exception);
            }
        }
    }

    private static void addLocation(Location location) {
        Integer n = new Integer(location.getDeviceId());
        ArrayList<Location> arrayList = (ArrayList<Location>)locationsByDeviceId.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<Location>();
            locationsByDeviceId.put(n, arrayList);
        }
        arrayList.add(location);
    }

    private static void addLocationAlias(LocationAlias locationAlias) {
        String string = locationAlias.getGroupID();
        ArrayList<LocationAlias> arrayList = (ArrayList<LocationAlias>)locationAliasesByGroupID.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<LocationAlias>();
            locationAliasesByGroupID.put(string, arrayList);
        }
        arrayList.add(locationAlias);
    }

    private static void addDisplayRecord(DisplayRecord displayRecord) {
        displayRecordsByKey.put(displayRecord.getKey(), displayRecord);
    }

    private static void addConverterRecord(ConverterRecord converterRecord) {
        converterRecordsByKey.put(converterRecord.getKey(), converterRecord);
    }

    private static void resolveConverterCopies() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = DataManager.getKeyPrefixForType(TYPE_CONVERTER);
        Collection collection = DataObject.nodeKeysWithPrefix(string);
        for (Object object : collection) {
            DataObject object2 = DataObject.getObjectNode((String)object);
            if (!object2.keySet().contains("copy")) continue;
            String string2 = (String)object2.remove("copy");
            String string3 = ((String)object).substring(0, ((String)object).lastIndexOf(46) + 1) + string2;
            DataObject dataObject = DataObject.getObjectNode(string3);
            if (dataObject == null) {
                logger.warning("Failed to find '" + string3 + "' for copy defined in '" + (String)object + "'.");
                DataObject.removeObjectNode((String)object);
                continue;
            }
            if (finestLoggingOn) {
                logger.finest("Copying properties from '" + string3 + "' to '" + (String)object + "'");
            }
            object2.copyUndefinedFrom(dataObject);
            arrayList.add(string3);
        }
        for (String string4 : arrayList) {
            if (finestLoggingOn) {
                logger.finest("Done with and now removing copy source '" + string4 + "'");
            }
            DataObject.removeObjectNode(string4);
        }
    }

    private static void resolveConstants() {
        Map map = DataManager.generateConstantsMap();
        String string = DataManager.getKeyPrefixForType(TYPE_CONSTANT);
        Iterator iterator = DataObject.objectItr();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            for (String string2 : dataObject.keySet()) {
                String string3 = dataObject.getString(string2);
                if (string3.indexOf(string) == -1) continue;
                String string4 = BasicStrings.replaceAll(string3, map);
                if (string4.indexOf(string) != -1) {
                    logger.log(Level.INFO, "Possibly missing a constant definition in " + dataObject.getNodeKey() + ", key=" + string2 + ", value=" + string3);
                }
                dataObject.put(string2, string4);
                if (!finestLoggingOn) continue;
                logger.log(Level.FINEST, "Replaced constants oldValue='" + string3 + "', newValue='" + string4 + "'");
            }
        }
        map.clear();
    }

    private static Map generateConstantsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = DataManager.getKeyPrefixForType(TYPE_CONSTANT);
        Collection collection = DataObject.nodeKeysWithPrefix(string);
        for (String string2 : collection) {
            DataObject dataObject = DataObject.removeObjectNode(string2);
            String string3 = dataObject.getString("value");
            if (finestLoggingOn) {
                logger.log(Level.FINEST, "Recording constant '" + string2 + "' = '" + string3 + "'");
            }
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    static {
        stringToFileTypeMap.put(TYPE_NAME_CONSTANT, TYPE_CONSTANT);
        fileTypeToStringMap.put(TYPE_CONSTANT, TYPE_NAME_CONSTANT);
        stringToFileTypeMap.put(TYPE_NAME_LOCATION, TYPE_LOCATION);
        fileTypeToStringMap.put(TYPE_LOCATION, TYPE_NAME_LOCATION);
        stringToFileTypeMap.put(TYPE_NAME_DISPLAY, TYPE_DISPLAY);
        fileTypeToStringMap.put(TYPE_DISPLAY, TYPE_NAME_DISPLAY);
        stringToFileTypeMap.put(TYPE_NAME_CONVERTER, TYPE_CONVERTER);
        fileTypeToStringMap.put(TYPE_CONVERTER, TYPE_NAME_CONVERTER);
        stringToFileTypeMap.put(TYPE_NAME_ALIAS, TYPE_ALIAS);
        fileTypeToStringMap.put(TYPE_ALIAS, TYPE_NAME_ALIAS);
        stringToFileTypeMap.put("data", TYPE_DATATYPE);
        fileTypeToStringMap.put(TYPE_DATATYPE, "data");
        allKnownAdapters = new ArrayList();
        locationsByDeviceId = new HashMap();
        locationAliasesByGroupID = new HashMap();
        displayRecordsByKey = new HashMap();
        converterRecordsByKey = new HashMap();
        rawConverterRecordsByKey = new HashMap();
        rawDisplayRecordsByKey = new HashMap();
        aliasCandidatesMap = new HashMap();
        logger = Logger.getLogger(DataManager.class.getName());
        fineLoggingOn = logger.isLoggable(Level.FINE);
        finestLoggingOn = logger.isLoggable(Level.FINEST);
        prefsNode = null;
        initialized = false;
    }

    private static class NamedBundle {
        final String bundleName;
        final ResourceBundle bundle;

        NamedBundle(String string, ResourceBundle resourceBundle) {
            this.bundleName = string;
            this.bundle = resourceBundle;
        }
    }
}

