/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DataObject
extends HashMap {
    protected static final Map globalObjects = new HashMap();
    private static final Logger logger = Logger.getLogger(DataObject.class.getName());
    private static final boolean finestLoggingOn = logger.isLoggable(Level.FINEST);
    protected final String nodeKey;

    public static synchronized DataObject getOrCreateObjectNode(String string) {
        string = string.intern();
        logger.log(Level.FINEST, "Retrieving object at node ''{0}''", string);
        DataObject dataObject = (DataObject)globalObjects.get(string);
        if (dataObject == null) {
            dataObject = new DataObject(string);
            globalObjects.put(string, dataObject);
            logger.log(Level.FINEST, "Created new object at node ''{0}''", string);
        }
        return dataObject;
    }

    public static synchronized DataObject getObjectNode(String string) {
        return (DataObject)globalObjects.get(string);
    }

    private DataObject(String string) {
        this.nodeKey = string.toLowerCase();
    }

    public static synchronized boolean hasObjectNode(String string) {
        return globalObjects.containsKey(string);
    }

    public static synchronized DataObject removeObjectNode(String string) {
        if (finestLoggingOn) {
            logger.finest("Removing '" + string + "'");
        }
        return (DataObject)globalObjects.remove(string);
    }

    public static synchronized Iterator nodeKeyItr() {
        return globalObjects.keySet().iterator();
    }

    public static synchronized Iterator objectItr() {
        return globalObjects.values().iterator();
    }

    public static synchronized Collection nodeKeysWithPrefix(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = DataObject.nodeKeyItr();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public String getNodeKey() {
        return this.nodeKey;
    }

    void copyUndefinedFrom(DataObject dataObject) {
        if (finestLoggingOn) {
            logger.finest("'" + this.getNodeKey() + "' copying undefined properties from '" + dataObject.getNodeKey() + "'");
        }
        for (String string : dataObject.keySet()) {
            if (this.containsKey(string)) continue;
            this.put(string, dataObject.get(string));
        }
    }

    public synchronized String getString(Object object) {
        return (String)this.get(object);
    }

    public synchronized Integer getInteger(Object object) {
        return this.getInteger(object, null);
    }

    public synchronized Integer getInteger(Object object, Integer n) {
        String string = this.getString(object);
        if (string == null) {
            return n;
        }
        return Integer.decode(string);
    }

    public synchronized Float getFloat(Object object) {
        return this.getFloat(object, null);
    }

    public synchronized Float getFloat(Object object, Float f) {
        String string = this.getString(object);
        if (string == null) {
            return f;
        }
        return DataObject.decodeFloat(string);
    }

    public static final Float decodeFloat(String string) {
        if (string.indexOf(120) != -1 || string.indexOf(88) != -1 || string.indexOf(35) != -1) {
            return new Float(Integer.decode(string).intValue());
        }
        return Float.valueOf(string);
    }

    @Override
    public synchronized Object get(Object object) {
        Object v = super.get(object);
        if (finestLoggingOn) {
            logger.log(Level.FINEST, "{0} get ''{1}'' = ''{2}''", new Object[]{this.nodeKey, object, v});
        }
        return v;
    }

    @Override
    public synchronized Object put(Object object, Object object2) {
        Object object3 = super.put(object, object2);
        if (finestLoggingOn) {
            logger.log(Level.FINEST, "{0} put ''{1}'' = ''{2}''", new Object[]{this.nodeKey, object, object2});
        }
        return object3;
    }
}

