/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class DataPreferences
extends AbstractPreferences {
    public static final String NODE_TYPE_CONVERTER = "converters";
    public static final String NODE_TYPE_VIEW = "views";
    public static final String NODE_TYPE_DISPLAY_VALUES = "displayvalues";
    protected final String keyPrefix;
    protected final Preferences prefsNode;
    private Logger logger = Logger.getLogger(DataPreferences.class.getName());

    public DataPreferences(String string, Preferences preferences) {
        super(null, "");
        if (string == null) {
            string = "";
        } else if (!string.endsWith(".")) {
            string = string + '.';
        }
        this.keyPrefix = string;
        this.prefsNode = preferences;
    }

    public static DataPreferences getPreferences(DisplayChainDesc displayChainDesc) {
        return new DataPreferences(displayChainDesc.getPrefsKeyPrefix(), DataManager.getDataPrefsNode().node(NODE_TYPE_DISPLAY_VALUES));
    }

    public static DataPreferences getConverterPreferences() {
        return new DataPreferences(null, DataManager.getDataPrefsNode().node(NODE_TYPE_CONVERTER));
    }

    public static DataPreferences getViewPreferences(String string) {
        return new DataPreferences(null, DataManager.getDataPrefsNode().node(NODE_TYPE_VIEW).node(string));
    }

    public List keysList() {
        try {
            return Arrays.asList(this.keys());
        }
        catch (BackingStoreException backingStoreException) {
            this.logger.log(Level.WARNING, "Preferences exception while enumerating keys.  Ignoring.", backingStoreException);
            return new ArrayList();
        }
    }

    public void renameKey(String string, String string2) {
        if (this.get(string, null) != null) {
            this.put(string2, this.get(string, null));
            this.remove(string);
        }
    }

    public void removeAll(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.keysList()) {
            if (string != null && !string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.remove((String)iterator.next());
        }
    }

    public void becomeCopyOf(DataPreferences dataPreferences) {
        this.removeAll(null);
        for (String string : dataPreferences.keysList()) {
            String string2 = dataPreferences.get(string, null);
            if (string2 == null) continue;
            this.put(string, string2);
        }
    }

    public void copyValuesFrom(DataPreferences dataPreferences, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = dataPreferences.get(string, null);
            if (string2 == null) {
                this.remove(string);
                continue;
            }
            this.put(string, string2);
        }
    }

    public Color getColor(String string, Color color) {
        Color color2 = color;
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                color2 = DataPreferences.convertToColor(string2);
                if (color2 == null) {
                    color2 = color;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return color2;
    }

    private static Color convertToColor(String string) {
        try {
            int n = XFormatter.fromHex(string, true);
            return new Color(n, n > 0xFFFFFF);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String convertFromColor(Color color) {
        return ("0x" + XFormatter.toHex8(color.getRGB())).toLowerCase();
    }

    public void putColor(String string, Color color) {
        if (color == null) {
            this.remove(string);
        } else {
            this.put(string, DataPreferences.convertFromColor(color));
        }
    }

    public Color[] getColors(String string, Color[] colorArray) {
        String[] stringArray = this.getStringArray(string, null);
        if (stringArray == null) {
            return colorArray;
        }
        int n = stringArray.length;
        Color[] colorArray2 = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray2[i] = DataPreferences.convertToColor(stringArray[i]);
            if (colorArray2[i] != null) continue;
            colorArray2 = colorArray;
            break;
        }
        return colorArray2;
    }

    public void putColors(String string, Color[] colorArray) {
        if (colorArray == null) {
            this.remove(string);
        } else {
            int n = colorArray.length;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = DataPreferences.convertFromColor(colorArray[i]);
            }
            this.putStringArray(string, stringArray);
        }
    }

    public Font getFont(String string, Font font) {
        Font font2 = font;
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                font2 = Font.decode(string2);
                if (font2 == null) {
                    font2 = font;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return font2;
    }

    public void putFont(String string, Font font) {
        if (font == null) {
            this.remove(string);
        } else {
            this.put(string, this.convertFromFont(font));
        }
    }

    private String convertFromFont(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append('-');
        if (!font.isBold() && !font.isItalic()) {
            stringBuffer.append("plain");
        } else {
            stringBuffer.append(font.isBold() ? "bold" : "").append(font.isItalic() ? "italic" : "");
        }
        stringBuffer.append('-');
        stringBuffer.append(font.getSize());
        return stringBuffer.toString();
    }

    public String[] getStringArray(String string, String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = this.getInt(string + ".len", -1);
        if (n >= 0) {
            String[] stringArray3 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray3[i] = this.get(string + "." + XFormatter.padZero(i + 1, 2), null);
                if (stringArray3[i] != null) continue;
                stringArray3 = stringArray;
                break;
            }
            stringArray2 = stringArray3;
        }
        return stringArray2;
    }

    public void putStringArray(String string, String[] stringArray) {
        this.removeAll(string + ".");
        if (stringArray != null) {
            this.putInt(string + ".len", stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.put(string + "." + XFormatter.padZero(i + 1, 2), stringArray[i]);
            }
        }
    }

    public List getDisplayChains(String string, List list) {
        String[] stringArray = this.getStringArray(string, null);
        if (stringArray == null) {
            return list;
        }
        ArrayList<DisplayChain> arrayList = new ArrayList<DisplayChain>();
        for (int i = 0; i < stringArray.length; ++i) {
            DisplayChain displayChain = DisplayChain.createChainFromSpec(stringArray[i]);
            if (displayChain == null) continue;
            arrayList.add(displayChain);
        }
        if (arrayList.size() == 0) {
            return list;
        }
        return arrayList;
    }

    public void putDisplayChains(String string, List list) {
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String[] stringArray2 : list) {
            if (stringArray2 == null) continue;
            arrayList.add(stringArray2.getCurrentChainSpec());
        }
        stringArray2 = arrayList.toArray(new String[0]);
        this.putStringArray(string, stringArray2);
    }

    @Override
    protected String getSpi(String string) {
        return this.prefsNode.get(this.keyPrefix + string, null);
    }

    @Override
    protected void putSpi(String string, String string2) {
        this.prefsNode.put(this.keyPrefix + string, string2);
    }

    @Override
    protected void removeSpi(String string) {
        this.prefsNode.remove(this.keyPrefix + string);
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        if (this.keyPrefix.length() == 0) {
            try {
                return this.prefsNode.keys();
            }
            catch (BackingStoreException backingStoreException) {
                this.logger.log(Level.WARNING, "Preferences exception while enumerating keys.  Ignoring.", backingStoreException);
                return new String[0];
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (String string : Arrays.asList(this.prefsNode.keys())) {
                if (!string.startsWith(this.keyPrefix) || string.equals(this.keyPrefix)) continue;
                arrayList.add(string.substring(this.keyPrefix.length()));
            }
        }
        catch (BackingStoreException backingStoreException) {
            this.logger.log(Level.WARNING, "Preferences exception while enumerating keys.  Ignoring.", backingStoreException);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    protected AbstractPreferences childSpi(String string) {
        return null;
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return null;
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        this.prefsNode.flush();
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.prefsNode.removeNode();
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        this.prefsNode.sync();
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.prefsNode.addPreferenceChangeListener(preferenceChangeListener);
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.prefsNode.removePreferenceChangeListener(preferenceChangeListener);
    }
}

