/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.MemoryBackedPreferences;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DatalogFile {
    private static final int FILE_VERSION = 2;
    private static final long FILE_MARKER = 8989711178806555646L;
    private final Dataset dataset;
    private final DataPreferences converterPrefs;
    private final long datasetTimestamp;
    private String notes = "";
    private File saveFile;

    public DatalogFile(Dataset dataset, DataPreferences dataPreferences, long l, File file) {
        this.dataset = dataset;
        this.converterPrefs = dataPreferences;
        this.saveFile = file;
        this.datasetTimestamp = l;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public DataPreferences getConverterPrefs() {
        return this.converterPrefs;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void save() throws IOException {
        this.writeToFile(this.saveFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatalogFile load(File file) throws IOException {
        try (FilterInputStream filterInputStream = null;){
            InputStream inputStream = null;
            try {
                inputStream = new GZIPInputStream(new FileInputStream(file));
            }
            catch (IOException iOException) {
                inputStream = new FileInputStream(file);
            }
            filterInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            int n = FileUtils.readFileVersion((DataInputStream)filterInputStream, "DatalogFile", 8989711178806555646L, 2);
            long l = file.lastModified();
            String string = "";
            if (n >= 2) {
                l = ((DataInputStream)filterInputStream).readLong();
                string = ((DataInputStream)filterInputStream).readUTF();
            }
            MemoryBackedPreferences memoryBackedPreferences = MemoryBackedPreferences.read((DataInputStream)filterInputStream);
            Dataset dataset = Dataset.read((DataInputStream)filterInputStream);
            DatalogFile datalogFile = new DatalogFile(dataset, new DataPreferences(null, memoryBackedPreferences), l, file);
            datalogFile.setNotes(string);
            DatalogFile datalogFile2 = datalogFile;
            return datalogFile2;
        }
    }

    public void writeToFile(File file) throws IOException {
        File file2 = file == null ? this.saveFile : file;
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file2))));
        FileUtils.writeMarkerAndVersion(dataOutputStream, 8989711178806555646L, 2);
        dataOutputStream.writeLong(this.datasetTimestamp);
        dataOutputStream.writeUTF(this.notes);
        MemoryBackedPreferences.write(dataOutputStream, this.converterPrefs);
        if (file == null) {
            this.getDataset().write(dataOutputStream, this);
        } else {
            this.getDataset().write(dataOutputStream, null);
            dataOutputStream.close();
        }
    }

    public void saveAs(File file) throws IOException {
        this.writeToFile(file);
        this.saveFile = file;
    }
}

