/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.DatalogFile;
import com.ecmtuning.ecmlink.device.data.DatasetListener;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.util.FileUtils;
import com.ecmtuning.ecmlink.util.GenericListenerAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class Dataset
implements Serializable {
    private boolean liveDataset;
    private LocationTOC mainDataTOC;
    private LocationTOC auxDataTOC;
    private ArrayList mainData;
    private ArrayList auxData;
    private DeviceConfigData mainConfigData;
    private DeviceConfigData auxConfigData;
    private GenericListenerAdapter listenerAdapter = new GenericListenerAdapter(DatasetListener.class);
    private Collection listeners = this.listenerAdapter.getListeners();
    private static Logger logger = Logger.getLogger(Dataset.class.getName());
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = -1661500088796167515L;
    DataOutputStream liveOs;
    DatalogFile liveDatalog;

    public Dataset() {
        this.liveDataset = true;
    }

    protected Dataset(LocationTOC locationTOC, ArrayList arrayList, DeviceConfigData deviceConfigData, LocationTOC locationTOC2, ArrayList arrayList2, DeviceConfigData deviceConfigData2) {
        this.liveDataset = false;
        this.mainDataTOC = locationTOC;
        this.mainData = arrayList;
        this.mainConfigData = deviceConfigData;
        this.auxDataTOC = locationTOC2;
        this.auxData = arrayList2;
        this.auxConfigData = deviceConfigData2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStreamState(boolean bl) {
        Dataset dataset = this;
        synchronized (dataset) {
            if (!bl) {
                this.closeFileStream();
            }
        }
        this.listenerAdapter.fire(bl ? "streamStart" : "streamStop");
    }

    public void addDatasetListener(DatasetListener datasetListener) {
        this.listenerAdapter.addListener(datasetListener);
    }

    public void removeDatasetListener(DatasetListener datasetListener) {
        this.listenerAdapter.removeListener(datasetListener);
    }

    public boolean isLiveDataset() {
        return this.liveDataset;
    }

    public LocationTOC getMainDataTOC() {
        return this.mainDataTOC;
    }

    public LocationTOC getAuxDataTOC() {
        return this.auxDataTOC;
    }

    public boolean hasMainData() {
        return this.mainData != null;
    }

    public boolean hasAuxData() {
        return this.auxData != null;
    }

    public ArrayList getMainData() {
        return this.mainData;
    }

    public ArrayList getAuxData() {
        return this.auxData;
    }

    public DeviceConfigData getMainConfigData() {
        return this.mainConfigData;
    }

    public DeviceConfigData getAuxConfigData() {
        return this.auxConfigData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(LocationTOC locationTOC, LocationTOC locationTOC2, DeviceConfigData deviceConfigData, DeviceConfigData deviceConfigData2) {
        if (!this.isLiveDataset()) {
            throw new IllegalStateException("Reset called on an offline Dataset");
        }
        Dataset dataset = this;
        synchronized (dataset) {
            boolean bl = locationTOC != null;
            boolean bl2 = locationTOC2 != null;
            this.mainDataTOC = bl ? new LocationTOC(locationTOC) : null;
            this.auxDataTOC = bl2 ? new LocationTOC(locationTOC2) : null;
            this.mainConfigData = bl ? deviceConfigData : null;
            this.auxConfigData = bl2 ? deviceConfigData2 : null;
            this.mainData = bl ? new ArrayList() : null;
            this.auxData = bl2 ? new ArrayList() : null;
        }
        this.listenerAdapter.fireMethod("reset", DatasetListener.PARAMETER_TYPES_RESET, new Object[]{this.mainDataTOC, this.auxDataTOC});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newDataReceived(boolean bl, List list) {
        Object object = this;
        synchronized (object) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList = bl ? this.mainData : this.auxData;
            if (arrayList == null) {
                return;
            }
            arrayList.addAll(list);
            if (this.liveOs != null) {
                try {
                    Dataset.writePackets(bl, list, this.liveOs);
                }
                catch (IOException iOException) {
                    logger.warning("Datalog stopped, " + iOException.toString());
                    this.closeFileStream();
                }
            }
        }
        object = this.listeners.iterator();
        while (object.hasNext()) {
            ((DatasetListener)object.next()).streamDataReceived(bl, list);
        }
    }

    public synchronized void closeFileStream() {
        if (this.liveOs != null) {
            try {
                this.liveOs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.liveOs = null;
            this.liveDatalog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clipData(double d, double d2) {
        Dataset dataset = this;
        synchronized (dataset) {
            TSDataPacket tSDataPacket;
            if (!this.hasAuxData() && !this.hasMainData()) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.copyPacketsBetweenTimes(this.mainData, arrayList, d, d2);
            this.copyPacketsBetweenTimes(this.auxData, arrayList2, d, d2);
            double d3 = Double.MAX_VALUE;
            if (this.mainData != null) {
                this.mainData.clear();
                if (arrayList.size() > 0) {
                    tSDataPacket = (TSDataPacket)arrayList.get(0);
                    if (tSDataPacket.timestampMicros < d3) {
                        d3 = tSDataPacket.timestampMicros;
                    }
                }
            }
            if (this.auxData != null) {
                this.auxData.clear();
                if (arrayList2.size() > 0) {
                    tSDataPacket = (TSDataPacket)arrayList2.get(0);
                    if (tSDataPacket.timestampMicros < d3) {
                        d3 = tSDataPacket.timestampMicros;
                    }
                }
            }
            if (d3 != Double.MAX_VALUE) {
                this.copyPacketsWithOffset(arrayList, this.mainData, -d3);
                this.copyPacketsWithOffset(arrayList2, this.auxData, -d3);
            }
            arrayList.clear();
            arrayList2.clear();
        }
        this.listenerAdapter.fire("timeChanged");
    }

    private void copyPacketsBetweenTimes(List list, List list2, double d, double d2) {
        if (list == null || list2 == null || list.size() == 0) {
            return;
        }
        for (TSDataPacket tSDataPacket : list) {
            if (!(tSDataPacket.timestampMicros >= d) || !(tSDataPacket.timestampMicros <= d2)) continue;
            list2.add(tSDataPacket);
        }
    }

    private void copyPacketsWithOffset(List list, List list2, double d) {
        if (list == null || list2 == null || list.size() == 0) {
            return;
        }
        for (TSDataPacket tSDataPacket : list) {
            list2.add(new TSDataPacket(tSDataPacket, d));
        }
    }

    public DatalogFile getLiveDatalog() {
        return this.liveDatalog;
    }

    public synchronized void write(DataOutputStream dataOutputStream, DatalogFile datalogFile) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, -1661500088796167515L, 1);
        Dataset.writeTOCandConfig(dataOutputStream, this.mainDataTOC, this.mainConfigData);
        Dataset.writeTOCandConfig(dataOutputStream, this.auxDataTOC, this.auxConfigData);
        Dataset.writeData(true, this.mainData, dataOutputStream);
        Dataset.writeData(false, this.auxData, dataOutputStream);
        if (datalogFile != null) {
            this.liveOs = dataOutputStream;
            this.liveDatalog = datalogFile;
        }
    }

    private static final void writeTOCandConfig(DataOutputStream dataOutputStream, LocationTOC locationTOC, DeviceConfigData deviceConfigData) throws IOException {
        if (locationTOC == null) {
            dataOutputStream.writeBoolean(false);
        } else if (deviceConfigData == null) {
            logger.warning("Failed to write out Dataset due to inconsisent state.  Has TOC but no configData.");
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            locationTOC.write(dataOutputStream);
            deviceConfigData.write(dataOutputStream);
        }
    }

    private static final void writeData(boolean bl, List list, DataOutputStream dataOutputStream) throws IOException {
        if (list == null) {
            return;
        }
        for (TSDataPacket tSDataPacket : list) {
            dataOutputStream.writeBoolean(bl);
            tSDataPacket.write(dataOutputStream);
        }
    }

    private static final void writePackets(boolean bl, List list, DataOutputStream dataOutputStream) throws IOException {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeBoolean(bl);
            ((TSDataPacket)list.get(i)).write(dataOutputStream);
        }
    }

    public static final Dataset read(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "Dataset", -1661500088796167515L, 1);
        boolean bl = dataInputStream.readBoolean();
        LocationTOC locationTOC = null;
        ArrayList<TSDataPacket> arrayList = null;
        DeviceConfigData deviceConfigData = null;
        if (bl) {
            locationTOC = LocationTOC.read(dataInputStream);
            deviceConfigData = DeviceConfigData.read(dataInputStream);
            arrayList = new ArrayList<TSDataPacket>();
        }
        boolean bl2 = dataInputStream.readBoolean();
        LocationTOC locationTOC2 = null;
        ArrayList<TSDataPacket> arrayList2 = null;
        DeviceConfigData deviceConfigData2 = null;
        if (bl2) {
            locationTOC2 = LocationTOC.read(dataInputStream);
            deviceConfigData2 = DeviceConfigData.read(dataInputStream);
            arrayList2 = new ArrayList<TSDataPacket>();
        }
        try {
            while (true) {
                boolean bl3 = dataInputStream.readBoolean();
                TSDataPacket tSDataPacket = TSDataPacket.read(dataInputStream);
                if (bl3) {
                    arrayList.add(tSDataPacket);
                    continue;
                }
                arrayList2.add(tSDataPacket);
            }
        }
        catch (EOFException eOFException) {
            return new Dataset(locationTOC, arrayList, deviceConfigData, locationTOC2, arrayList2, deviceConfigData2);
        }
    }
}

