/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DatastreamListener;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.data.DeviceDatastreamInterface;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.exception.DeviceInternalException;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidStateException;
import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public final class DatasetManager
extends Model {
    public static final String PROPERTYNAME_STREAMING = "streaming";
    public static final String PROPERTYNAME_SCREEN_UPDATE_HZ = "screenupdatehz";
    public static final String PROPERTYNAME_MAIN_TOC = "mainTOC";
    public static final String PROPERTYNAME_AUX_TOC = "auxTOC";
    private boolean streaming = false;
    private float screenUpdateHz;
    private static final float DEFAULT_SCREEN_UPDATE_HZ = 10.0f;
    public static final int MAX_MANAGER_COUNT = 2;
    public static final int MAIN_DEVICE_INDEX = 0;
    public static final int AUX_DEVICE_INDEX = 1;
    private final DeviceManager[] managers;
    private final DeviceDatastreamInterface[] datastreamInterfaces;
    private final Dataset liveDataset;
    private LocationTOC mainTOC;
    private LocationTOC auxTOC;
    private static DatasetManager instance;
    private static Object createMutex;
    private static final Logger logger;
    private static final boolean LOGFINE;
    PropertyChangeListener deviceFactoryListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = false;
            if ("mainDeviceManager".equals(propertyChangeEvent.getPropertyName())) {
                bl = true;
            } else if (!"auxDeviceManager".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (propertyChangeEvent.getNewValue() == null || !(propertyChangeEvent.getNewValue() instanceof DeviceManager)) {
                logger.warning("DatasetManager received invalid DeviceManager instance, " + propertyChangeEvent.getNewValue());
                return;
            }
            DeviceManager deviceManager = (DeviceManager)((Object)propertyChangeEvent.getNewValue());
            DeviceDatastreamInterface deviceDatastreamInterface = deviceManager.getDatastreamInterface();
            if (deviceDatastreamInterface == null) {
                return;
            }
            int n = 0;
            if (!bl) {
                n = 1;
            }
            ((DatasetManager)DatasetManager.this).managers[n] = deviceManager;
            ((DatasetManager)DatasetManager.this).datastreamInterfaces[n] = deviceDatastreamInterface;
            deviceDatastreamInterface.setDatastreamListener(new StreamListener(bl));
            deviceManager.addPropertyChangeListener(new DeviceManagerPropertyListener(bl));
        }
    };
    Object setStreamingMutex = new Object();
    boolean setStreamingInProgress = false;

    private DatasetManager() {
        this.managers = new DeviceManager[2];
        this.datastreamInterfaces = new DeviceDatastreamInterface[2];
        Arrays.fill((Object[])this.managers, null);
        Arrays.fill(this.datastreamInterfaces, null);
        DeviceManagerFactory.getInstance().addPropertyChangeListener(this.deviceFactoryListener);
        this.screenUpdateHz = DatasetManager.getPrefsNode().getFloat(PROPERTYNAME_SCREEN_UPDATE_HZ, 10.0f);
        this.liveDataset = new Dataset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetManager getInstance() {
        if (instance == null) {
            Object object = createMutex;
            synchronized (object) {
                if (instance == null) {
                    instance = new DatasetManager();
                }
            }
        }
        return instance;
    }

    public Dataset getLiveDataset() {
        return this.liveDataset;
    }

    public LocationTOC getLiveMainTOC() throws DeviceException, IOException {
        if (this.mainTOC != null) {
            return this.mainTOC;
        }
        this.setMainTOC(this.getLiveTOC(0));
        return this.mainTOC;
    }

    public void setLiveMainTOC(LocationTOC locationTOC) throws DeviceException, IOException {
        this.setLiveTOC(0, locationTOC);
    }

    public LocationTOC getMainTOC() {
        return this.mainTOC;
    }

    protected void setMainTOC(LocationTOC locationTOC) {
        LocationTOC locationTOC2 = this.mainTOC;
        this.mainTOC = locationTOC;
        this.firePropertyChange(PROPERTYNAME_MAIN_TOC, locationTOC2, locationTOC, true);
    }

    public LocationTOC getLiveAuxTOC() throws DeviceException, IOException {
        if (this.auxTOC != null) {
            return this.auxTOC;
        }
        this.setAuxTOC(this.getLiveTOC(1));
        return this.auxTOC;
    }

    public void setLiveAuxTOC(LocationTOC locationTOC) throws DeviceException, IOException {
        this.setLiveTOC(1, locationTOC);
    }

    public LocationTOC getAuxTOC() {
        return this.auxTOC;
    }

    protected void setAuxTOC(LocationTOC locationTOC) {
        LocationTOC locationTOC2 = this.auxTOC;
        this.auxTOC = locationTOC;
        this.firePropertyChange(PROPERTYNAME_AUX_TOC, locationTOC2, locationTOC, true);
    }

    protected LocationTOC getLiveTOC(int n) throws DeviceException, IOException {
        if (this.datastreamInterfaces[n] == null) {
            return null;
        }
        return this.datastreamInterfaces[n].getLiveTOC(false);
    }

    public void setLiveTOC(int n, LocationTOC locationTOC) throws DeviceException, IOException {
        if (this.datastreamInterfaces[n] == null) {
            throw new DeviceInternalException("Can't set TOC on non-existent interface");
        }
        this.datastreamInterfaces[n].setLiveTOC(locationTOC);
    }

    public float getScreenUpdateHz() {
        return this.screenUpdateHz;
    }

    public void setScreenUpdateHz(float f) {
        float f2 = this.screenUpdateHz;
        this.screenUpdateHz = f;
        DatasetManager.getPrefsNode().putFloat(PROPERTYNAME_SCREEN_UPDATE_HZ, f);
        this.firePropertyChange(PROPERTYNAME_SCREEN_UPDATE_HZ, f2, f);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreaming(boolean bl) throws DeviceException, IOException {
        Object object = this.setStreamingMutex;
        synchronized (object) {
            if (this.setStreamingInProgress) {
                return;
            }
            if (bl == this.streaming) {
                return;
            }
            this.setStreamingInProgress = true;
        }
        try {
            if (bl) {
                this.startStreaming();
            } else {
                this.stopStreaming();
            }
            boolean bl2 = this.streaming;
            this.streaming = bl;
            this.liveDataset.setStreamState(this.streaming);
            this.firePropertyChange(PROPERTYNAME_STREAMING, bl2, bl);
        }
        finally {
            this.setStreamingInProgress = false;
        }
    }

    private synchronized void startStreaming() throws DeviceException, IOException {
        int n;
        boolean bl = false;
        try {
            this.resetLiveDataset();
            for (n = 0; n < 2; ++n) {
                if (this.datastreamInterfaces[n] == null) continue;
                this.datastreamInterfaces[n].setStreaming(true);
            }
            bl = true;
        }
        finally {
            if (!bl) {
                for (n = 0; n < 2; ++n) {
                    this.safeStopStream(this.datastreamInterfaces[n]);
                }
            }
        }
    }

    public void resetLiveDataset() throws DeviceException, IOException, DeviceInvalidStateException {
        LocationTOC[] locationTOCArray = new LocationTOC[2];
        DeviceConfigData[] deviceConfigDataArray = new DeviceConfigData[2];
        for (int i = 0; i < 2; ++i) {
            if (this.datastreamInterfaces[i] == null) continue;
            locationTOCArray[i] = this.datastreamInterfaces[i].getLiveTOC(true);
            if (locationTOCArray[i] == null) {
                throw new DeviceInvalidStateException("Received invalid null TOC");
            }
            deviceConfigDataArray[i] = this.datastreamInterfaces[i].getStaticConfigData();
        }
        this.liveDataset.reset(locationTOCArray[0], locationTOCArray[1], deviceConfigDataArray[0], deviceConfigDataArray[1]);
    }

    private void safeStopStream(DeviceDatastreamInterface deviceDatastreamInterface) {
        if (deviceDatastreamInterface == null || !deviceDatastreamInterface.isConnected()) {
            return;
        }
        try {
            deviceDatastreamInterface.setStreaming(false);
        }
        catch (Exception exception) {
            logger.info("Failed to stop streaming of device");
        }
    }

    private synchronized void stopStreaming() throws DeviceException, IOException {
        for (int i = 0; i < 2; ++i) {
            if (this.datastreamInterfaces[i] == null || !this.datastreamInterfaces[i].isConnected()) continue;
            this.datastreamInterfaces[i].setStreaming(false);
        }
    }

    private static Preferences getPrefsNode() {
        return DataManager.getDataPrefsNode();
    }

    static {
        createMutex = new Object();
        logger = Logger.getLogger(DatasetManager.class.getName());
        LOGFINE = logger.isLoggable(Level.FINE);
    }

    class StreamListener
    implements DatastreamListener {
        final boolean primaryDevice;

        StreamListener(boolean bl) {
            this.primaryDevice = bl;
        }

        @Override
        public void streamDataReceived(List list) {
            if (DatasetManager.this.streaming) {
                DatasetManager.this.liveDataset.newDataReceived(this.primaryDevice, list);
            }
        }
    }

    class DeviceManagerPropertyListener
    implements PropertyChangeListener {
        final boolean isMain;

        public DeviceManagerPropertyListener(boolean bl) {
            this.isMain = bl;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("deviceCacheData".equals(string)) {
                try {
                    LocationTOC locationTOC;
                    if (LOGFINE) {
                        logger.fine("Was notified of new device cache data, isMain = " + this.isMain);
                    }
                    if (this.isMain) {
                        DatasetManager.this.setMainTOC(DatasetManager.this.getLiveTOC(0));
                        locationTOC = DatasetManager.this.mainTOC;
                    } else {
                        DatasetManager.this.setAuxTOC(DatasetManager.this.getLiveTOC(1));
                        locationTOC = DatasetManager.this.auxTOC;
                    }
                    if (LOGFINE) {
                        logger.info("Got new TOC data, entries count = " + locationTOC.getTOCEntries().size());
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Manager indicated device data changed, but failed to provide TOC", exception);
                }
            }
        }
    }
}

