/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceMap;
import com.ecmtuning.ecmlink.device.data.DeviceDatastreamInterface;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class DeviceConfigData {
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = 87287003018730603L;
    protected final int deviceId;

    protected DeviceConfigData(int n) {
        this.deviceId = n;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getDeviceSerialNumber() {
        return 0;
    }

    public static DeviceConfigData read(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        if (l != 87287003018730603L) {
            throw new IOException("Missing appropriate header information");
        }
        int n = dataInputStream.readInt();
        if (n > 1) {
            throw new IOException("Incompatible file version");
        }
        int n2 = dataInputStream.readInt();
        DeviceManager deviceManager = DeviceMap.getDeviceManagerForDevice(n2);
        if (deviceManager == null) {
            throw new IOException("Failed to find device manager for ID " + n2);
        }
        DeviceDatastreamInterface deviceDatastreamInterface = deviceManager.getDatastreamInterface();
        if (deviceDatastreamInterface != null) {
            return deviceDatastreamInterface.readConfigData(n2, dataInputStream);
        }
        return null;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(87287003018730603L);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(this.deviceId);
    }
}

