/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.ConverterChainEntry;
import com.ecmtuning.ecmlink.device.data.ConverterRecord;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.DisplayChainEntry;
import com.ecmtuning.ecmlink.device.data.DisplayRecord;
import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.device.data.LocationChainEntry;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class DisplayChain {
    private final List leafNodes = new ArrayList();
    private final List allEntries = new ArrayList();
    private final DisplayChainEntry terminalEntry;
    private boolean main;
    private boolean displayable;
    private String chainKeySpec;
    private String chainPrefsKeyPrefix;
    private static final Logger logger = Logger.getLogger(DisplayChain.class.getName());

    DisplayChain(LocationChainEntry locationChainEntry) {
        this.terminalEntry = locationChainEntry;
        this.allEntries.add(locationChainEntry);
        this.leafNodes.add(locationChainEntry);
    }

    DisplayChain(ConverterChainEntry converterChainEntry) {
        this.terminalEntry = converterChainEntry;
        this.allEntries.add(converterChainEntry);
        converterChainEntry.addEntries(this.allEntries, this.leafNodes);
    }

    public static DisplayChain createRawChain(Location location) {
        LocationChainEntry locationChainEntry = new LocationChainEntry(location.getAssignedName(), location.getDisplayName(), null, location.getDataType());
        ConverterRecord converterRecord = new ConverterRecord(location.getDataType());
        DisplayChainEntry[] displayChainEntryArray = new DisplayChainEntry[]{locationChainEntry};
        ConverterChainEntry converterChainEntry = new ConverterChainEntry(converterRecord, displayChainEntryArray, true);
        return new DisplayChain(converterChainEntry);
    }

    public synchronized boolean isValidChain() {
        if (this.terminalEntry instanceof ConverterChainEntry) {
            return ((ConverterChainEntry)this.terminalEntry).hasValidInputs();
        }
        return true;
    }

    public synchronized boolean needsAnyLocations(List list) {
        for (LocationChainEntry locationChainEntry : this.leafNodes) {
            for (Location location : list) {
                if (!locationChainEntry.matches(location)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean usesAssignedLocationName(String string) {
        for (LocationChainEntry locationChainEntry : this.leafNodes) {
            if (!string.equalsIgnoreCase(locationChainEntry.getLocationAssignedName())) continue;
            return true;
        }
        return false;
    }

    public synchronized void findMissingTOCEntries(LocationTOC locationTOC, List list) {
        for (LocationChainEntry locationChainEntry : this.leafNodes) {
            LocationTOCEntry locationTOCEntry;
            if (locationChainEntry.hasTOCAssociation() || (locationTOCEntry = locationTOC.findMatchingEntry(locationChainEntry.getLocationAssignedName(), locationChainEntry.getLocationDataType())) == null || list.contains(locationTOCEntry)) continue;
            list.add(locationTOCEntry);
        }
    }

    public synchronized boolean registerTOC(LocationTOC locationTOC, LocationTOC locationTOC2) {
        this.displayable = false;
        this.main = false;
        if (locationTOC != null && this._registerTOC(locationTOC)) {
            this.main = true;
            this.displayable = true;
        } else if (locationTOC2 != null && this._registerTOC(locationTOC2)) {
            this.main = false;
            this.displayable = true;
        }
        return this.displayable;
    }

    private boolean _registerTOC(LocationTOC locationTOC) {
        boolean bl = true;
        for (LocationChainEntry locationChainEntry : this.leafNodes) {
            bl = locationChainEntry.registerTOC(locationTOC) != -1 && bl;
        }
        return bl;
    }

    public final float processPacket(TSDataPacket tSDataPacket) {
        if (!this.displayable) {
            return Float.MIN_VALUE;
        }
        float f = Float.MIN_VALUE;
        int n = this.leafNodes.size();
        if (n == 1) {
            return ((LocationChainEntry)this.leafNodes.get(0)).processPacket(tSDataPacket);
        }
        for (int i = 0; i < n; ++i) {
            float f2 = ((LocationChainEntry)this.leafNodes.get(i)).processPacket(tSDataPacket);
            if (f2 == Float.MIN_VALUE) continue;
            f = f2;
        }
        return f;
    }

    public boolean isDisplayable() {
        return this.displayable;
    }

    public boolean isRawChain() {
        return this.terminalEntry != null && this.terminalEntry.getOutputDataType().indexOf("_raw_") != -1;
    }

    public boolean isMain() {
        return this.main;
    }

    public DisplayChainDesc getCurrentChainDesc() {
        DisplayChainDesc displayChainDesc = new DisplayChainDesc(this);
        DisplayRecord displayRecord = DataManager.getDisplayRecordByDataType(this.getOutputType());
        displayChainDesc.applyOverrides(displayRecord);
        this.terminalEntry.applyOverrides(displayChainDesc);
        displayChainDesc.setOverridePrefs(DataPreferences.getPreferences(displayChainDesc));
        displayChainDesc.checkRequired(this);
        return displayChainDesc;
    }

    public void loopReset(DataPreferences dataPreferences) {
        this.terminalEntry.loopReset(dataPreferences);
    }

    public List getEditPrefsSections(DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        this.terminalEntry.addEditPrefsSections(arrayList, dataPreferences);
        return arrayList;
    }

    public static List generateDisplayChains(LocationTOC locationTOC) {
        return DisplayChain.generateDisplayChains(locationTOC, true);
    }

    public static List generateDisplayChains(LocationTOC locationTOC, boolean bl) {
        ArrayList<DisplayChain> arrayList = new ArrayList<DisplayChain>();
        for (LocationTOCEntry locationTOCEntry : locationTOC.getTOCEntries()) {
            arrayList.add(new DisplayChain(new LocationChainEntry(locationTOCEntry.getLocation())));
        }
        DisplayChain.processConverters(arrayList, bl);
        return arrayList;
    }

    public static List findChainsByLocalKey(List list, String string) {
        ArrayList<DisplayChain> arrayList = new ArrayList<DisplayChain>();
        for (DisplayChain displayChain : list) {
            String string2 = displayChain.getLocalKey();
            if (!string.equalsIgnoreCase(string2)) continue;
            arrayList.add(displayChain);
        }
        return arrayList;
    }

    public static List findChainsByOutputType(List list, String string) {
        ArrayList<DisplayChain> arrayList = new ArrayList<DisplayChain>();
        for (DisplayChain displayChain : list) {
            String string2 = displayChain.getOutputType();
            if (!string.equalsIgnoreCase(string2)) continue;
            arrayList.add(displayChain);
        }
        return arrayList;
    }

    private static void processConverters(List list, boolean bl) {
        int n;
        List[] listArray = new List[4];
        for (n = 0; n < listArray.length; ++n) {
            listArray[n] = new ArrayList();
        }
        n = -1;
        while (n != list.size()) {
            n = list.size();
            for (Object object : DataManager.getConverterRecords()) {
                if (!DisplayChain.findCandidateInputs((ConverterRecord)object, list, listArray)) continue;
                DisplayChain.addPermutations((ConverterRecord)object, list, listArray);
            }
        }
        if (bl) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (DisplayChain)iterator.next();
                if (DataManager.getDisplayRecordByDataType(((DisplayChain)object).getOutputType()) != null) continue;
                iterator.remove();
            }
        }
    }

    private static void addPermutations(ConverterRecord converterRecord, List list, List[] listArray) {
        DisplayChain[] displayChainArray = new DisplayChain[converterRecord.getInputDataTypes().length];
        DisplayChain._addPermutations(converterRecord, list, listArray, displayChainArray, 0);
    }

    private static void _addPermutations(ConverterRecord converterRecord, List list, List[] listArray, DisplayChain[] displayChainArray, int n) {
        boolean bl = n == displayChainArray.length - 1;
        Iterator iterator = listArray[n].iterator();
        while (iterator.hasNext()) {
            displayChainArray[n] = (DisplayChain)iterator.next();
            if (bl) {
                DisplayChain._addPermutation(converterRecord, list, displayChainArray);
                continue;
            }
            DisplayChain._addPermutations(converterRecord, list, listArray, displayChainArray, n + 1);
        }
    }

    private static void _addPermutation(ConverterRecord converterRecord, List list, DisplayChain[] displayChainArray) {
        DisplayChainEntry[] displayChainEntryArray = new DisplayChainEntry[displayChainArray.length];
        ConverterChainEntry converterChainEntry = new ConverterChainEntry(converterRecord, displayChainEntryArray, false);
        for (int i = 0; i < displayChainEntryArray.length; ++i) {
            displayChainEntryArray[i] = displayChainArray[i].terminalEntry.createCopy(converterChainEntry, i);
        }
        DisplayChain displayChain = new DisplayChain(converterChainEntry);
        String string = displayChain.getChainKeySpec();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = ((DisplayChain)iterator.next()).getChainKeySpec();
            if (!string2.equals(string)) continue;
            return;
        }
        list.add(displayChain);
    }

    private static boolean findCandidateInputs(ConverterRecord converterRecord, List list, List[] listArray) {
        String[] stringArray = converterRecord.getInputDataTypes();
        int n = stringArray.length;
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i].clear();
        }
        for (DisplayChain displayChain : list) {
            if (displayChain.contains(converterRecord)) continue;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(displayChain.getOutputType())) continue;
                listArray[i].add(displayChain);
            }
        }
        for (int i = 0; i < n; ++i) {
            if (listArray[i].size() != 0) continue;
            return false;
        }
        return true;
    }

    private boolean contains(ConverterRecord converterRecord) {
        if (this.terminalEntry.getType() == "typeConverter") {
            return ((ConverterChainEntry)this.terminalEntry).contains(converterRecord);
        }
        return false;
    }

    public String getOutputType() {
        return this.terminalEntry.getOutputDataType();
    }

    public String getLocalKey() {
        return this.terminalEntry.getLocalKey();
    }

    public String getCurrentChainSpec() {
        return this.terminalEntry.getDescriptor();
    }

    public String getChainKeySpec() {
        if (this.chainKeySpec == null) {
            this.chainKeySpec = this.terminalEntry.getKeyDescriptor();
        }
        return this.chainKeySpec;
    }

    public String getDataPrefsKeyPrefix() {
        if (this.chainPrefsKeyPrefix == null) {
            this.chainPrefsKeyPrefix = "chain-" + Integer.toHexString(this.getChainKeySpec().hashCode());
        }
        return this.chainPrefsKeyPrefix;
    }

    public static DisplayChain createChainFromSpec(String string) {
        block5: {
            try {
                ConverterRecord converterRecord;
                ParsePosition parsePosition = new ParsePosition();
                parsePosition.spec = string;
                parsePosition.index = 0;
                String string2 = DisplayChain.extractNextSpecStr(parsePosition);
                ++parsePosition.index;
                ConverterRecord converterRecord2 = converterRecord = string2 == null ? null : DataManager.getConverterRecord(string2);
                if (converterRecord == null) {
                    logger.warning("Failed to find initial converter entry for DisplayChain '" + string + "'");
                    break block5;
                }
                DisplayChainEntry[] displayChainEntryArray = DisplayChain.parseParamSpec(converterRecord.getInputDataTypes().length, parsePosition);
                if (displayChainEntryArray == null) {
                    logger.warning("Failed to parse DisplayChain '" + string + "'");
                    break block5;
                }
                ConverterChainEntry converterChainEntry = new ConverterChainEntry(converterRecord, displayChainEntryArray, true);
                DisplayChain displayChain = new DisplayChain(converterChainEntry);
                if (displayChain.isValidChain()) {
                    return displayChain;
                }
                return null;
            }
            catch (Exception exception) {
                logger.warning("Failed to parse DisplayChain '" + string + "'");
            }
        }
        return null;
    }

    private static DisplayChainEntry[] parseParamSpec(int n, ParsePosition parsePosition) {
        DisplayChainEntry[] displayChainEntryArray = new DisplayChainEntry[n];
        int n2 = parsePosition.index;
        String string = parsePosition.spec;
        for (int i = 0; i < n; ++i) {
            String string2 = DisplayChain.extractNextSpecStr(parsePosition);
            if (string2 == null) {
                return null;
            }
            char c = string.charAt(parsePosition.index);
            ++parsePosition.index;
            if (c == ')' && i != n - 1) {
                logger.info("Found ) delimiter before final parameter in '" + string.substring(n2) + "'");
                return null;
            }
            LocationChainEntry locationChainEntry = LocationChainEntry.parseDescriptor(string2);
            if (locationChainEntry != null) {
                if (c == '(') {
                    logger.info("Found ( delimiter while parsing location descriptor '" + string2 + "'");
                    return null;
                }
                displayChainEntryArray[i] = locationChainEntry;
                continue;
            }
            ConverterRecord converterRecord = DataManager.getConverterRecord(string2);
            if (converterRecord == null) {
                logger.info("Failed to find ConverterRecord '" + string2 + "'");
                return null;
            }
            if (c != '(') {
                logger.info("Did not find ( delimiter while parsing converter descriptor '" + string2 + "'");
                return null;
            }
            DisplayChainEntry[] displayChainEntryArray2 = DisplayChain.parseParamSpec(converterRecord.getInputDataTypes().length, parsePosition);
            displayChainEntryArray[i] = new ConverterChainEntry(converterRecord, displayChainEntryArray2, true);
            c = string.charAt(parsePosition.index);
            ++parsePosition.index;
            if (c != ')' || i == n - 1) continue;
            logger.info("Found ) delimiter before final parameter in '" + string.substring(n2) + "'");
            return null;
        }
        return displayChainEntryArray;
    }

    private static String extractNextSpecStr(ParsePosition parsePosition) {
        String string = parsePosition.spec;
        int n = parsePosition.index;
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != ',' && c != '(' && c != ')') continue;
            parsePosition.index = i;
            return string.substring(n, i);
        }
        logger.info("Failed to find delimiter in '" + parsePosition.spec.substring(n) + "'");
        return null;
    }

    public static void sort(List list) {
        int n;
        int n2 = list.size();
        SortRec[] sortRecArray = new SortRec[n2];
        for (n = 0; n < n2; ++n) {
            DisplayChain displayChain = (DisplayChain)list.get(n);
            DisplayChainDesc displayChainDesc = displayChain.getCurrentChainDesc();
            sortRecArray[n] = new SortRec(displayChain, displayChainDesc);
        }
        Arrays.sort(sortRecArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((SortRec)object).desc.getDisplayName().compareTo(((SortRec)object2).desc.getDisplayName());
            }
        });
        for (n = 0; n < n2; ++n) {
            list.set(n, sortRecArray[n]);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof DisplayChain)) {
            return false;
        }
        return this.getChainKeySpec().equals(((DisplayChain)object).getChainKeySpec());
    }

    public int hashCode() {
        return this.getChainKeySpec().hashCode();
    }

    public static DisplayChain findChainByOutputType(List list, String string) {
        List list2 = DisplayChain.findChainsByOutputType(list, string);
        if (list2.size() == 1) {
            return (DisplayChain)list2.get(0);
        }
        if (list2.size() > 1) {
            return null;
        }
        return null;
    }

    private static class SortRec {
        final DisplayChain chain;
        final DisplayChainDesc desc;

        SortRec(DisplayChain displayChain, DisplayChainDesc displayChainDesc) {
            this.chain = displayChain;
            this.desc = displayChainDesc;
        }
    }

    private static class ParsePosition {
        public String spec;
        public int index;

        private ParsePosition() {
        }
    }
}

