/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplayRecord;
import com.ecmtuning.ecmlink.device.data.MemoryBackedPreferences;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.util.logging.Logger;

public class DisplayChainDesc {
    public static final String PREFS_KEY_DISPLAYNAME = "displayname";
    public static final String PREFS_KEY_UNITS = "displayunits";
    public static final String PREFS_KEY_MIN = "displaymin";
    public static final String PREFS_KEY_MAX = "displaymax";
    public static final String PREFS_KEY_PREC = "displayprec";
    public static final String[] ALL_PREFS_KEYS = new String[]{"displayname", "displayunits", "displaymin", "displaymax", "displayprec"};
    private final DisplayChain sourceChain;
    private boolean displayable;
    private boolean rawchain;
    private final String prefsKeyPrefix;
    private String lclDisplayName;
    private String lclUnits;
    private Float lclMin;
    private Float lclMax;
    private Integer lclPrec;
    private DisplayRecord.ValueMapEntry[] valueMap;
    private DataPreferences overridePrefs = new DataPreferences(null, new MemoryBackedPreferences());
    private static final Logger logger = Logger.getLogger(DisplayChainDesc.class.getName());

    DisplayChainDesc(DisplayChain displayChain) {
        this.sourceChain = displayChain;
        this.displayable = displayChain.isDisplayable();
        this.rawchain = displayChain.isRawChain();
        this.prefsKeyPrefix = displayChain.getDataPrefsKeyPrefix();
    }

    void checkRequired(DisplayChain displayChain) {
        StringBuffer stringBuffer = null;
        if (this.lclMin == null) {
            stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
            stringBuffer.append(" no MIN value");
        }
        if (this.lclMax == null) {
            stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
            stringBuffer.append(" no MAX value");
        }
        if (this.lclDisplayName == null) {
            stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
            stringBuffer.append(" no displayname value");
        }
        if (stringBuffer != null) {
            logger.warning("Invalid chain descriptor, " + stringBuffer.toString() + ", for " + displayChain.getCurrentChainSpec());
            this.displayable = false;
            return;
        }
        if (this.lclPrec == null) {
            this.setPrec(new Integer(0));
        }
        if (this.lclUnits == null) {
            this.setUnits("-");
        }
    }

    public DisplayChain getSourceChain() {
        return this.sourceChain;
    }

    public String getPrefsKeyPrefix() {
        return this.prefsKeyPrefix;
    }

    public void setOverridePrefs(DataPreferences dataPreferences) {
        this.overridePrefs = dataPreferences;
    }

    void applyOverrides(DisplayRecord displayRecord) {
        if (displayRecord == null) {
            return;
        }
        this.lclDisplayName = (String)DisplayChainDesc.checkNull(displayRecord.getDisplayName(), this.lclDisplayName);
        this.lclUnits = (String)DisplayChainDesc.checkNull(displayRecord.getUnits(), this.lclUnits);
        this.lclMin = (Float)DisplayChainDesc.checkNull(displayRecord.getMin(), this.lclMin);
        this.lclMax = (Float)DisplayChainDesc.checkNull(displayRecord.getMax(), this.lclMax);
        this.lclPrec = (Integer)DisplayChainDesc.checkNull(displayRecord.getPrec(), this.lclPrec);
        this.valueMap = (DisplayRecord.ValueMapEntry[])DisplayChainDesc.checkNull(displayRecord.getValueMap(), this.valueMap);
    }

    protected static final Object checkNull(Object object, Object object2) {
        return object != null ? object : object2;
    }

    public String format(float f) {
        if (f == Float.MIN_VALUE) {
            return "";
        }
        return XFormatter.format(f, this.getPrecInt());
    }

    public boolean isDisplayable() {
        return this.displayable;
    }

    public boolean isRawChain() {
        return this.rawchain;
    }

    public String getDisplayName() {
        return (String)DisplayChainDesc.checkNull(this.overridePrefs.get(PREFS_KEY_DISPLAYNAME, this.lclDisplayName), "REMOVE-ME");
    }

    public boolean hasDisplayName() {
        return this.overridePrefs.get(PREFS_KEY_DISPLAYNAME, this.lclDisplayName) != null;
    }

    public void setDisplayName(String string) {
        this.lclDisplayName = string;
    }

    public String getUnits() {
        return (String)DisplayChainDesc.checkNull(this.overridePrefs.get(PREFS_KEY_UNITS, this.lclUnits), "units");
    }

    public void setUnits(String string) {
        this.lclUnits = string;
    }

    public Float getMin() {
        float f = this.overridePrefs.getFloat(PREFS_KEY_MIN, Float.MIN_VALUE);
        if (f == Float.MIN_VALUE) {
            return this.lclMin;
        }
        return new Float(f);
    }

    public void setMin(Float f) {
        this.lclMin = f;
    }

    public Float getMax() {
        float f = this.overridePrefs.getFloat(PREFS_KEY_MAX, Float.MAX_VALUE);
        if (f == Float.MAX_VALUE) {
            return this.lclMax;
        }
        return new Float(f);
    }

    public void setMax(Float f) {
        this.lclMax = f;
    }

    public Integer getPrec() {
        int n = this.overridePrefs.getInt(PREFS_KEY_PREC, Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            return this.lclPrec;
        }
        return new Integer(n);
    }

    public int getPrecInt() {
        int n = this.overridePrefs.getInt(PREFS_KEY_PREC, Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            return this.lclPrec;
        }
        return n;
    }

    public void setPrec(Integer n) {
        this.lclPrec = n;
    }

    public DisplayRecord.ValueMapEntry[] getValueMap() {
        return this.valueMap;
    }

    public void setValueMap(DisplayRecord.ValueMapEntry[] valueMapEntryArray) {
        this.valueMap = valueMapEntryArray;
    }

    String getLclDisplayName() {
        return this.lclDisplayName;
    }

    String getLclUnits() {
        return this.lclUnits;
    }

    Float getLclMin() {
        return this.lclMin;
    }

    Float getLclMax() {
        return this.lclMax;
    }

    Integer getLclPrec() {
        return this.lclPrec;
    }
}

