/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.util.BasicStrings;
import java.util.Arrays;
import java.util.Comparator;

public class DisplayRecord {
    private final String key;
    private final String dataTypeMatch;
    private final String displayName;
    private final String units;
    private final Float min;
    private final Float max;
    private final Integer prec;
    private final ValueMapEntry[] valueMap;
    private static final String DISPLAY_KEY_PREFIX = DataManager.getKeyPrefixForType(DataManager.TYPE_DISPLAY);

    DisplayRecord(DataObject dataObject) {
        this(dataObject, "");
    }

    DisplayRecord(DataObject dataObject, String string) {
        if (string == null) {
            string = "";
        }
        this.key = dataObject.getNodeKey();
        this.dataTypeMatch = this.createDataTypeMatch(this.key);
        this.displayName = dataObject.getString(string + "dispname");
        this.units = dataObject.getString(string + "units");
        this.min = dataObject.getFloat(string + "min");
        this.max = dataObject.getFloat(string + "max");
        this.prec = dataObject.getInteger(string + "prec");
        String string2 = dataObject.getString(string + "valuemap");
        this.valueMap = string2 != null ? this.parseValueMapStr(string2) : null;
        if (string.length() == 0) {
            this.validateConstruct();
        }
    }

    private final String createDataTypeMatch(String string) {
        if (string.startsWith(DISPLAY_KEY_PREFIX)) {
            return DataManager.getKeyPrefixForType(DataManager.TYPE_DATATYPE) + string.substring(DISPLAY_KEY_PREFIX.length());
        }
        return "null";
    }

    public DisplayRecord(String string, String string2, float f, float f2, String string3, int n) {
        this.key = string;
        this.dataTypeMatch = this.createDataTypeMatch(string);
        this.displayName = string2;
        this.min = new Float(f);
        this.max = new Float(f2);
        this.units = string3;
        this.prec = new Integer(n);
        this.valueMap = null;
    }

    public boolean isEmpty() {
        return this.displayName == null && this.units == null && this.min == null && this.max == null && this.prec == null && this.valueMap == null;
    }

    private ValueMapEntry[] parseValueMapStr(String string) {
        String[] stringArray = BasicStrings.trimAll(string.split(","));
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid valuemap parameter.  Must have even number of entries.");
        }
        ValueMapEntry[] valueMapEntryArray = new ValueMapEntry[stringArray.length / 2];
        for (int i = 0; i < stringArray.length; i += 2) {
            ValueMapEntry valueMapEntry = new ValueMapEntry();
            valueMapEntry.value = Float.parseFloat(stringArray[i]);
            valueMapEntry.text = stringArray[i + 1];
            valueMapEntryArray[i / 2] = valueMapEntry;
        }
        Arrays.sort(valueMapEntryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return (int)(1000.0f * (((ValueMapEntry)object).value - ((ValueMapEntry)object2).value));
            }
        });
        return valueMapEntryArray;
    }

    private void validateConstruct() {
        if (this.displayName == null) {
            throw new IllegalArgumentException("Must provide displayName for DisplayRecord construction");
        }
        if (this.units == null) {
            throw new IllegalArgumentException("Must provide units for DisplayRecord construction");
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUnits() {
        return this.units;
    }

    public Float getMin() {
        return this.min;
    }

    public float getMinValue() {
        return this.min.floatValue();
    }

    public Float getMax() {
        return this.max;
    }

    public float getMaxValue() {
        return this.max.floatValue();
    }

    public Integer getPrec() {
        return this.prec;
    }

    public int getPrecValue() {
        return this.prec;
    }

    public ValueMapEntry[] getValueMap() {
        return this.valueMap;
    }

    public boolean matchesDataType(String string) {
        return this.dataTypeMatch.equalsIgnoreCase(string);
    }

    public boolean hasValueMap() {
        return this.valueMap != null;
    }

    static final class ValueMapEntry {
        float value;
        String text;

        ValueMapEntry() {
        }
    }
}

