/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DatasetListener;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.DisplaySetListener;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCListener;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.GenericListenerAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;

public class DisplaySet {
    private DisplayChain[] displayChains = new DisplayChain[0];
    private boolean[] displayableMain = new boolean[0];
    private boolean[] displayableAux = new boolean[0];
    private final ArrayList displayPackets = new ArrayList();
    private Dataset dataset;
    private DataPreferences converterPrefs;
    private LocationTOC mainTOC;
    private LocationTOC auxTOC;
    private GenericListenerAdapter listenerAdapter = new GenericListenerAdapter(DisplaySetListener.class);
    PropertyChangeListener unitsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DisplaySet.this.recalcAllAndNotify();
        }
    };
    PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            DisplaySet.this.recalcAllAndNotify();
        }
    };
    DatasetListener dsListener = new DatasetListener(){

        @Override
        public void reset(LocationTOC locationTOC, LocationTOC locationTOC2) {
            DisplaySet.this.handleTOCReset(locationTOC, locationTOC2);
        }

        @Override
        public void streamDataReceived(boolean bl, List list) {
            DisplaySet.this.handleNewData(bl, list);
        }

        @Override
        public void streamStart() {
            DisplaySet.this.resetDisplayPackets();
        }

        @Override
        public void streamStop() {
        }

        @Override
        public void timeChanged() {
            DisplaySet.this.handleDatasetTimeChanged();
        }
    };
    LocationTOCListener tocListener = new LocationTOCListener(){

        @Override
        public void newLocationList(List list, List list2) {
            DisplaySet.this.handleTOCChange();
        }
    };
    private final Comparator displayPacketComparator = new Comparator(){

        public final int compare(Object object, Object object2) {
            return Double.compare(((TSDataPacket)object).timestampMicros, ((TSDataPacket)object2).timestampMicros);
        }
    };

    public void registerModels(Dataset dataset, DataPreferences dataPreferences) {
        if (this.dataset != null) {
            throw new IllegalStateException("DisplaySet already has Dataset");
        }
        this.dataset = dataset;
        this.converterPrefs = dataPreferences;
        dataset.addDatasetListener(this.dsListener);
        dataPreferences.addPreferenceChangeListener(this.prefsListener);
        UnitsModel.getInstance().addPropertyChangeListener(this.unitsListener);
        this.handleTOCReset(dataset.getMainDataTOC(), dataset.getAuxDataTOC());
    }

    public void deregisterModels() {
        if (this.dataset != null) {
            this.dataset.removeDatasetListener(this.dsListener);
            this.dataset = null;
        }
        this.converterPrefs.removePreferenceChangeListener(this.prefsListener);
        UnitsModel.getInstance().removePropertyChangeListener(this.unitsListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recalcAllAndNotify() {
        DisplaySet displaySet = this;
        synchronized (displaySet) {
            this.recalcAllPackets();
        }
        this.listenerAdapter.fire("displayChainsOrValuesChanged");
    }

    public DisplayChain[] getDisplayChains() {
        return this.displayChains;
    }

    public synchronized DisplayChainDesc[] getDisplayChainDescs() {
        DisplayChainDesc[] displayChainDescArray = new DisplayChainDesc[this.displayChains.length];
        for (int i = 0; i < displayChainDescArray.length; ++i) {
            displayChainDescArray[i] = this.displayChains[i].getCurrentChainDesc();
        }
        return displayChainDescArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayChains(DisplayChain[] displayChainArray) {
        int n;
        int n2;
        ResetDisplayStatus resetDisplayStatus = null;
        DisplaySet displaySet = this;
        synchronized (displaySet) {
            n2 = this.displayPackets.size();
            this.displayChains = displayChainArray;
            this.displayableMain = new boolean[this.displayChains.length];
            this.displayableAux = new boolean[this.displayChains.length];
            resetDisplayStatus = this.resetDisplayable();
            this.recalcAllPackets();
            n = this.displayPackets.size();
        }
        if (n2 == 0 || n == 0 || resetDisplayStatus.chainsSwapped) {
            this.listenerAdapter.fire("displayReset");
        } else {
            this.listenerAdapter.fire("displayChainsOrValuesChanged");
        }
    }

    public void setDisplayChains(List list) {
        this.setDisplayChains(list.toArray(new DisplayChain[0]));
    }

    public ArrayList getDisplayPackets() {
        return this.displayPackets;
    }

    public void clipData(double d, double d2) {
        this.dataset.clipData(d, d2);
    }

    public synchronized double getDisplayPacketMaxTime() {
        int n = this.displayPackets.size();
        return n == 0 ? 0.0 : ((TSDataPacket)this.displayPackets.get((int)(n - 1))).timestampMicros;
    }

    public synchronized float[] getMostRecentData(double d) {
        float[] fArray = new float[this.displayChains.length];
        if (fArray.length > 0) {
            int n = Collections.binarySearch(this.displayPackets, new TSDataPacket(d, new float[0]), this.displayPacketComparator);
            if (n >= 0) {
                float[] fArray2 = ((TSDataPacket)this.displayPackets.get((int)n)).data;
                System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
            } else if ((n = -n - 1) == 0) {
                Arrays.fill(fArray, Float.MIN_VALUE);
            } else {
                float[] fArray3 = ((TSDataPacket)this.displayPackets.get((int)(--n))).data;
                System.arraycopy(fArray3, 0, fArray, 0, fArray3.length);
            }
        }
        return fArray;
    }

    public synchronized int getPreviousPacketIndex(double d) {
        int n = this.getPacketIndex(d);
        return n == 0 ? n : n - 1;
    }

    public synchronized double getPreviousPacketTime(double d) {
        if (this.displayPackets.size() == 0) {
            return d;
        }
        return ((TSDataPacket)this.displayPackets.get((int)this.getPreviousPacketIndex((double)d))).timestampMicros;
    }

    public synchronized int getNextPacketIndex(double d) {
        int n = this.getPacketIndex(d);
        if (n == this.displayPackets.size()) {
            return n;
        }
        if (((TSDataPacket)this.displayPackets.get((int)n)).timestampMicros > d) {
            return n;
        }
        return n + 1;
    }

    public synchronized double getNextPacketTime(double d) {
        if (this.displayPackets.size() == 0) {
            return d;
        }
        int n = this.getNextPacketIndex(d);
        if (n == this.displayPackets.size()) {
            --n;
        }
        return ((TSDataPacket)this.displayPackets.get((int)n)).timestampMicros;
    }

    public synchronized int getPacketIndex(double d) {
        int n = Collections.binarySearch(this.displayPackets, new TSDataPacket(d, new float[0]), this.displayPacketComparator);
        return n < 0 ? -n - 1 : n;
    }

    public synchronized int getNearestPacket(double d) {
        double d2;
        int n = this.displayPackets.size();
        if (n <= 1) {
            return 0;
        }
        int n2 = this.getPacketIndex(d);
        if (n2 == n) {
            return n2 - 1;
        }
        if (n2 == 0) {
            return n2;
        }
        TSDataPacket tSDataPacket = (TSDataPacket)this.displayPackets.get(n2);
        TSDataPacket tSDataPacket2 = (TSDataPacket)this.displayPackets.get(n2 - 1);
        if (tSDataPacket.timestampMicros == d) {
            return n2;
        }
        double d3 = Math.abs(d - tSDataPacket.timestampMicros);
        if (d3 < (d2 = Math.abs(d - tSDataPacket2.timestampMicros))) {
            return n2;
        }
        return n2 - 1;
    }

    public synchronized double getNearestTimestamp(double d) {
        int n = this.displayPackets.size();
        if (n <= 1) {
            return 0.0;
        }
        return ((TSDataPacket)this.displayPackets.get((int)this.getNearestPacket((double)d))).timestampMicros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTOCReset(LocationTOC locationTOC, LocationTOC locationTOC2) {
        DisplaySet displaySet = this;
        synchronized (displaySet) {
            if (this.mainTOC != null) {
                this.mainTOC.removeLocationTOCListener(this.tocListener);
            }
            if (this.auxTOC != null) {
                this.auxTOC.removeLocationTOCListener(this.tocListener);
            }
            this.mainTOC = locationTOC;
            this.auxTOC = locationTOC2;
            if (this.mainTOC != null) {
                this.mainTOC.addLocationTOCListener(this.tocListener);
            }
            if (this.auxTOC != null) {
                this.auxTOC.addLocationTOCListener(this.tocListener);
            }
            this.resetDisplayable();
            this.resetDisplayPackets();
        }
        this.listenerAdapter.fire("displayReset");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTOCChange() {
        ResetDisplayStatus resetDisplayStatus = null;
        DisplaySet displaySet = this;
        synchronized (displaySet) {
            resetDisplayStatus = this.resetDisplayable();
            if (resetDisplayStatus.displayableStatusChanged) {
                this.recalcAllPackets();
            }
        }
        if (resetDisplayStatus.chainsSwapped) {
            this.listenerAdapter.fire("displayReset");
        } else if (resetDisplayStatus.displayableStatusChanged) {
            this.listenerAdapter.fire("displayChainsOrValuesChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDatasetTimeChanged() {
        DisplaySet displaySet = this;
        synchronized (displaySet) {
            this.recalcAllPackets();
        }
        this.listenerAdapter.fire("displayTimeChanged");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewData(boolean bl, List list) {
        DisplaySet displaySet = this;
        synchronized (displaySet) {
            this.processData(list, bl ? this.displayableMain : this.displayableAux, this.displayPackets);
        }
        this.listenerAdapter.fire("displayValuesAdded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recalcAllPackets() {
        this.resetDisplayPackets();
        if (this.dataset == null) {
            return;
        }
        Dataset dataset = this.dataset;
        synchronized (dataset) {
            ArrayList arrayList = this.dataset.hasMainData() ? this.dataset.getMainData() : new ArrayList();
            ArrayList arrayList2 = this.dataset.hasAuxData() ? this.dataset.getAuxData() : new ArrayList();
            this.processData(arrayList, this.displayableMain, this.displayPackets);
            this.processData(arrayList2, this.displayableAux, this.displayPackets);
        }
    }

    private final void resetDisplayPackets() {
        this.displayPackets.clear();
        for (int i = 0; i < this.displayChains.length; ++i) {
            if (!this.displayChains[i].isDisplayable()) continue;
            this.displayChains[i].loopReset(this.converterPrefs);
        }
    }

    private final void processData(List list, boolean[] blArray, List list2) {
        int n = list.size();
        int n2 = blArray.length;
        float[] fArray = new float[n2];
        for (int i = 0; i < n; ++i) {
            TSDataPacket tSDataPacket = (TSDataPacket)list.get(i);
            boolean bl = false;
            Arrays.fill(fArray, Float.MIN_VALUE);
            for (int j = 0; j < n2; ++j) {
                float f;
                if (!blArray[j]) continue;
                fArray[j] = f = this.displayChains[j].processPacket(tSDataPacket);
                if (bl || f == Float.MIN_VALUE) continue;
                bl = true;
            }
            if (!bl) continue;
            list2.add(new TSDataPacket(tSDataPacket.timestampMicros, fArray));
        }
    }

    public List generateAllDisplayable(List list) {
        ArrayList<DisplayChain> arrayList = new ArrayList<DisplayChain>();
        List list2 = null;
        List list3 = null;
        List list4 = null;
        List list5 = null;
        if (this.mainTOC != null) {
            list2 = DisplayChain.generateDisplayChains(this.mainTOC);
            list4 = DisplaySet.generateDisplayChainDescs(list2);
        }
        if (this.auxTOC != null) {
            list3 = DisplayChain.generateDisplayChains(this.auxTOC);
            list5 = DisplaySet.generateDisplayChainDescs(list3);
        }
        for (DisplayChain displayChain : list) {
            DisplayChain displayChain2 = DisplaySet.findCompatibleChain(displayChain, list2, list4);
            if (displayChain2 == null) {
                displayChain2 = DisplaySet.findCompatibleChain(displayChain, list3, list5);
            }
            arrayList.add(displayChain2 != null ? displayChain2 : displayChain);
        }
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        if (list3 != null) {
            arrayList.addAll(list3);
        }
        return arrayList;
    }

    private ResetDisplayStatus resetDisplayable() {
        ResetDisplayStatus resetDisplayStatus = new ResetDisplayStatus();
        List list = null;
        List list2 = null;
        List list3 = null;
        List list4 = null;
        if (this.mainTOC != null) {
            list = DisplayChain.generateDisplayChains(this.mainTOC);
            list3 = DisplaySet.generateDisplayChainDescs(list);
        }
        if (this.auxTOC != null) {
            list2 = DisplayChain.generateDisplayChains(this.auxTOC);
            list4 = DisplaySet.generateDisplayChainDescs(list2);
        }
        for (DisplayChain displayChain : this.displayChains) {
            boolean bl = displayChain.isDisplayable();
            boolean bl2 = displayChain.registerTOC(this.mainTOC, this.auxTOC);
            if (!bl2) {
                DisplayChain displayChain2 = DisplaySet.findCompatibleChain(displayChain, list, list3);
                if (displayChain2 == null) {
                    displayChain2 = DisplaySet.findCompatibleChain(displayChain, list2, list4);
                }
                if (displayChain2 != null) {
                    displayChain = displayChain2;
                    bl2 = displayChain.registerTOC(this.mainTOC, this.auxTOC);
                    this.displayChains[var7_7] = displayChain;
                    resetDisplayStatus.chainsSwapped = true;
                }
            }
            boolean bl3 = resetDisplayStatus.displayableStatusChanged = resetDisplayStatus.displayableStatusChanged || bl != bl2;
            if (displayChain.isMain()) {
                this.displayableMain[var7_7] = displayChain.isDisplayable();
                this.displayableAux[var7_7] = false;
                continue;
            }
            this.displayableAux[var7_7] = displayChain.isDisplayable();
            this.displayableMain[var7_7] = false;
        }
        return resetDisplayStatus;
    }

    private static DisplayChain findCompatibleChain(DisplayChain displayChain, List list, List list2) {
        if (displayChain == null || list2 == null || list == null || list.size() != list2.size()) {
            return null;
        }
        DisplayChainDesc displayChainDesc = displayChain.getCurrentChainDesc();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DisplayChainDesc displayChainDesc2 = (DisplayChainDesc)list2.get(i);
            if (!displayChainDesc.getDisplayName().equals(displayChainDesc2.getDisplayName())) continue;
            DisplayChain displayChain2 = (DisplayChain)list.get(i);
            list2.remove(i);
            list.remove(i);
            return displayChain2;
        }
        return null;
    }

    public static List generateDisplayChainDescs(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<DisplayChainDesc> arrayList = new ArrayList<DisplayChainDesc>();
        for (DisplayChain displayChain : list) {
            arrayList.add(displayChain.getCurrentChainDesc());
        }
        return arrayList;
    }

    public void addDisplaySetListener(DisplaySetListener displaySetListener) {
        this.listenerAdapter.addListener(displaySetListener);
    }

    public void removeDisplaySetListener(DisplaySetListener displaySetListener) {
        this.listenerAdapter.removeListener(displaySetListener);
    }

    private static class ResetDisplayStatus {
        boolean displayableStatusChanged;
        boolean chainsSwapped;

        private ResetDisplayStatus() {
        }
    }
}

