/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.device.DeviceMap;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.LocationAlias;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.FileUtils;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.jgoodies.binding.BindingUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Location {
    private static final String UNKNOWN_DATATYPE_PREFIX = "unknown_";
    private final int deviceId;
    private final String assignedName;
    private final String displayName;
    private final String desc;
    private final String displayNameOverride;
    private final int address;
    private final int size;
    private final int minfwid;
    private final int maxfwid;
    private final String dataType;
    private static final Integer DEFAULT_MINFWID = new Integer(0);
    private static final Integer DEFAULT_MAXFWID = new Integer(65535);
    private static final int FILE_VERSION = 2;
    private static final long FILE_MARKER = -2738028873483246749L;

    public Location(Location location, LocationAlias locationAlias) {
        this.deviceId = location.deviceId;
        this.assignedName = location.assignedName;
        this.address = location.address;
        this.size = location.size;
        this.minfwid = location.minfwid;
        this.maxfwid = location.maxfwid;
        this.displayName = locationAlias.getDisplayName();
        this.displayNameOverride = locationAlias.getDisplayNameOverride();
        this.desc = locationAlias.getDescription();
        this.dataType = this.checkDataType(locationAlias.getDataType());
    }

    public Location(int n, int n2, int n3) {
        this.deviceId = n;
        this.assignedName = n + "_" + XFormatter.toHex4(n2);
        this.displayName = "0x" + XFormatter.toHex4(n2);
        this.displayNameOverride = null;
        this.desc = "Unknown location";
        this.address = n2;
        this.size = n3;
        this.minfwid = DEFAULT_MINFWID;
        this.maxfwid = DEFAULT_MAXFWID;
        this.dataType = this.checkDataType(UNKNOWN_DATATYPE_PREFIX + this.assignedName);
    }

    Location(DataObject dataObject) {
        String string = dataObject.getNodeKey();
        String[] stringArray = BasicStrings.dotSplit(string);
        this.deviceId = Integer.decode(stringArray[2]);
        this.assignedName = stringArray[3];
        this.displayName = dataObject.getString("dispname");
        this.displayNameOverride = null;
        this.desc = dataObject.getString("desc");
        this.dataType = this.checkDataType(dataObject.getString("datatype").toLowerCase());
        this.address = dataObject.getInteger("addr");
        this.size = dataObject.getInteger("size");
        this.minfwid = dataObject.getInteger("minfwid", DEFAULT_MINFWID);
        this.maxfwid = dataObject.getInteger("maxfwid", DEFAULT_MAXFWID);
        this.validateConstruct();
    }

    private Location(int n, String string, String string2, String string3, String string4, int n2, int n3, String string5) {
        this.deviceId = n;
        this.assignedName = string;
        this.displayName = string2;
        this.displayNameOverride = string3;
        this.desc = string4;
        this.address = n2;
        this.size = n3;
        this.dataType = this.checkDataType(string5);
        this.minfwid = DEFAULT_MINFWID;
        this.maxfwid = DEFAULT_MAXFWID;
        this.validateConstruct();
    }

    private String checkDataType(String string) {
        String[] stringArray = BasicStrings.dotSplit(string);
        if (stringArray.length == 3) {
            return string;
        }
        return "data.sys." + string.replace('.', '_');
    }

    private void validateConstruct() {
        if (!DeviceMap.isValidDeviceId(this.deviceId)) {
            throw new IllegalArgumentException("Provided unknown deviceId " + this.deviceId + " on Location construction");
        }
        if (this.displayName == null) {
            throw new IllegalArgumentException("Must provide displayName for Location construction");
        }
        if (this.dataType == null) {
            throw new IllegalArgumentException("Must provide dataType for Location construction");
        }
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public String getAssignedName() {
        return this.assignedName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameOverride() {
        return this.displayNameOverride;
    }

    public String getOverridenDisplayName() {
        if (this.displayNameOverride != null) {
            return this.displayNameOverride;
        }
        return this.displayName;
    }

    public String getDescription() {
        if (this.desc == null) {
            return this.displayName;
        }
        return this.desc;
    }

    public String getDataType() {
        return this.dataType;
    }

    public boolean matches(String string, String string2) {
        return BindingUtils.equals((Object)this.assignedName, (Object)string) && BindingUtils.equals((Object)this.dataType, (Object)string2);
    }

    public boolean matches(Location location) {
        return this.matches(location.getAssignedName(), location.getDataType());
    }

    public int getAddress() {
        return this.address;
    }

    public int getMinFwid() {
        return this.minfwid;
    }

    public int getMaxFwid() {
        return this.maxfwid;
    }

    public int getSize() {
        return this.size;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, -2738028873483246749L, 2);
        dataOutputStream.writeInt(this.deviceId);
        FileUtils.writeNullableString(this.assignedName, dataOutputStream);
        FileUtils.writeNullableString(this.displayName, dataOutputStream);
        FileUtils.writeNullableString(this.displayNameOverride, dataOutputStream);
        FileUtils.writeNullableString(this.desc, dataOutputStream);
        dataOutputStream.writeInt(this.address);
        dataOutputStream.writeInt(this.size);
        FileUtils.writeNullableString(this.dataType, dataOutputStream);
    }

    public static Location read(DataInputStream dataInputStream) throws IOException {
        Location location;
        int n = FileUtils.readFileVersion(dataInputStream, "Location", -2738028873483246749L, 2);
        int n2 = dataInputStream.readInt();
        String string = FileUtils.readNullableString(dataInputStream);
        String string2 = FileUtils.readNullableString(dataInputStream);
        String string3 = n == 2 ? FileUtils.readNullableString(dataInputStream) : null;
        String string4 = FileUtils.readNullableString(dataInputStream);
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        String string5 = FileUtils.readNullableString(dataInputStream);
        if (!DeviceManagerFactory.isRunningAsTools() && string5.indexOf(UNKNOWN_DATATYPE_PREFIX) != -1 && (location = DataManager.getLocationByAddress(n2, n3, -1)) != null) {
            string = location.getAssignedName();
            string2 = location.getDisplayName();
            string5 = location.getDataType();
        }
        return new Location(n2, string, string2, string3, string4, n3, n4, string5);
    }

    public String toString() {
        return String.format("Location(displayName '%s', dataType '%s', address %d, size %d)", this.getDisplayName(), this.getDataType(), this.getAddress(), this.getSize());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Location)) {
            return false;
        }
        Location location = (Location)object;
        if (location.address != this.address || location.deviceId != this.deviceId || location.size != this.size) {
            return false;
        }
        if (!this.dataType.equals(location.dataType) || !this.displayName.equals(location.displayName)) {
            return false;
        }
        if (!BindingUtils.equals((Object)location.displayNameOverride, (Object)this.displayNameOverride)) {
            return false;
        }
        return this.desc == null ? location.desc == null : (location.desc == null ? false : this.desc.equals(location.desc));
    }

    public int hashCode() {
        int n = this.dataType.hashCode();
        n += 23 * this.displayName.hashCode();
        n += 23 * this.address;
        n += 23 * this.deviceId;
        n += 23 * this.size;
        return n += 23 * (this.desc == null ? 0 : this.desc.hashCode());
    }
}

