/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.FileUtils;
import com.ecmtuning.ecmlink.util.ListUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocationAlias {
    public static final String GROUP_5V = "5v";
    public static final String[] validGroups = new String[]{"5v"};
    private final String assignedName;
    private final String displayName;
    private final String selectionName;
    private final String desc;
    private final String groupID;
    private final String dataType;
    private final String displayNameOverride;
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = 7414411342836369351L;

    public LocationAlias(LocationAlias locationAlias, String string, String string2) {
        this.assignedName = locationAlias.assignedName;
        this.groupID = locationAlias.groupID;
        this.dataType = locationAlias.dataType;
        this.selectionName = locationAlias.selectionName;
        this.displayName = locationAlias.displayName;
        this.displayNameOverride = string;
        this.desc = string2 == null ? locationAlias.desc : string2;
    }

    LocationAlias(DataObject dataObject) {
        String string = dataObject.getNodeKey();
        String[] stringArray = BasicStrings.dotSplit(string);
        this.assignedName = stringArray[2];
        this.displayName = dataObject.getString("dispname");
        this.displayNameOverride = null;
        this.selectionName = dataObject.getString("selectionname");
        this.desc = dataObject.getString("desc");
        this.dataType = dataObject.getString("datatype");
        this.groupID = dataObject.getString("group");
        this.validateConstruct();
    }

    private LocationAlias(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.assignedName = string;
        this.displayName = string2;
        this.selectionName = string3;
        this.desc = string4;
        this.groupID = string5;
        this.dataType = string6;
        this.displayNameOverride = string7;
        this.validateConstruct();
    }

    private void validateConstruct() {
        if (this.displayName == null) {
            throw new IllegalArgumentException("Must provide displayName for LocationAlias construction");
        }
        if (this.selectionName == null) {
            throw new IllegalArgumentException("Must provide selectionName for LocationAlias construction");
        }
        if (this.dataType == null) {
            throw new IllegalArgumentException("Must provide dataType for LocationAlias construction");
        }
        if (this.groupID == null) {
            throw new IllegalArgumentException("Must provide group for LocationAlias construction");
        }
        if (!ListUtil.contains(validGroups, this.groupID)) {
            throw new IllegalArgumentException("Specified group ID " + this.groupID + " is invalid");
        }
    }

    public String getAssignedName() {
        return this.assignedName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameOverride() {
        return this.displayNameOverride;
    }

    public String getSelectionName() {
        return this.selectionName;
    }

    public String getDescription() {
        if (this.desc == null) {
            return this.displayName;
        }
        return this.desc;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, 7414411342836369351L, 1);
        FileUtils.writeNullableString(this.assignedName, dataOutputStream);
        FileUtils.writeNullableString(this.displayName, dataOutputStream);
        FileUtils.writeNullableString(this.selectionName, dataOutputStream);
        FileUtils.writeNullableString(this.desc, dataOutputStream);
        FileUtils.writeNullableString(this.groupID, dataOutputStream);
        FileUtils.writeNullableString(this.dataType, dataOutputStream);
        FileUtils.writeNullableString(this.displayNameOverride, dataOutputStream);
    }

    public static LocationAlias read(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "Location", 7414411342836369351L, 1);
        String string = FileUtils.readNullableString(dataInputStream);
        String string2 = FileUtils.readNullableString(dataInputStream);
        String string3 = FileUtils.readNullableString(dataInputStream);
        String string4 = FileUtils.readNullableString(dataInputStream);
        String string5 = FileUtils.readNullableString(dataInputStream);
        String string6 = FileUtils.readNullableString(dataInputStream);
        String string7 = FileUtils.readNullableString(dataInputStream);
        return new LocationAlias(string, string2, string3, string4, string5, string6, string7);
    }
}

