/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.ConverterChainEntry;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.DisplayChainEntry;
import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import java.util.List;

class LocationChainEntry
extends DisplayChainEntry {
    private Location location;
    private int tocIndex = -1;
    private String locationAssignedName;
    private String locationDataType;
    private String locationDisplayName;
    private String locationDisplayNameOverride;
    static final int TOCINDEX_NONE = -1;

    LocationChainEntry(String string, String string2, String string3, String string4) {
        super("typeLocation");
        this.setLocationData(string, string2, string3, string4);
    }

    LocationChainEntry(Location location) {
        super("typeLocation");
        this.setLocationData(location.getAssignedName(), location.getDisplayName(), location.getDisplayNameOverride(), location.getDataType());
        this.location = location;
    }

    private LocationChainEntry(LocationChainEntry locationChainEntry, ConverterChainEntry converterChainEntry, int n) {
        super("typeLocation", converterChainEntry, n);
        this.setLocationData(locationChainEntry.locationAssignedName, locationChainEntry.locationDisplayName, locationChainEntry.locationDisplayNameOverride, locationChainEntry.locationDataType);
        this.location = locationChainEntry.location;
        this.tocIndex = locationChainEntry.tocIndex;
    }

    private void setLocationData(String string, String string2, String string3, String string4) {
        this.locationAssignedName = string;
        this.locationDisplayName = string2;
        this.locationDisplayNameOverride = string3;
        this.locationDataType = string4;
    }

    @Override
    String getKeyDescriptor() {
        return this.locationAssignedName + "/" + this.locationDataType;
    }

    @Override
    String getLocalKey() {
        return this.locationAssignedName;
    }

    @Override
    String getDescriptor() {
        return this.locationAssignedName + "/" + this.locationDisplayName + "/" + this.locationDisplayNameOverride + "/" + this.locationDataType;
    }

    static LocationChainEntry parseDescriptor(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length != 4) {
            return null;
        }
        if (!stringArray[3].startsWith("data.")) {
            return null;
        }
        if (stringArray[2].equals("null")) {
            stringArray[2] = null;
        }
        return new LocationChainEntry(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
    }

    @Override
    void applyOverrides(DisplayChainDesc displayChainDesc) {
        if (!displayChainDesc.isRawChain()) {
            if (this.location != null && this.location.getDisplayNameOverride() != null) {
                displayChainDesc.setDisplayName(this.location.getDisplayNameOverride());
            } else if (this.locationDisplayNameOverride != null) {
                displayChainDesc.setDisplayName(this.locationDisplayNameOverride);
            }
        }
    }

    void _applyOverrides(DisplayChainDesc displayChainDesc) {
        if (!displayChainDesc.hasDisplayName()) {
            if (this.location != null) {
                displayChainDesc.setDisplayName(this.location.getDisplayName());
            } else if (this.locationDisplayName != null) {
                displayChainDesc.setDisplayName(this.locationDisplayName);
            }
        }
    }

    @Override
    void addEditPrefsSections(List list, DataPreferences dataPreferences) {
    }

    @Override
    String getOutputDataType() {
        return this.locationDataType;
    }

    @Override
    DisplayChainEntry createCopy(ConverterChainEntry converterChainEntry, int n) {
        return new LocationChainEntry(this, converterChainEntry, n);
    }

    @Override
    void loopReset(DataPreferences dataPreferences) {
    }

    Location getLocation() {
        return this.location;
    }

    String getLocationAssignedName() {
        return this.locationAssignedName;
    }

    String getLocationDataType() {
        return this.locationDataType;
    }

    int registerTOC(LocationTOC locationTOC) {
        if (locationTOC == null) {
            this.registerLocation(null, -1);
            return -1;
        }
        List list = locationTOC.getTOCEntries();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            LocationTOCEntry locationTOCEntry = (LocationTOCEntry)list.get(i);
            if (locationTOCEntry == null || !this.matches(locationTOCEntry.getLocation())) continue;
            this.registerLocation(locationTOCEntry.getLocation(), i);
            return i;
        }
        this.registerLocation(null, -1);
        return -1;
    }

    boolean matches(Location location) {
        return location.matches(this.locationAssignedName, this.locationDataType);
    }

    boolean hasTOCAssociation() {
        return this.tocIndex != -1;
    }

    private void registerLocation(Location location, int n) {
        this.location = location;
        this.tocIndex = n;
        if (location != null) {
            this.setLocationData(location.getAssignedName(), location.getDisplayName(), location.getDisplayNameOverride(), location.getDataType());
        }
    }

    final float processPacket(TSDataPacket tSDataPacket) {
        if (this.tocIndex != -1) {
            float f = tSDataPacket.data[this.tocIndex];
            return f == Float.MIN_VALUE ? f : this.nextEntry.processData(tSDataPacket.timestampMicros, f, this.nextEntryBin);
        }
        return Float.MIN_VALUE;
    }
}

