/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.device.data.LocationTOCListener;
import com.ecmtuning.ecmlink.util.FileUtils;
import com.ecmtuning.ecmlink.util.GenericListenerAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LocationTOC {
    final int deviceId;
    List tocEntries;
    private GenericListenerAdapter tocListeners = new GenericListenerAdapter(LocationTOCListener.class);
    public static final LocationTOC EMPTY_TOC = new LocationTOC(0, Collections.EMPTY_LIST);
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = 5226005630510217106L;

    public LocationTOC(int n, List list) {
        this.deviceId = n;
        this.tocEntries = new ArrayList(list);
    }

    public LocationTOC(int n) {
        this.deviceId = n;
        this.tocEntries = new ArrayList();
    }

    public LocationTOC(LocationTOC locationTOC) {
        this(locationTOC.deviceId, new ArrayList(locationTOC.tocEntries));
    }

    public LocationTOCEntry findMatchingEntry(String string, String string2) {
        for (LocationTOCEntry locationTOCEntry : this.tocEntries) {
            if (!locationTOCEntry.getLocation().matches(string, string2)) continue;
            return locationTOCEntry;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.tocEntries.size() == 0;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public List getTOCEntries() {
        return Collections.unmodifiableList(this.tocEntries);
    }

    public void setTOCEntries(List list) {
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        if (!list.equals(this.tocEntries)) {
            List list2 = this.tocEntries;
            this.tocEntries = list;
            this.tocListeners.fireMethod("newLocationList", LocationTOCListener.PARAMETER_TYPES_NEW_LOCATION_LIST, new Object[]{list2, list});
        }
    }

    public void addLocationTOCListener(LocationTOCListener locationTOCListener) {
        this.tocListeners.addListener(locationTOCListener);
    }

    public void removeLocationTOCListener(LocationTOCListener locationTOCListener) {
        this.tocListeners.removeListener(locationTOCListener);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, 5226005630510217106L, 1);
        dataOutputStream.writeInt(this.deviceId);
        FileUtils.writeList(this.tocEntries, dataOutputStream);
    }

    public static LocationTOC read(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "LocationTOC", 5226005630510217106L, 1);
        int n = dataInputStream.readInt();
        ArrayList arrayList = new ArrayList();
        FileUtils.readList(dataInputStream, arrayList, LocationTOCEntry.class);
        for (Object e : arrayList) {
        }
        return new LocationTOC(n, arrayList);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LocationTOC)) {
            return false;
        }
        return this.deviceId == ((LocationTOC)object).deviceId && this.tocEntries.equals(((LocationTOC)object).tocEntries);
    }

    public int hashCode() {
        return this.tocEntries.hashCode() + this.deviceId * 23;
    }
}

