/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocationTOCEntry {
    private final Location realLocation;
    private final Location aliasedLocation;
    private final boolean alwaysPresent;
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = -2738028873483246749L;

    public LocationTOCEntry(Location location, Location location2, boolean bl) {
        this.realLocation = location;
        this.aliasedLocation = location2 == null ? location : location2;
        this.alwaysPresent = bl;
    }

    public Location getRealLocation() {
        return this.realLocation;
    }

    public Location getLocation() {
        return this.aliasedLocation;
    }

    public String getDisplayName() {
        return this.getLocation().getDisplayName();
    }

    public String getListDisplayName() {
        String string;
        String string2 = this.getRealLocation().getOverridenDisplayName();
        if (string2.equals(string = this.getLocation().getOverridenDisplayName())) {
            return string2;
        }
        return string2 + "(" + string + ")";
    }

    public String getDataType() {
        return this.getLocation().getDataType();
    }

    public String getDescription() {
        return this.getLocation().getDescription();
    }

    public boolean isAlwaysPresent() {
        return this.alwaysPresent;
    }

    public boolean isAliased() {
        if (this.aliasedLocation != this.realLocation) {
            return !this.aliasedLocation.getDataType().equals(this.realLocation.getDataType());
        }
        return false;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, -2738028873483246749L, 1);
        FileUtils.writeObject(this.realLocation, dataOutputStream);
        FileUtils.writeObject(this.aliasedLocation, dataOutputStream);
        dataOutputStream.writeBoolean(this.alwaysPresent);
    }

    public static LocationTOCEntry read(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "LocationTOCEntry", -2738028873483246749L, 1);
        Location location = (Location)FileUtils.readObject(dataInputStream, Location.class);
        Location location2 = (Location)FileUtils.readObject(dataInputStream, Location.class);
        boolean bl = dataInputStream.readBoolean();
        return new LocationTOCEntry(location, location2, bl);
    }

    public String toString() {
        return String.format("LocationTOCEntry(real '%s', alias '%s')", this.realLocation.toString(), this.aliasedLocation.toString());
    }

    public boolean equalsIgnorePresent(LocationTOCEntry locationTOCEntry) {
        return this.realLocation.equals(locationTOCEntry.realLocation) && this.aliasedLocation.equals(locationTOCEntry.aliasedLocation);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LocationTOCEntry)) {
            return false;
        }
        LocationTOCEntry locationTOCEntry = (LocationTOCEntry)object;
        return this.realLocation.equals(locationTOCEntry.realLocation) && this.aliasedLocation.equals(locationTOCEntry.aliasedLocation) && this.alwaysPresent == locationTOCEntry.alwaysPresent;
    }

    public int hashCode() {
        return this.realLocation.hashCode() + 7 * this.aliasedLocation.hashCode() + 13 * (this.alwaysPresent ? 1 : 19);
    }
}

