/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class MemoryBackedPreferences
extends AbstractPreferences {
    private final Hashtable values = new Hashtable();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = 258151239805910591L;

    public MemoryBackedPreferences() {
        super(null, "");
    }

    @Override
    protected String getSpi(String string) {
        return (String)this.values.get(string);
    }

    @Override
    protected void putSpi(String string, String string2) {
        this.values.put(string, string2);
    }

    @Override
    protected void removeSpi(String string) {
        this.values.remove(string);
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        Enumeration enumeration = this.values.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(string);
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    public static void write(DataOutputStream dataOutputStream, Preferences preferences) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, 258151239805910591L, 1);
        try {
            String[] stringArray = preferences.keys();
            dataOutputStream.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                dataOutputStream.writeUTF(stringArray[i]);
                dataOutputStream.writeUTF(preferences.get(stringArray[i], ""));
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static MemoryBackedPreferences read(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "Dataset", 258151239805910591L, 1);
        MemoryBackedPreferences memoryBackedPreferences = new MemoryBackedPreferences();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            memoryBackedPreferences.put(string, string2);
        }
        return memoryBackedPreferences;
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    @Override
    protected AbstractPreferences childSpi(String string) {
        return this;
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return EMPTY_STRING_ARRAY;
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
    }
}

