/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class TSDataPacket {
    public final double timestampMicros;
    public final float[] data;

    public TSDataPacket(double d, float[] fArray) {
        this.timestampMicros = d;
        this.data = new float[fArray.length];
        System.arraycopy(fArray, 0, this.data, 0, fArray.length);
    }

    public TSDataPacket(TSDataPacket tSDataPacket, double d) {
        this.timestampMicros = tSDataPacket.timestampMicros + d;
        this.data = tSDataPacket.data;
    }

    public final void write(DataOutputStream dataOutputStream) throws IOException {
        int n = this.data.length;
        dataOutputStream.writeDouble(this.timestampMicros);
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeFloat(this.data[i]);
        }
    }

    public static TSDataPacket read(DataInputStream dataInputStream) throws IOException {
        double d = dataInputStream.readDouble();
        int n = dataInputStream.readInt();
        if (n > 128) {
            throw new EOFException("Read bogus bad length of " + n);
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = dataInputStream.readFloat();
        }
        return new TSDataPacket(d, fArray);
    }
}

