/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.TimeNavListener;
import com.ecmtuning.ecmlink.util.GenericListenerAdapter;
import java.util.ArrayList;
import java.util.Iterator;

public class TimeNavModel {
    public static final String PROPERTYNAME_TOTAL_WIDTH_TIME = "totalWidthTime";
    public static final String PROPERTYNAME_DISPLAY_WIDTH_TIME = "displayWidthTime";
    public static final String PROPERTYNAME_DISPLAY_CENTER_TIME = "displayCenterTime";
    double widthTime = 0.0;
    double minWidthTime = 0.0;
    double maxWidthTime = Double.MAX_VALUE;
    double centerTime = 0.0;
    double totalWidthTime;
    boolean changing;
    private final GenericListenerAdapter adapter = new GenericListenerAdapter(TimeNavListener.class);

    public void resetMinMaxWidth() {
        this.minWidthTime = 0.0;
        this.maxWidthTime = Double.MAX_VALUE;
    }

    public void setMinWidth(double d) {
        this.minWidthTime = d;
        this.setWidthTime(this.widthTime);
    }

    public void setMaxWidth(double d) {
        this.maxWidthTime = d;
        this.setWidthTime(this.widthTime);
    }

    public boolean isChanging() {
        return this.changing;
    }

    public void setChanging(boolean bl) {
        boolean bl2 = this.changing;
        this.changing = bl;
        if (!this.changing && bl2) {
            this.fireNavChanged();
        }
    }

    public double getWidthTime() {
        return this.widthTime;
    }

    public void setWidthTime(double d) {
        d = this.clipWidthTime(d);
        double d2 = this.widthTime;
        this.widthTime = d;
        if (!this.changing && d2 != this.widthTime) {
            this.fireNavChanged();
        }
    }

    public double getCenterTime() {
        return this.centerTime;
    }

    public double getDisplayStartTime() {
        return this.centerTime - this.widthTime / 2.0;
    }

    public double getDisplayEndTime() {
        return this.centerTime + this.widthTime / 2.0;
    }

    public void setCenterTime(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > this.totalWidthTime) {
            d = this.totalWidthTime;
        }
        double d2 = this.centerTime;
        this.centerTime = d;
        if (!this.changing && d2 != d) {
            this.fireNavChanged();
        }
    }

    private double clipWidthTime(double d) {
        if (d < this.minWidthTime) {
            d = this.minWidthTime;
        }
        if (d > this.maxWidthTime) {
            d = this.maxWidthTime;
        }
        return d;
    }

    private double clipCenterTime(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > this.totalWidthTime) {
            d = this.totalWidthTime;
        }
        return d;
    }

    public void setCenterAndWidthTime(double d, double d2) {
        d = this.clipCenterTime(d);
        double d3 = this.centerTime;
        this.centerTime = d;
        d2 = this.clipWidthTime(d2);
        double d4 = this.widthTime;
        this.widthTime = d2;
        if (!(this.changing || d3 == d && d4 == d2)) {
            this.fireNavChanged();
        }
    }

    public void setCenterAndTotalWidthTime(double d, double d2) {
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        double d3 = this.totalWidthTime;
        this.totalWidthTime = d2;
        d = this.clipCenterTime(d);
        double d4 = this.centerTime;
        this.centerTime = d;
        if (!(this.changing || d4 == d && d3 == d2)) {
            this.fireNavChanged();
        }
    }

    public double getTotalWidthTime() {
        return this.totalWidthTime;
    }

    public void setTotalWidthTime(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d < this.centerTime) {
            this.setCenterAndTotalWidthTime(d, d);
        } else {
            double d2 = this.totalWidthTime;
            this.totalWidthTime = d;
            if (!this.changing && d2 != d) {
                this.fireNavChanged();
            }
        }
    }

    public final void addTimeNavListener(TimeNavListener timeNavListener) {
        this.adapter.addListener(timeNavListener);
    }

    public final void removeTimeNavListener(TimeNavListener timeNavListener) {
        this.adapter.removeListener(timeNavListener);
    }

    protected final void fireNavChanged() {
        Iterator iterator = new ArrayList(this.adapter.getListeners()).iterator();
        while (iterator.hasNext()) {
            ((TimeNavListener)iterator.next()).navigationChanged(this.centerTime, this.widthTime, this.totalWidthTime);
        }
    }
}

