/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data;

import com.ecmtuning.ecmlink.device.data.TimeSelectionListener;
import com.ecmtuning.ecmlink.util.GenericListenerAdapter;
import java.util.ArrayList;
import java.util.Iterator;

public final class TimeSelectionModel {
    public static final double NULL_TIME = Double.MIN_VALUE;
    private double anchorTime = Double.MIN_VALUE;
    private double extentTime = Double.MIN_VALUE;
    private final GenericListenerAdapter adapter = new GenericListenerAdapter(TimeSelectionListener.class);

    public final void clearSelection() {
        this.setSelectionTime(Double.MIN_VALUE, Double.MIN_VALUE);
    }

    public final boolean isTimeInSelection(double d) {
        if (!this.isSelectionActive()) {
            return false;
        }
        return d >= this.anchorTime && d <= this.extentTime || d >= this.extentTime && d <= this.anchorTime;
    }

    public final boolean isSelectionActive() {
        return this.anchorTime != Double.MIN_VALUE;
    }

    public final boolean isMomentSelection() {
        return this.anchorTime != Double.MIN_VALUE && this.anchorTime == this.extentTime;
    }

    public final double getAnchorTime() {
        return this.anchorTime;
    }

    public final double getExtentTime() {
        return this.extentTime;
    }

    public final void setAnchorTime(double d) {
        double d2 = this.anchorTime;
        this.anchorTime = d;
        if (d2 != this.anchorTime) {
            this.fireSelectionChanged();
        }
    }

    public final void setExtentTime(double d) {
        if (this.anchorTime == Double.MIN_VALUE) {
            this.setMomentSelection(d);
        } else {
            double d2 = this.extentTime;
            this.extentTime = d;
            if (this.extentTime != d2) {
                this.fireSelectionChanged();
            }
        }
    }

    public final void setMomentSelection(double d) {
        double d2 = this.anchorTime;
        this.anchorTime = d;
        double d3 = this.extentTime;
        this.extentTime = d;
        if (d2 != this.anchorTime || d3 != this.extentTime) {
            this.fireSelectionChanged();
        }
    }

    public final void setSelectionTime(double d, double d2) {
        double d3 = this.anchorTime;
        this.anchorTime = d;
        double d4 = this.extentTime;
        this.extentTime = d2;
        if (d3 != this.anchorTime || d4 != this.extentTime) {
            this.fireSelectionChanged();
        }
    }

    public void addTimeSelectionListener(TimeSelectionListener timeSelectionListener) {
        this.adapter.addListener(timeSelectionListener);
    }

    public void removeTimeSelectionListener(TimeSelectionListener timeSelectionListener) {
        this.adapter.removeListener(timeSelectionListener);
    }

    private void fireSelectionChanged() {
        Iterator iterator = new ArrayList(this.adapter.getListeners()).iterator();
        while (iterator.hasNext()) {
            ((TimeSelectionListener)iterator.next()).selectionChanged(this.anchorTime, this.extentTime);
        }
    }
}

