/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.converter.DisplayUnits;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import com.ecmtuning.ecmlink.model.LambdaFilter;
import java.util.ArrayList;
import java.util.List;

public class AFMixtureUnits
extends DisplayUnits {
    final LambdaFilter lambdaValueFilter;

    public AFMixtureUnits(DataObject dataObject) {
        super(dataObject);
        if (this.unitsValueFilter instanceof LambdaFilter) {
            this.lambdaValueFilter = ((LambdaFilter)this.unitsValueFilter).createNewInstance();
            this.unitsValueFilter = this.lambdaValueFilter;
        } else {
            this.lambdaValueFilter = null;
        }
    }

    public AFMixtureUnits(AFMixtureUnits aFMixtureUnits) {
        super(aFMixtureUnits);
        if (this.unitsValueFilter instanceof LambdaFilter) {
            this.lambdaValueFilter = ((LambdaFilter)this.unitsValueFilter).createNewInstance();
            this.unitsValueFilter = this.lambdaValueFilter;
        } else {
            this.lambdaValueFilter = null;
        }
    }

    @Override
    public Converter createCopy() {
        return new AFMixtureUnits(this);
    }

    @Override
    public void applyOverrides(DisplayChainDesc displayChainDesc) {
        super.applyOverrides(displayChainDesc);
        if (this.lambdaValueFilter != null) {
            displayChainDesc.setPrec(new Integer(this.lambdaValueFilter.getPreferredPrec()));
        }
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addStoichRatioEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("A/F ratio display", arrayList));
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        super.loopReset(dataPreferences);
        if (this.lambdaValueFilter != null) {
            this.lambdaValueFilter.setStoichRatio(ConverterPrefs.getStoichRatio(dataPreferences));
        }
    }
}

