/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class AFRatioEstimate
extends Converter {
    float injFlowRateCcPerMin = 450.0f;
    float injDeadTimeAdj = 0.0f;
    float fuelPressurePsig = 43.5f;
    float fuelStoichRatio = 14.7f;
    float fuelSpecificGravity = 0.76f;
    float injFlowRateGmPerSec = 5.7f * (float)Math.pow((double)this.fuelPressurePsig / 43.5, 0.5);
    protected static final float[] adjusts = new float[]{0.9933f, 0.9217f, 0.9754f, 0.9843f, 1.0022f, 0.9933f, 0.9485f, 0.9485f};

    public AFRatioEstimate(DataObject dataObject) {
        super(dataObject.getNodeKey(), 3);
    }

    protected AFRatioEstimate(AFRatioEstimate aFRatioEstimate) {
        super(aFRatioEstimate);
        this.injFlowRateCcPerMin = aFRatioEstimate.injFlowRateCcPerMin;
        this.injDeadTimeAdj = aFRatioEstimate.injDeadTimeAdj;
        this.fuelPressurePsig = aFRatioEstimate.fuelPressurePsig;
        this.fuelStoichRatio = aFRatioEstimate.fuelStoichRatio;
        this.fuelSpecificGravity = aFRatioEstimate.fuelSpecificGravity;
        this.injFlowRateGmPerSec = aFRatioEstimate.injFlowRateGmPerSec;
    }

    @Override
    protected float convert(double d) {
        float f;
        float f2;
        float f3 = this.inputBin[0];
        float f4 = this.inputBin[1];
        float f5 = this.inputBin[2];
        int n = (int)(f5 / 50.0f);
        if (n >= 7) {
            f5 *= adjusts[7];
        } else {
            f2 = f5 - (float)n * 50.0f;
            f5 *= adjusts[n] + (adjusts[n + 1] - adjusts[n]) * f2 / 50.0f;
        }
        f2 = 6.0E7f / f4 * 2.0f;
        float f6 = f3 * 1000.0f - 700.0f - this.injDeadTimeAdj;
        if (f6 > f2) {
            f6 = f2;
        }
        if ((f = this.injFlowRateGmPerSec * (f6 / f2) * 4.0f) <= 0.0f) {
            return 1.0f;
        }
        return f5 / f / this.fuelStoichRatio;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.injFlowRateCcPerMin = ConverterPrefs.getInjectorSizeCcPerMin(dataPreferences);
        this.injDeadTimeAdj = ConverterPrefs.getInjectorDeadTimeAdjUsecs(dataPreferences);
        this.fuelPressurePsig = ConverterPrefs.getFuelPressurePsig(dataPreferences);
        this.fuelStoichRatio = ConverterPrefs.getFuelStoichRatio(dataPreferences);
        this.fuelSpecificGravity = ConverterPrefs.getFuelSpecificGravity(dataPreferences);
        this.injFlowRateGmPerSec = this.injFlowRateCcPerMin / 60.0f * this.fuelSpecificGravity * (float)Math.pow((double)this.fuelPressurePsig / 43.5, 0.5);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addInjectorSizeEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Fuel flow", arrayList));
        arrayList = new ArrayList();
        ConverterPrefs.addFuelStoichRatioEditPrefs(arrayList, dataPreferences);
        ConverterPrefs.addFuelSpecificGravityPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Fuel characteristics", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new AFRatioEstimate(this);
    }
}

