/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.converter.DisplayUnits;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import com.ecmtuning.ecmlink.model.AirPressureFilter;
import java.util.ArrayList;
import java.util.List;

public class AirPressureUnits
extends DisplayUnits {
    final AirPressureFilter airPressureValueFilter;

    public AirPressureUnits(DataObject dataObject) {
        super(dataObject);
        if (this.unitsValueFilter instanceof AirPressureFilter) {
            this.airPressureValueFilter = ((AirPressureFilter)this.unitsValueFilter).createNewInstance();
            this.unitsValueFilter = this.airPressureValueFilter;
        } else {
            this.airPressureValueFilter = null;
        }
    }

    public AirPressureUnits(AirPressureUnits airPressureUnits) {
        super(airPressureUnits);
        if (this.unitsValueFilter instanceof AirPressureFilter) {
            this.airPressureValueFilter = ((AirPressureFilter)this.unitsValueFilter).createNewInstance();
            this.unitsValueFilter = this.airPressureValueFilter;
        } else {
            this.airPressureValueFilter = null;
        }
    }

    @Override
    public Converter createCopy() {
        return new AirPressureUnits(this);
    }

    @Override
    public void applyOverrides(DisplayChainDesc displayChainDesc) {
        super.applyOverrides(displayChainDesc);
        if (this.airPressureValueFilter != null) {
            displayChainDesc.setPrec(new Integer(this.airPressureValueFilter.getPreferredPrec()));
        }
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addAltitudeEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Air pressure", arrayList));
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        super.loopReset(dataPreferences);
        if (this.airPressureValueFilter != null) {
            this.airPressureValueFilter.setAltitudeFt(ConverterPrefs.getAltitudeFeet(dataPreferences));
        }
    }
}

