/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import java.util.Arrays;

public class Averager {
    protected float smoothing;
    float sum = 0.0f;
    float count = 0.0f;
    float[] values;
    int index;
    boolean firstTime = true;

    public void reset(float f) {
        this.smoothing = f;
        this.sum = 0.0f;
        this.count = 0.0f;
        this.firstTime = true;
        if (this.smoothing < 0.0f) {
            throw new IllegalArgumentException("smoothing must greather than or equal to 0");
        }
        if (this.smoothing > 1.0f) {
            this.smoothing = Math.round(this.smoothing);
        }
        if (this.smoothing >= 1.0f) {
            this.values = new float[(int)this.smoothing];
        }
    }

    public float next(float f) {
        if (this.smoothing > 0.0f && this.smoothing < 1.0f) {
            if (this.firstTime) {
                this.sum = f;
                this.firstTime = false;
            } else {
                this.sum = this.sum * this.smoothing + f * (1.0f - this.smoothing);
            }
            return this.sum;
        }
        if (this.smoothing >= 1.0f) {
            if (this.firstTime) {
                Arrays.fill(this.values, f);
                this.index = 0;
                this.sum = this.smoothing * f;
                this.firstTime = false;
            } else {
                this.sum += f - this.values[this.index];
                this.values[this.index++] = f;
                if ((float)this.index >= this.smoothing) {
                    this.index = 0;
                }
            }
            return this.sum / this.smoothing;
        }
        this.sum += f;
        this.count += 1.0f;
        return this.sum / this.count;
    }
}

