/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;

public class Base
extends Converter {
    private static final String PROP_NAME_XOFFSET = "converter.xoffset";
    private static final String PROP_NAME_XCLIP_MIN = "converter.xclip.min";
    private static final String PROP_NAME_XCLIP_MIN_YVAL = "converter.xclip.min.yval";
    private static final String PROP_NAME_XCLIP_MAX = "converter.xclip.max";
    private static final String PROP_NAME_XCLIP_MAX_YVAL = "converter.xclip.max.yval";
    private static final String PROP_NAME_XMASK = "converter.xmask";
    private static final String PROP_NAME_DIVIDEND = "converter.dividend";
    private static final String PROP_NAME_DIVISOR = "converter.divisor";
    private static final String PROP_NAME_FACTOR = "converter.factor";
    private static final String PROP_NAME_YOFFSET = "converter.yoffset";
    protected final float xoffset;
    protected final float factor;
    protected final float yoffset;
    protected final Float xclipmin;
    protected final Float xclipminyval;
    protected final Float xmask;
    protected final Float xclipmax;
    protected final Float xclipmaxyval;
    protected final float xclipminValue;
    protected final float xclipmaxValue;
    protected final Float dividend;
    protected final float dividendValue;
    private static final Float ZERO = new Float(0.0f);
    private static final Float ONE = new Float(1.0f);

    public Base(DataObject dataObject) {
        super(dataObject.getNodeKey(), 1);
        this.xoffset = dataObject.getFloat(PROP_NAME_XOFFSET, ZERO).floatValue();
        this.yoffset = dataObject.getFloat(PROP_NAME_YOFFSET, ZERO).floatValue();
        float f = dataObject.getFloat(PROP_NAME_DIVISOR, ONE).floatValue();
        if (f == 0.0f) {
            throw new IllegalArgumentException("Divisor can't be zero");
        }
        this.factor = dataObject.getFloat(PROP_NAME_FACTOR, ONE).floatValue() / f;
        this.dividend = dataObject.getFloat(PROP_NAME_DIVIDEND);
        this.dividendValue = this.dividend == null ? 0.0f : this.dividend.floatValue();
        this.xclipmin = dataObject.getFloat(PROP_NAME_XCLIP_MIN);
        this.xclipminValue = this.xclipmin == null ? Float.MIN_VALUE : this.xclipmin.floatValue();
        this.xclipminyval = dataObject.getFloat(PROP_NAME_XCLIP_MIN_YVAL);
        this.xclipmax = dataObject.getFloat(PROP_NAME_XCLIP_MAX);
        this.xclipmaxValue = this.xclipmax == null ? Float.MAX_VALUE : this.xclipmax.floatValue();
        this.xclipmaxyval = dataObject.getFloat(PROP_NAME_XCLIP_MAX_YVAL);
        this.xmask = dataObject.getFloat(PROP_NAME_XMASK);
    }

    protected Base(Base base) {
        super(base);
        this.xoffset = base.xoffset;
        this.yoffset = base.yoffset;
        this.factor = base.factor;
        this.dividend = base.dividend;
        this.dividendValue = base.dividendValue;
        this.xclipmin = base.xclipmin;
        this.xclipminValue = base.xclipminValue;
        this.xclipminyval = base.xclipminyval;
        this.xclipmax = base.xclipmax;
        this.xclipmaxValue = base.xclipmaxValue;
        this.xclipmaxyval = base.xclipmaxyval;
        this.xmask = base.xmask;
    }

    protected float _convert(double d, float f) {
        return f;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
    }

    @Override
    protected float convert(double d) {
        return Float.MIN_VALUE;
    }

    @Override
    public float receiveInput(double d, float f, int n) {
        float f2 = f;
        if (this.xclipmin != null && f2 <= this.xclipminValue) {
            if (this.xclipminyval != null) {
                return this.xclipminyval.floatValue();
            }
            f2 = this.xclipminValue;
        }
        if (this.xclipmax != null && f2 >= this.xclipmaxValue) {
            if (this.xclipmaxyval != null) {
                return this.xclipmaxyval.floatValue();
            }
            f2 = this.xclipmaxValue;
        }
        if (this.xmask != null) {
            f2 = (int)f2 & this.xmask.intValue();
        }
        f2 = (f2 + this.xoffset) * this.factor;
        if (this.dividend != null) {
            f2 = f2 == 0.0f ? (this.dividendValue < 0.0f ? Float.MIN_VALUE : Float.MAX_VALUE) : this.dividendValue / f2;
        }
        f2 = this._convert(d, f2);
        return f2 + this.yoffset;
    }

    @Override
    public Converter createCopy() {
        return new Base(this);
    }
}

