/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class BaseFuelPressure
extends Converter {
    private static final float AIR_PRESSURE_AT_SEALEVEL = 14.695f;
    float atmPressPSI = 14.695f;

    public BaseFuelPressure(DataObject dataObject) {
        super(dataObject.getNodeKey(), 2);
    }

    protected BaseFuelPressure(BaseFuelPressure baseFuelPressure) {
        super(baseFuelPressure);
    }

    @Override
    protected float convert(double d) {
        return this.inputBin[1] + this.atmPressPSI - this.inputBin[0];
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        float f = ConverterPrefs.getAltitudeFeet(dataPreferences);
        this.atmPressPSI = 14.695f * (float)Math.pow(1.0 - 6.88E-6 * (double)f, 5.26);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addAltitudeEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Air pressure", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new BaseFuelPressure(this);
    }
}

