/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;

public class BitMask
extends Converter {
    private static final String PROP_NAME_MASK = "converter.mask";
    private static final String PROP_NAME_NEGATE = "converter.negate";
    private final int mask;
    private final int negateMask;

    public BitMask(DataObject dataObject) {
        super(dataObject.getNodeKey(), 1);
        this.mask = dataObject.getInteger(PROP_NAME_MASK);
        this.negateMask = dataObject.containsKey(PROP_NAME_NEGATE) ? this.mask : 0;
    }

    protected BitMask(BitMask bitMask) {
        super(bitMask);
        this.mask = bitMask.mask;
        this.negateMask = bitMask.negateMask;
    }

    @Override
    protected float convert(double d) {
        return Float.MIN_VALUE;
    }

    @Override
    public float receiveInput(double d, float f, int n) {
        return (this.negateMask ^ this.mask & (int)f) == 0 ? 0.0f : 1.0f;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
    }

    @Override
    public Converter createCopy() {
        return new BitMask(this);
    }
}

