/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class BoostEst
extends Converter {
    float displacement = 2.0f;

    public BoostEst(DataObject dataObject) {
        super(dataObject.getNodeKey(), 1);
    }

    protected BoostEst(BoostEst boostEst) {
        super(boostEst);
        this.displacement = boostEst.displacement;
    }

    @Override
    protected float convert(double d) {
        float f = this.inputBin[0];
        float f2 = f * 13.0f;
        f2 = f2 * 2.0f / this.displacement;
        return f2;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.displacement = ConverterPrefs.getDisplacementLiters(dataPreferences);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addDisplacementEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Engine", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new BoostEst(this);
    }
}

