/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataAdapter;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.SystemDataAdapter;
import com.ecmtuning.ecmlink.device.data.UserDataAdapter;
import com.ecmtuning.ecmlink.util.BasicStrings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Converter {
    private static final Logger logger = Logger.getLogger(Converter.class.getName());
    private static final boolean fineLogging = logger.isLoggable(Level.FINE);
    private static final boolean finestLogging = logger.isLoggable(Level.FINEST);
    private static final String defaultConverterPackage = Converter.class.getPackage().getName();
    public static final int INPUT_BIN_MAX_COUNT = 4;
    private static final Class[] CONVERTER_CONSTRUCTOR_PARAMETERS = new Class[]{DataObject.class};
    protected final String converterKey;
    protected final float[] inputBin;
    protected int inputBinMask;
    protected final int fullInputBinMask;
    protected final boolean singleInput;
    private static final int[] fullInputBinMaskLookup = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private static final int[] inputBinMaskLookup = new int[]{1, 2, 4, 8, 16, 32, 64, 128};

    public abstract void loopReset(DataPreferences var1);

    protected abstract float convert(double var1);

    public abstract Converter createCopy();

    public void applyOverrides(DisplayChainDesc displayChainDesc) {
    }

    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
    }

    public int getNumInputBins() {
        return this.inputBin.length;
    }

    public float receiveInput(double d, float f, int n) {
        if (this.singleInput) {
            this.inputBin[0] = f;
            return this.convert(d);
        }
        this.inputBin[n] = f;
        this.inputBinMask |= inputBinMaskLookup[n];
        if (this.inputBinMask == this.fullInputBinMask) {
            this.inputBinMask = 0;
            return this.convert(d);
        }
        return Float.MIN_VALUE;
    }

    protected Converter(String string, int n) {
        if (n > 4) {
            throw new IllegalArgumentException("Too many inputs.  Maximum is 4");
        }
        this.converterKey = string;
        this.inputBinMask = 0;
        this.fullInputBinMask = fullInputBinMaskLookup[n];
        this.singleInput = n == 1;
        this.inputBin = new float[n];
    }

    protected Converter(Converter converter) {
        this(converter.converterKey, converter.inputBin.length);
    }

    public static Converter constructConverter(DataObject dataObject) {
        String[] stringArray = BasicStrings.dotSplit(dataObject.getNodeKey());
        DataAdapter dataAdapter = DataManager.getAdapterByArea(stringArray[1]);
        if (dataAdapter == null) {
            throw new IllegalArgumentException("Unable to find adapter " + stringArray[1]);
        }
        String string = dataObject.getString("converter");
        Converter converter = null;
        if (!(dataAdapter instanceof SystemDataAdapter) && !(dataAdapter instanceof UserDataAdapter)) {
            converter = Converter.loadConverterClass(dataAdapter.getConverterPackageName() + "." + string, dataObject);
        }
        if (converter == null && (converter = Converter.loadConverterClass(defaultConverterPackage + "." + string, dataObject)) == null) {
            throw new IllegalArgumentException("Failed to load converter class " + string);
        }
        return converter;
    }

    private static Converter loadConverterClass(String string, DataObject dataObject) {
        ReflectiveOperationException reflectiveOperationException = null;
        if (finestLogging) {
            logger.finest("Attempting to instantiate converter class " + string);
        }
        try {
            Class<?> clazz = Converter.class.getClassLoader().loadClass(string);
            Constructor<?> constructor = clazz.getConstructor(CONVERTER_CONSTRUCTOR_PARAMETERS);
            return (Converter)constructor.newInstance(dataObject);
        }
        catch (InvocationTargetException invocationTargetException) {
            reflectiveOperationException = invocationTargetException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            reflectiveOperationException = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (fineLogging) {
                logger.finest("Failed to find converter class " + string);
            }
            return null;
        }
        logger.log(Level.WARNING, "Failed to instantiate converter class " + string, reflectiveOperationException);
        return null;
    }

    public String getDataPrefsKeyPrefix() {
        return this.converterKey;
    }
}

