/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.prefsedit.TextEditPref;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.model.UnitsModel;
import java.util.List;
import java.util.prefs.Preferences;

public final class ConverterPrefs {
    public static final String PREFS_KEY_ALTITUDE_FEET = "altitude";
    public static final float DEFAULT_ALTITUDE_FEET = 0.0f;
    public static final String PREFS_KEY_STOICH_RATIO = "stoichratio";
    public static final float DEFAULT_STOICH_RATIO = 14.7f;
    public static final String PREFS_KEY_INJECTOR_SIZE_CC_PER_MIN = "injsize";
    public static final float DEFAULT_INJECTOR_SIZE_CC_PER_MIN = 450.0f;
    public static final String PREFS_KEY_INJECTOR_DEADTIME_ADJ_USECS = "injdeadtimeadj";
    public static final float DEFAULT_INJECTOR_DEADTIME_ADJ_USECS = 0.0f;
    public static final String PREFS_KEY_FUELPRESSURE_PSIG = "fuelpressure";
    public static final float DEFAULT_FUELPRESSURE_PSIG = 43.5f;
    public static final String PREFS_KEY_FUELFLOW_FACTOR = "fuelflowfactor";
    public static final float DEFAULT_FUELFLOW_FACTOR = 1.0f;
    public static final String PREFS_KEY_INJECTOR_OFFSET_USECS = "injoffset";
    public static final float DEFAULT_INJECTOR_OFFSET_USECS = 0.0f;
    public static final String PREFS_KEY_DISPLACEMENT_LITERS = "displacement";
    public static final float DEFAULT_DISPLACEMENT_LITERS = 2.0f;
    public static final String PREFS_KEY_FUEL_STOICH_RATIO = "fuelstoichratio";
    public static final float DEFAULT_FUEL_STOICH_RATIO = 14.7f;
    public static final String PREFS_KEY_FUEL_SPECIFIC_GRAVITY = "fuelspecgrav";
    public static final float DEFAULT_FUEL_SPECIFIC_GRAVITY = 0.76f;
    public static final String PREFS_KEY_SPEED_CORRECTION = "speedocorrection";
    public static final float DEFAULT_SPEED_CORRECTION = 1.0f;
    public static final String PREFS_KEY_GLON_CORRECTION = "gloncorrection";
    public static final String PREFS_KEY_GLAT_CORRECTION = "glatcorrection";
    public static final float DEFAULT_G_CORRECTION = 0.0f;
    public static final String PREFS_KEY_GEAR1_RATIO = "gear1ratio";
    public static final float DEFAULT_GEAR1_RATIO = 215.0f;
    public static final String PREFS_KEY_GEAR2_RATIO = "gear2ratio";
    public static final float DEFAULT_GEAR2_RATIO = 116.0f;
    public static final String PREFS_KEY_GEAR3_RATIO = "gear3ratio";
    public static final float DEFAULT_GEAR3_RATIO = 76.0f;
    public static final String PREFS_KEY_GEAR4_RATIO = "gear4ratio";
    public static final float DEFAULT_GEAR4_RATIO = 57.0f;
    public static final String PREFS_KEY_GEAR5_RATIO = "gear5ratio";
    public static final float DEFAULT_GEAR5_RATIO = 46.0f;
    public static final String PREFS_KEY_VEHICLE_MASS_LBS = "vehiclemasslbs";
    public static final float DEFAULT_VEHICLE_MASS_LBS = 3400.0f;
    public static final String PREFS_KEY_DRIVETRAIN_LOSS = "drivetrainloss";
    public static final float DEFAULT_DRIVETRAIN_LOSS = 0.2f;
    public static final String PREFS_KEY_TORQUE_INPUT_SMOOTHING = "torqueinputsmoothing";
    public static final float DEFAULT_TORQUE_INPUT_SMOOTHING = 4.0f;
    public static final String PREFS_KEY_TORQUE_OUTPUT_SMOOTHING = "torqueoutputsmoothing";
    public static final float DEFAULT_TORQUE_OUTPUT_SMOOTHING = 3.0f;
    public static final String PREFS_KEY_MILEAGE_INPUT_SMOOTHING = "mileageinputsmoothing";
    public static final float DEFAULT_MILEAGE_INPUT_SMOOTHING = 20.0f;

    public static final float getAltitudeFeet(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_ALTITUDE_FEET, 0.0f);
    }

    public static final void addAltitudeEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_ALTITUDE_FEET, 0.0f);
        list.add(textEditPref);
        textEditPref.set("Altitude", "Current altitude for estimation of atmospheric pressure", null);
        textEditPref.installClipFilter(-500.0f, 20000.0f);
        UnitsHelper.addFilter(textEditPref.getFilteredModel(), "typeDistanceFromFeet");
        textEditPref.installFinalNumberFilter(0);
        textEditPref.setUnitText(UnitsHelper.getUnitsLabel("typeDistanceFromFeet"));
    }

    public static final float getInjectorSizeCcPerMin(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_INJECTOR_SIZE_CC_PER_MIN, 450.0f);
    }

    public static final float getInjectorDeadTimeAdjUsecs(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_INJECTOR_DEADTIME_ADJ_USECS, 0.0f);
    }

    public static final float getFuelPressurePsig(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_FUELPRESSURE_PSIG, 43.5f);
    }

    public static final void addInjectorSizeEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_INJECTOR_SIZE_CC_PER_MIN, 450.0f);
        list.add(textEditPref);
        textEditPref.set("Injector flow rate", "Effective injector flow rate at 43.5 psi; may not match injector size", null);
        textEditPref.installClipFilter(260.0f, 2200.0f);
        UnitsHelper.addFilter(textEditPref.getFilteredModel(), "typeFuelFlowFromCCPM");
        UnitsModel unitsModel = UnitsModel.getInstance();
        boolean bl = UnitsModel.INDEX_INJECTOR_SIZE_CCPMIN.equals(unitsModel.getInjectorSizeIndex());
        textEditPref.installFinalNumberFilter(bl ? 0 : 1);
        textEditPref.setUnitText(UnitsHelper.getUnitsLabel("typeFuelFlowFromCCPM"));
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_INJECTOR_DEADTIME_ADJ_USECS, 0.0f);
        list.add(textEditPref);
        textEditPref.set("Deadtime adj", "Deadtime adjustment used for these injectors (above stock)", "\u00b5secs");
        textEditPref.installFinalClipFilter(-2000.0f, 2000.0f, 0);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_FUELPRESSURE_PSIG, 43.5f);
        list.add(textEditPref);
        textEditPref.set("Fuel pressure", "Base fuel pressure", null);
        textEditPref.installClipFilter(25.0f, 60.0f);
        UnitsHelper.addFilter(textEditPref.getFilteredModel(), "typeFluidPressureFromPSIG");
        UnitsModel unitsModel2 = UnitsModel.getInstance();
        boolean bl2 = UnitsModel.INDEX_FLUID_PRESSURE_KPA.equals(unitsModel2.getFluidPressureIndex());
        textEditPref.installFinalNumberFilter(bl2 ? 0 : 1);
        textEditPref.setUnitText(UnitsHelper.getUnitsLabel("typeFluidPressureFromPSIG"));
    }

    public static final float getFuelFlowFactor(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_FUELFLOW_FACTOR, 1.0f);
    }

    public static final float getInjectorOffsetUsecs(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_INJECTOR_OFFSET_USECS, 0.0f);
    }

    public static final void addFuelFlowEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_FUELFLOW_FACTOR, 1.0f);
        list.add(textEditPref);
        textEditPref.set("Fuel flow factor", "Scales fuel flow by the given factor.  A value of 1 means no scale.", null);
        textEditPref.installFinalClipFilter(0.0f, 4.0f, 3);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_INJECTOR_OFFSET_USECS, 0.0f);
        list.add(textEditPref);
        textEditPref.set("Offset (normally zero)", "Injector on-time offset.", "\u00b5secs");
        textEditPref.installFinalClipFilter(-2000.0f, 2000.0f, 0);
    }

    public static final float getStoichRatio(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_STOICH_RATIO, 14.7f);
    }

    public static final void addStoichRatioEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_STOICH_RATIO, 14.7f);
        list.add(textEditPref);
        textEditPref.set("Displayed stoich ratio", "The stoichiometric ratio at which the A/F ratio is displayed; e.g., 14.7 for gasoline.", ":1");
        textEditPref.installFinalClipFilter(4.0f, 16.0f, 1);
    }

    public static final float getFuelStoichRatio(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_FUEL_STOICH_RATIO, 14.7f);
    }

    public static final void addFuelStoichRatioEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_FUEL_STOICH_RATIO, 14.7f);
        list.add(textEditPref);
        textEditPref.set("Actual stoich ratio", "The stoichiometric ratio for your fuel type; e.g., 14.7 for gasoline", ":1");
        textEditPref.installFinalClipFilter(4.0f, 16.0f, 1);
    }

    public static final float getFuelSpecificGravity(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_FUEL_SPECIFIC_GRAVITY, 0.76f);
    }

    public static final void addFuelSpecificGravityPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_FUEL_SPECIFIC_GRAVITY, 0.76f);
        list.add(textEditPref);
        textEditPref.set("Specific gravity", "The specific gravity of the your fuel; e.g., 0.76 for gasoline", null);
        textEditPref.installFinalClipFilter(0.1f, 1.0f, 3);
    }

    public static final float getDisplacementLiters(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_DISPLACEMENT_LITERS, 2.0f);
    }

    public static final void setDisplacementLiters(DataPreferences dataPreferences, float f) {
        dataPreferences.putFloat(PREFS_KEY_DISPLACEMENT_LITERS, f);
    }

    public static final void addDisplacementEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_DISPLACEMENT_LITERS, 2.0f);
        list.add(textEditPref);
        textEditPref.set("Displacement", "Engine displacement for estimation of boost from airflow/rev", "L");
        textEditPref.installFinalClipFilter(1.6f, 3.0f, 2);
    }

    public static final float getSpeedCorrection(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_SPEED_CORRECTION, 1.0f);
    }

    public static final void addSpeedCorrectionEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_SPEED_CORRECTION, 1.0f);
        list.add(textEditPref);
        textEditPref.set("Speed Correction", "Speed correction factor, 1.00 = no correction", "-");
        textEditPref.installFinalClipFilter(0.5f, 2.0f, 2);
    }

    public static final float getGCorrection(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_GLON_CORRECTION, 0.0f);
    }

    public static final void addGLonCorrectionEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_GLON_CORRECTION, 0.0f);
        list.add(textEditPref);
        textEditPref.set("Longitudinal G Error", "Longitudinal G error, enter the level-car G reading", "-");
        textEditPref.installFinalClipFilter(-0.5f, 0.5f, 2);
    }

    public static final void addGLatCorrectionEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_GLAT_CORRECTION, 0.0f);
        list.add(textEditPref);
        textEditPref.set("Lateral G Error", "Lateral G error, enter the level-car G reading", "-");
        textEditPref.installFinalClipFilter(-0.5f, 0.5f, 2);
    }

    public static final float getGear1Ratio(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_GEAR1_RATIO, 215.0f);
    }

    public static final float getGear2Ratio(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_GEAR2_RATIO, 116.0f);
    }

    public static final float getGear3Ratio(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_GEAR3_RATIO, 76.0f);
    }

    public static final float getGear4Ratio(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_GEAR4_RATIO, 57.0f);
    }

    public static final float getGear5Ratio(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_GEAR5_RATIO, 46.0f);
    }

    public static final void addGearRatioEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_GEAR1_RATIO, 215.0f);
        list.add(textEditPref);
        textEditPref.set("First Gear", "RPM/speed", "-");
        textEditPref.installFinalClipFilter(0.0f, 300.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_GEAR2_RATIO, 116.0f);
        list.add(textEditPref);
        textEditPref.set("Second Gear", "RPM/speed", "-");
        textEditPref.installFinalClipFilter(0.0f, 300.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_GEAR3_RATIO, 76.0f);
        list.add(textEditPref);
        textEditPref.set("Third Gear", "RPM/speed", "-");
        textEditPref.installFinalClipFilter(0.0f, 300.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_GEAR4_RATIO, 57.0f);
        list.add(textEditPref);
        textEditPref.set("Fourth Gear", "RPM/speed", "-");
        textEditPref.installFinalClipFilter(0.0f, 300.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_GEAR5_RATIO, 46.0f);
        list.add(textEditPref);
        textEditPref.set("Fifth Gear", "RPM/speed", "-");
        textEditPref.installFinalClipFilter(0.0f, 300.0f, 2);
    }

    public static final float getVehicleMass(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_VEHICLE_MASS_LBS, 3400.0f);
    }

    public static final void addVehicleMassEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_VEHICLE_MASS_LBS, 3400.0f);
        list.add(textEditPref);
        textEditPref.set("Vehicle Mass", "with driver", "lbs");
        textEditPref.installFinalClipFilter(2000.0f, 4000.0f, 0);
    }

    public static final float getDrivetrainLoss(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_DRIVETRAIN_LOSS, 0.2f);
    }

    public static final void addDrivetrainLossEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_DRIVETRAIN_LOSS, 0.2f);
        list.add(textEditPref);
        textEditPref.set("Drivetrain Loss", "e.g. 0.20", "-");
        textEditPref.installFinalClipFilter(0.0f, 0.5f, 2);
    }

    public static final float getTorqueInputSmoothing(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_TORQUE_INPUT_SMOOTHING, 4.0f);
    }

    public static final void addTorqueInputSmoothingEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_TORQUE_INPUT_SMOOTHING, 4.0f);
        list.add(textEditPref);
        textEditPref.set("Input Smoothing", "enter a number from 1 to 100, 1 = no smoothing", "-");
        textEditPref.installFinalClipFilter(1.0f, 100.0f, 0);
    }

    public static final float getTorqueOutputSmoothing(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_TORQUE_OUTPUT_SMOOTHING, 3.0f);
    }

    public static final void addTorqueOutputSmoothingEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_TORQUE_OUTPUT_SMOOTHING, 3.0f);
        list.add(textEditPref);
        textEditPref.set("Output Smoothing", "enter a number from 0 to 100, 1 = no smoothing, < 1 = decay factor, > 1 = running average window length", "-");
        textEditPref.installFinalClipFilter(0.0f, 100.0f, 2);
    }

    public static final float getMileageInputSmoothing(DataPreferences dataPreferences) {
        return dataPreferences.getFloat(PREFS_KEY_MILEAGE_INPUT_SMOOTHING, 20.0f);
    }

    public static final void addMileageInputSmoothingEditPrefs(List list, DataPreferences dataPreferences) {
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MILEAGE_INPUT_SMOOTHING, 20.0f);
        list.add(textEditPref);
        textEditPref.set("Averaging", "number of frames, from 1 to 1000, over which to average", "-");
        textEditPref.installFinalClipFilter(1.0f, 1000.0f, 0);
    }
}

