/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.converter.Base;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.model.UnitsFilter;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.jgoodies.binding.value.ValueModel;

public class DisplayUnits
extends Base {
    private static final String PROP_NAME_TYPE = "converter.type";
    final ValueModel unitsLabelModel;
    UnitsFilter unitsValueFilter;

    public DisplayUnits(DataObject dataObject) {
        super(dataObject);
        String string = dataObject.getString(PROP_NAME_TYPE);
        if (string == null) {
            throw new IllegalArgumentException("Must define type property");
        }
        if (!ListUtil.isInList(string, UnitsHelper.ALL_TYPES)) {
            throw new IllegalArgumentException("Unknown conversion type: " + string);
        }
        this.unitsLabelModel = UnitsHelper.getLabelModelPlug(string);
        if (this.unitsLabelModel == null) {
            throw new IllegalArgumentException("Failed to create label model for " + string);
        }
        this.unitsValueFilter = UnitsHelper.getConversionValueFilter(string);
    }

    protected DisplayUnits(DisplayUnits displayUnits) {
        super(displayUnits);
        this.unitsLabelModel = displayUnits.unitsLabelModel;
        this.unitsValueFilter = displayUnits.unitsValueFilter;
    }

    @Override
    protected float _convert(double d, float f) {
        return this.unitsValueFilter.filter(f);
    }

    @Override
    public Converter createCopy() {
        return new DisplayUnits(this);
    }

    @Override
    public void applyOverrides(DisplayChainDesc displayChainDesc) {
        displayChainDesc.setUnits((String)this.unitsLabelModel.getValue());
        if (displayChainDesc.getMin() != null) {
            displayChainDesc.setMin(new Float(this.unitsValueFilter.filter(displayChainDesc.getMin().floatValue())));
        }
        if (displayChainDesc.getMax() != null) {
            displayChainDesc.setMax(new Float(this.unitsValueFilter.filter(displayChainDesc.getMax().floatValue())));
        }
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        super.loopReset(dataPreferences);
        this.unitsValueFilter.resetUnitsSelection();
    }
}

