/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class FuelFlowCcPerMin
extends Converter {
    float injFlowRateCcPerMin = 450.0f;
    float injDeadTimeAdj = 0.0f;
    float fuelPressurePsig = 43.5f;

    public FuelFlowCcPerMin(DataObject dataObject) {
        super(dataObject.getNodeKey(), 2);
    }

    protected FuelFlowCcPerMin(FuelFlowCcPerMin fuelFlowCcPerMin) {
        super(fuelFlowCcPerMin);
        this.injFlowRateCcPerMin = fuelFlowCcPerMin.injFlowRateCcPerMin;
        this.injDeadTimeAdj = fuelFlowCcPerMin.injDeadTimeAdj;
        this.fuelPressurePsig = fuelFlowCcPerMin.fuelPressurePsig;
    }

    @Override
    protected float convert(double d) {
        float f = this.inputBin[0];
        float f2 = this.inputBin[1];
        float f3 = this.injFlowRateCcPerMin / 60.0f * (f - 0.7f - this.injDeadTimeAdj / 1000.0f) / 1000.0f * f2 * 2.0f;
        return (f3 = (float)((double)f3 * Math.pow((double)this.fuelPressurePsig / 43.5, 0.5))) < 0.0f ? 0.0f : f3;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.injFlowRateCcPerMin = ConverterPrefs.getInjectorSizeCcPerMin(dataPreferences);
        this.injDeadTimeAdj = ConverterPrefs.getInjectorDeadTimeAdjUsecs(dataPreferences);
        this.fuelPressurePsig = ConverterPrefs.getFuelPressurePsig(dataPreferences);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addInjectorSizeEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Fuel flow", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new FuelFlowCcPerMin(this);
    }
}

