/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class FuelFlowCcPerMin640
extends Converter {
    static final float injFlowRateCcPerMin = 640.0f;
    float fuelFlowFactor = 1.0f;
    float injOffsetUsecs = 0.0f;

    public FuelFlowCcPerMin640(DataObject dataObject) {
        super(dataObject.getNodeKey(), 2);
    }

    protected FuelFlowCcPerMin640(FuelFlowCcPerMin640 fuelFlowCcPerMin640) {
        super(fuelFlowCcPerMin640);
        this.fuelFlowFactor = fuelFlowCcPerMin640.fuelFlowFactor;
        this.injOffsetUsecs = fuelFlowCcPerMin640.injOffsetUsecs;
    }

    @Override
    protected float convert(double d) {
        float f = this.inputBin[0];
        float f2 = this.inputBin[1];
        float f3 = 10.666667f * (f * this.fuelFlowFactor + this.injOffsetUsecs / 1000.0f) / 1000.0f * f2 * 2.0f;
        return f3 < 0.0f ? 0.0f : f3;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.fuelFlowFactor = ConverterPrefs.getFuelFlowFactor(dataPreferences);
        this.injOffsetUsecs = ConverterPrefs.getInjectorOffsetUsecs(dataPreferences);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addFuelFlowEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Fuel flow", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new FuelFlowCcPerMin640(this);
    }
}

