/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Base;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class GLon
extends Base {
    float correction = 0.0f;

    public GLon(DataObject dataObject) {
        super(dataObject);
    }

    protected GLon(GLon gLon) {
        super(gLon);
        this.correction = gLon.correction;
    }

    @Override
    protected float _convert(double d, float f) {
        return (float)((double)(f - this.correction) / Math.cos(Math.asin(this.correction)));
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.correction = ConverterPrefs.getGCorrection(dataPreferences);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addGLonCorrectionEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Longitudinal G", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new GLon(this);
    }
}

