/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GLonFromRPM
extends Converter {
    protected int inputSmoothing;
    boolean firstTime = true;
    float previousAccelmps2;
    float previousRpmPermps;
    float[] prevVelocitymps;
    float[] prevCrankTimeSec;
    int index;

    public GLonFromRPM(DataObject dataObject) {
        super(dataObject.getNodeKey(), 3);
    }

    protected GLonFromRPM(GLonFromRPM gLonFromRPM) {
        super(gLonFromRPM);
    }

    @Override
    protected float convert(double d) {
        float f;
        float f2 = this.inputBin[0];
        float f3 = this.inputBin[1] / 1000.0f;
        float f4 = this.inputBin[2];
        float f5 = f4 / 1.609344f;
        float f6 = 3.6f * f5;
        float f7 = f2 / f6;
        if (this.firstTime) {
            f = 0.0f;
            this.firstTime = false;
        } else {
            float f8 = f3 - this.prevCrankTimeSec[this.index];
            f = f8 <= 0.0f ? this.previousAccelmps2 : (f7 - this.prevVelocitymps[this.index]) / f8;
            this.prevVelocitymps[this.index] = f7;
            this.prevCrankTimeSec[this.index++] = f3;
            if (this.index >= this.inputSmoothing) {
                this.index = 0;
            }
        }
        if (f <= 0.0f || this.previousRpmPermps != f6) {
            f = 0.0f;
            Arrays.fill(this.prevVelocitymps, f7);
            Arrays.fill(this.prevCrankTimeSec, f3);
            this.index = 0;
        }
        this.previousAccelmps2 = f;
        this.previousRpmPermps = f6;
        return f / 9.80665f;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.firstTime = true;
        this.inputSmoothing = (int)ConverterPrefs.getTorqueInputSmoothing(dataPreferences);
        this.prevVelocitymps = new float[this.inputSmoothing];
        this.prevCrankTimeSec = new float[this.inputSmoothing];
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addTorqueInputSmoothingEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Acceleration", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new GLonFromRPM(this);
    }
}

